/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.palettetreenodes;

import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.AccessibleComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.CreationToolNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.OfflineComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.RootNode;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.gef.Tool;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;

public abstract class PaletteTreeNode
extends TreeNode
implements Comparable<PaletteTreeNode> {
    private String nodeName;
    private Optional<String> shortKey = Optional.empty();
    private Image icon;

    protected PaletteTreeNode(TreeNode parent, String nodeName) {
        super((Object)nodeName);
        this.nodeName = nodeName;
        this.setParent(parent);
    }

    public static RootNode createRootNode(PaletteViewContentProvider contentProvider) {
        return new RootNode(contentProvider);
    }

    public static PaletteTreeNode createGroupNode(PaletteTreeNode parent, String nodeName) {
        return new GroupNode(parent, nodeName);
    }

    public static AccessibleComponentNode createToolNode(PaletteTreeNode parent, DistributedComponentEntry toolEntry, ToolIdentification toolIdentification) {
        return new AccessibleComponentNode(parent, toolEntry, toolIdentification);
    }

    public static OfflineComponentNode createOfflineComponentNode(PaletteTreeNode parent, ToolIdentification toolIdentification) {
        return new OfflineComponentNode((TreeNode)parent, toolIdentification);
    }

    public static CreationToolNode createBasicToolNode(PaletteTreeNode parent, String nodeName, Tool tool, Image icon) {
        return new CreationToolNode(parent, nodeName, tool, icon);
    }

    public String getQualifiedGroupName() {
        return this.getPath(this.nodeName, this);
    }

    private String getPath(String path, PaletteTreeNode node) {
        TreeNode parent = node.getParent();
        if (!(parent instanceof PaletteTreeNode) || node.getPaletteParent().isRoot()) {
            return path;
        }
        return this.getPath(((PaletteTreeNode)parent).getNodeName(), (PaletteTreeNode)parent).concat(StringUtils.format((String)"%s%s", (Object[])new Object[]{"/", node.getNodeName()}));
    }

    public abstract void handleDoubleclick(PaletteView var1);

    public abstract void handleWidgetSelected(WorkflowEditor var1);

    public abstract void handleEditEvent();

    public abstract boolean canHandleEditEvent();

    public abstract Optional<String> getHelpContextID();

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isRoot() {
        return this instanceof RootNode;
    }

    public boolean isGroup() {
        return this instanceof GroupNode;
    }

    public boolean isAccessibleComponent() {
        return this instanceof AccessibleComponentNode;
    }

    public boolean isOfflineComponent() {
        return this instanceof OfflineComponentNode;
    }

    public boolean isCreationTool() {
        return this instanceof CreationToolNode;
    }

    public GroupNode getGroupNode() {
        return (GroupNode)this;
    }

    public AccessibleComponentNode getAccessibleComponentNode() {
        return (AccessibleComponentNode)this;
    }

    public OfflineComponentNode getOfflineComponentNode() {
        return (OfflineComponentNode)this;
    }

    public CreationToolNode getCreationToolNode() {
        return (CreationToolNode)this;
    }

    public RootNode getRootNode() {
        return (RootNode)this;
    }

    public void addChild(PaletteTreeNode child) {
        ArrayList<Object> children = this.getChildren() != null ? new ArrayList<TreeNode>(Arrays.asList(this.getChildren())) : new ArrayList();
        if (!children.contains(child)) {
            children.add(child);
        }
        this.setChildren(children.toArray(new PaletteTreeNode[children.size()]));
    }

    public void removeChild(TreeNode child) {
        if (this.hasChildren()) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(Arrays.asList(this.getChildren()));
            children.remove(child);
            this.setChildren(children.toArray(new PaletteTreeNode[children.size()]));
        }
    }

    public List<GroupNode> getAllSubGroups() {
        return this.getAllSubGroups(this);
    }

    public List<GroupNode> getAllSubGroups(PaletteTreeNode parent) {
        ArrayList<GroupNode> nodeList = new ArrayList<GroupNode>();
        if (parent.getChildren() == null) {
            return nodeList;
        }
        Arrays.stream(parent.getChildren()).filter(GroupNode.class::isInstance).map(GroupNode.class::cast).filter(PaletteTreeNode::isGroup).forEach(child -> {
            nodeList.addAll(this.getAllSubGroups((PaletteTreeNode)child));
            nodeList.add((GroupNode)child);
        });
        return nodeList;
    }

    public List<PaletteTreeNode> getSubGroups() {
        ArrayList<PaletteTreeNode> nodeList = new ArrayList<PaletteTreeNode>();
        if (this.getChildren() == null) {
            return nodeList;
        }
        TreeNode[] treeNodeArray = this.getChildren();
        int n = treeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            PaletteTreeNode node = (PaletteTreeNode)child;
            if (node.isGroup()) {
                nodeList.add(node);
            }
            ++n2;
        }
        return nodeList;
    }

    public abstract boolean isCustomized();

    public Optional<Image> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public String getDisplayName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Optional<String> getShortKey() {
        return this.shortKey;
    }

    public void setShortKey(String shortKey) {
        this.shortKey = Optional.of(shortKey);
    }

    public RootNode getPaletteRoot() {
        if (this.isRoot()) {
            return this.getRootNode();
        }
        return this.getPaletteParent().getPaletteRoot();
    }

    public PaletteViewContentProvider getContentProvider() {
        return this.getPaletteRoot().getContentProvider();
    }

    public int hashCode() {
        return this.getQualifiedGroupName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaletteTreeNode other = (PaletteTreeNode)obj;
        return !(this.getNodeName() == null ? other.getNodeName() != null : !this.getQualifiedGroupName().equals(other.getQualifiedGroupName()));
    }

    @Override
    public int compareTo(PaletteTreeNode o) {
        return this.getQualifiedGroupName().compareToIgnoreCase(o.getQualifiedGroupName());
    }

    public PaletteTreeNode getPaletteParent() {
        TreeNode node = super.getParent();
        if (node instanceof PaletteTreeNode) {
            return (PaletteTreeNode)node;
        }
        throw new ClassCastException("All tree nodes in the palette tree are expected to be instance of type PaletteTreeNode.");
    }
}

