/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.execution;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;

public class DOEPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String LOOP_ENDPOINT_TYPE = "loopEndpointType_5e0ed1cd";
    private static final String METADATA = "metadata";
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private static final String V3_2 = "3.2";
    private static final String V3_3 = "3.3";
    private static final String V3_4 = "3.4";
    private static final String V4 = "4";
    private static final String V4_1 = "4.1";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String STATIC_OUTPUTS = "staticOutputs";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return new String[]{"de.rcenvironment.doe.v2"};
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_4) < 0) {
            versionsToUpdate |= 4;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V4) < 0) {
            versionsToUpdate |= 4;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V4_1) < 0) {
            versionsToUpdate |= 4;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block30: {
            block29: {
                if (!silent) break block29;
                if (formatVersion != 4) break block30;
                switch (description.getComponentVersion()) {
                    case "3.0": {
                        description = this.updateToVersion31(description);
                    }
                    case "3.1": {
                        description = this.updateToVersion32(description);
                    }
                    case "3.2": {
                        description = this.updateToVersion33(description);
                    }
                    case "3.3": {
                        description = this.updateToVersion34(description);
                    }
                }
                break block30;
            }
            if (formatVersion != 4) break block30;
            switch (description.getComponentVersion()) {
                case "3.3": {
                    description = this.updateToVersion34(description);
                }
                case "3.4": {
                    description = this.updatefrom34To4(description);
                }
                case "4": {
                    description = this.updatefrom4To41(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updatefrom4To41(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.addStaticOutput((PersistentComponentDescription)description, (String)"Number of samples", (String)"Integer");
        description.setComponentVersion(V4_1);
        return description;
    }

    private PersistentComponentDescription updatefrom34To4(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoints((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_INPUTS, (String)"toForward", (String)"startToForward", (String)"_start");
        description.setComponentVersion(V4);
        return description;
    }

    private PersistentComponentDescription updateToVersion34(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        PersistentComponentDescription updatedDesc = PersistentComponentDescriptionUpdaterUtils.updateFaultToleranceOfLoopDriver((PersistentComponentDescription)description);
        updatedDesc.setComponentVersion(V3_4);
        return updatedDesc;
    }

    private PersistentComponentDescription updateToVersion33(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        JsonNode dynamicInputs;
        JsonNode dynamicOutputs;
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                Iterator metaData = (ObjectNode)outputEndpoint.get(METADATA);
                if (metaData == null) {
                    metaData = JsonNodeFactory.instance.objectNode();
                    ((ObjectNode)outputEndpoint).set(METADATA, (JsonNode)metaData);
                }
                if (outputEndpoint.get("name").textValue().equals("Outer loop done")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, "InnerLoopEndpoint");
                }
                if (!outputEndpoint.get("name").textValue().equals("Done")) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, "OuterLoopEndpoint");
            }
        }
        if ((dynamicOutputs = node.get("dynamicOutputs")) != null) {
            for (JsonNode outputEndpoint : dynamicOutputs) {
                Iterator metaData = (ObjectNode)outputEndpoint.get(METADATA);
                metaData.put(LOOP_ENDPOINT_TYPE, "SelfLoopEndpoint");
            }
        }
        if ((dynamicInputs = node.get(DYNAMIC_INPUTS)) != null) {
            for (JsonNode inputEndpoint : dynamicInputs) {
                ObjectNode metaData = (ObjectNode)inputEndpoint.get(METADATA);
                metaData.put(LOOP_ENDPOINT_TYPE, "SelfLoopEndpoint");
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V3_3);
        return newdesc;
    }

    private PersistentComponentDescription updateToVersion31(PersistentComponentDescription description) {
        description.setComponentVersion(V3_1);
        return description;
    }

    private PersistentComponentDescription updateToVersion32(PersistentComponentDescription description) {
        description.setComponentVersion(V3_2);
        return description;
    }
}

