/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.util.function.Consumer;
import org.eclipse.core.resources.ResourcesPlugin;

public class OutputWriterPathResolver {
    private static final String FRONTSLASH = "/";
    private static final String BACKSLASHES = "\\";
    private final Consumer<String> logWarning;

    public OutputWriterPathResolver(Consumer<String> logWarning) {
        this.logWarning = logWarning;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String adaptRootToAbsoluteRootIfProjectRelative(String rootToBeAdapted) throws ComponentException {
        String absoluteRoot = rootToBeAdapted;
        if (rootToBeAdapted.contains(FRONTSLASH) && rootToBeAdapted.contains(BACKSLASHES)) {
            throw new ComponentException(StringUtils.format((String)"Given path to file or directory could not be resolved, as it contains front and backslash as well: %s", (Object[])new Object[]{rootToBeAdapted}));
        }
        File file = new File(rootToBeAdapted);
        if (file.isAbsolute()) return absoluteRoot;
        if (rootToBeAdapted.startsWith("${dir:workspace}/")) {
            if (!ResourcesPlugin.getWorkspace().getRoot().exists()) throw new ComponentException(StringUtils.format((String)"Failed to resolve root location '%s' because the workspace could not be determined. Note that in headless mode relative paths are not supported.", (Object[])new Object[]{rootToBeAdapted}));
            this.checkRelativePathForValidProject(rootToBeAdapted);
            String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            return rootToBeAdapted.replace("${dir:workspace}", workspacePath);
        }
        this.logWarning.accept(StringUtils.format((String)"Note that from version 9.0 on relative paths have to start explicitly with the prefix '%s'. Relative paths without this prefix are not resolved and result in a workflowfailure.", (Object[])new Object[]{"${dir:workspace}"}));
        return absoluteRoot;
    }

    private void checkRelativePathForValidProject(String relativePath) throws ComponentException {
        if (relativePath.split(FRONTSLASH).length < 2) {
            throw new ComponentException(StringUtils.format((String)"Cannot resolve root location '%s' because it contains no project.", (Object[])new Object[]{relativePath}));
        }
        String projectName = relativePath.split(FRONTSLASH)[1];
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists()) {
            throw new ComponentException(StringUtils.format((String)"Failed to resolve root location '%s' because the given project '%s' could not be found.", (Object[])new Object[]{relativePath, projectName}));
        }
    }
}

