/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.validation.api;

import de.rcenvironment.core.utils.common.StringUtils;

public class ComponentValidationMessage {
    private final Type type;
    private final String property;
    private final String relativeMessage;
    private final String absoluteMessage;
    private final boolean revalidateOnWorkflowStart;

    public ComponentValidationMessage(Type type, String property, String relativeMessage, String absoluteMessage) {
        this(type, property, relativeMessage, absoluteMessage, false);
    }

    public ComponentValidationMessage(Type type, String property, String relativeMessage, String absoluteMessage, boolean revalidateOnWorkflowStart) {
        this.type = type;
        this.property = property;
        this.relativeMessage = relativeMessage;
        this.absoluteMessage = absoluteMessage;
        this.revalidateOnWorkflowStart = revalidateOnWorkflowStart;
    }

    public Type getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    public String getRelativeMessage() {
        return this.relativeMessage;
    }

    public String getAbsoluteMessage() {
        return this.absoluteMessage;
    }

    public boolean isRevalidateOnWorkflowStart() {
        return this.revalidateOnWorkflowStart;
    }

    public String toString() {
        if (this.property != null && !this.property.isEmpty() && this.relativeMessage != null && !this.relativeMessage.isEmpty()) {
            return StringUtils.format((String)"%s: %s", (Object[])new Object[]{this.property, this.relativeMessage});
        }
        return this.absoluteMessage;
    }

    public int hashCode() {
        int result = 1;
        result = this.absoluteMessage != null ? 31 * result + this.absoluteMessage.hashCode() : (result *= 31);
        result = this.property != null ? 31 * result + this.property.hashCode() : (result *= 31);
        result = this.relativeMessage != null ? 31 * result + this.relativeMessage.hashCode() : (result *= 31);
        result = this.type != null ? 31 * result + this.type.hashCode() : (result *= 31);
        result = this.revalidateOnWorkflowStart ? 31 * result + 1231 : 31 * result + 1237;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentValidationMessage)) {
            return false;
        }
        ComponentValidationMessage other = (ComponentValidationMessage)obj;
        if (this.absoluteMessage == null ? other.absoluteMessage != null : !this.absoluteMessage.equals(other.absoluteMessage)) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        if (this.relativeMessage == null ? other.relativeMessage != null : !this.relativeMessage.equals(other.relativeMessage)) {
            return false;
        }
        if (this.revalidateOnWorkflowStart != other.revalidateOnWorkflowStart) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Type {
        WARNING,
        ERROR;

    }
}

