/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.spi;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.model.spi.AbstractLoopComponent;

public abstract class AbstractNestedLoopComponent
extends AbstractLoopComponent {
    private boolean isFinallyDone = false;
    private boolean isReset;

    @Override
    public void startComponentSpecific() throws ComponentException {
        this.startNestedComponentSpecific();
    }

    @Override
    public void processInputsComponentSpecific() throws ComponentException {
        if (this.loopFailed) {
            this.isReset = true;
            this.sendReset();
        } else {
            this.processInputsNestedComponentSpecific();
            if (this.isDone()) {
                this.loopIsFinished();
            } else {
                this.sendValuesNestedComponentSpecific();
            }
        }
    }

    @Override
    public void resetComponentSpecific() throws ComponentException {
        this.resetNestedComponentSpecific();
        this.startNestedComponentSpecific();
        this.isReset = false;
    }

    @Override
    protected boolean isDone() {
        return this.isDoneNestedComponentSpecific() || !this.isNestedLoop() && this.isFinallyDone();
    }

    @Override
    protected boolean isFinallyDone() {
        return this.isFinallyDone;
    }

    @Override
    protected boolean isReset() {
        return this.isReset;
    }

    private void loopIsFinished() throws ComponentException {
        if (this.isNestedLoop()) {
            this.isReset = true;
            this.sendReset();
        } else {
            this.outerLoopIsFinished();
        }
    }

    private void outerLoopIsFinished() throws ComponentException {
        this.finishLoop(true);
    }

    @Override
    protected void finishLoopComponentSpecific(boolean outerLoopFinished) throws ComponentException {
        this.finishLoop(outerLoopFinished);
    }

    private void finishLoop(boolean outerLoopFinished) throws ComponentException {
        if (outerLoopFinished) {
            this.isFinallyDone = true;
            if (!this.isNestedLoop()) {
                this.sendFinalValues();
                this.finishLoopNestedComponentSpecific();
            }
        } else {
            this.sendFinalValues();
            this.finishLoopNestedComponentSpecific();
        }
    }

    protected void startNestedComponentSpecific() throws ComponentException {
    }

    protected void processInputsNestedComponentSpecific() throws ComponentException {
    }

    protected abstract void resetNestedComponentSpecific();

    protected abstract void finishLoopNestedComponentSpecific();

    protected abstract boolean isDoneNestedComponentSpecific();

    protected abstract void sendFinalValues() throws ComponentException;

    protected void sendReset() {
        this.componentContext.resetOutputs();
    }

    protected abstract void sendValuesNestedComponentSpecific();
}

