/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.Serializable;
import org.apache.commons.logging.LogFactory;

public class ComponentInstallationImpl
implements ComponentInstallation,
Serializable {
    private static final long serialVersionUID = 3895539478658080757L;
    private LogicalNodeId nodeId;
    private ComponentRevisionImpl componentRevision;
    private String installationId;
    private Integer maximumCountOfParallelInstances = null;
    private boolean mappedComponent = false;

    @Override
    public boolean isMappedComponent() {
        return this.mappedComponent;
    }

    public void setMappedComponent(boolean isMapped) {
        this.mappedComponent = isMapped;
    }

    @Override
    public String getNodeId() {
        if (this.nodeId == null) {
            return null;
        }
        return this.nodeId.getLogicalNodeIdString();
    }

    @Override
    @JsonIgnore
    public LogicalNodeId getNodeIdObject() {
        return this.nodeId;
    }

    public void setNodeId(String idString) {
        this.nodeId = idString != null ? NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)idString) : null;
    }

    @JsonIgnore
    public void setNodeIdObject(LogicalNodeId nodeIdObject) {
        this.nodeId = nodeIdObject;
    }

    @Override
    public ComponentRevision getComponentRevision() {
        if (this.componentRevision == null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Undefined component revision");
        }
        return this.componentRevision;
    }

    @Override
    @JsonIgnore
    public ComponentInterface getComponentInterface() {
        if (this.componentRevision == null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Undefined component revision; returning null ComponentInterface");
            return null;
        }
        return this.componentRevision.getComponentInterface();
    }

    public void setComponentRevision(ComponentRevisionImpl componentRevision) {
        this.componentRevision = componentRevision;
    }

    @Override
    public String getInstallationId() {
        if (this.installationId == null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Undefined installation id");
        }
        return this.installationId;
    }

    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    @Override
    public Integer getMaximumCountOfParallelInstances() {
        return this.maximumCountOfParallelInstances;
    }

    public void setMaximumCountOfParallelInstances(Integer maximumCountOfParallelInstances) {
        this.maximumCountOfParallelInstances = maximumCountOfParallelInstances;
    }

    public String toString() {
        return StringUtils.format((String)"ComponentInstallation(node=%s,rev=%s)", (Object[])new Object[]{this.nodeId, this.componentRevision});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentInstallationImpl)) {
            return false;
        }
        ComponentInstallationImpl other = (ComponentInstallationImpl)obj;
        return this.nodeId.equals(other.nodeId) && this.getInstallationId().equals(other.getInstallationId());
    }

    public int hashCode() {
        return this.nodeId.hashCode() ^ this.installationId.hashCode();
    }

    @Override
    public int compareTo(ComponentInstallation o) {
        return this.getComponentInterface().getDisplayName().compareTo(o.getComponentInterface().getDisplayName());
    }
}

