/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.impl;

import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import java.util.Collection;
import java.util.stream.Collectors;

public final class ComponentImageUtility {
    private static final int MINUS_ONE = -1;

    private ComponentImageUtility() {
    }

    public static String getNormalId(String componentId) {
        int idStart = componentId.indexOf("de");
        if (idStart != -1) {
            return componentId.substring(idStart, componentId.length());
        }
        return componentId;
    }

    public static Collection<DistributedComponentEntry> getDistinctInstallations(Collection<DistributedComponentEntry> inputCollection) {
        return inputCollection.stream().collect(Collectors.toMap(entry -> entry.getComponentInterface().getIdentifierAndVersion(), entry -> entry, (entryA, entryB) -> {
            if (entryA.getType().isLocal() && !entryB.getType().isLocal()) {
                return entryA;
            }
            if (!entryA.getType().isLocal() && entryB.getType().isLocal()) {
                return entryB;
            }
            if (!entryA.getType().isLocal() && !entryB.getType().isLocal()) {
                if (entryA.getComponentInterface().getIdentifierAndVersion().compareTo(entryB.getComponentInterface().getIdentifierAndVersion()) <= 0) {
                    return entryA;
                }
                return entryB;
            }
            return null;
        })).values();
    }
}

