/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.endpoint.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class EndpointDescription
extends EndpointGroupDescription {
    private static final long serialVersionUID = -3853446362359127472L;
    private static TypedDatumConverter typedDatumConverter;
    private EndpointDefinition endpointDefinition;
    private DataType dataType;
    private Map<String, String> metaData;
    private Map<DataType, Integer> connectedDataTypes;
    private String identifier;

    @Deprecated
    public EndpointDescription() {
    }

    public EndpointDescription(EndpointDefinition newEndpointDefinition, String identifier) {
        super(newEndpointDefinition);
        this.endpointDefinition = newEndpointDefinition;
        this.identifier = identifier;
        this.metaData = new HashMap<String, String>();
        if (this.endpointDefinition != null) {
            this.dataType = this.endpointDefinition.getDefaultDataType();
            EndpointMetaDataDefinition metaDataDesc = this.endpointDefinition.getMetaDataDefinition();
            for (String key : metaDataDesc.getMetaDataKeys()) {
                if (metaDataDesc.getDefaultValue(key) == null) continue;
                this.metaData.put(key, metaDataDesc.getDefaultValue(key));
            }
        }
        this.connectedDataTypes = new HashMap<DataType, Integer>();
    }

    public EndpointDescription(EndpointDefinition newEndpointDefinition, EndpointType endpointType) {
        this(newEndpointDefinition, UUID.randomUUID().toString());
    }

    public EndpointDefinition getEndpointDefinition() {
        return this.endpointDefinition;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType type) {
        if (this.endpointDefinition != null && !this.endpointDefinition.getPossibleDataTypes().contains(type)) {
            throw new IllegalArgumentException(StringUtils.format((String)"Given data type '%s' for endpoint '%s' is invalid", (Object[])new Object[]{type, this.getName()}));
        }
        this.dataType = type;
    }

    public boolean isDataTypeValid(DataType type) {
        if (this.endpointDefinition == null || !this.endpointDefinition.getPossibleDataTypes().contains(type)) {
            return false;
        }
        for (DataType t : this.connectedDataTypes.keySet()) {
            if (!(this.endpointDefinition.getEndpointType() == EndpointType.INPUT ? t != type && !typedDatumConverter.isConvertibleTo(t, type) : t != type && !typedDatumConverter.isConvertibleTo(type, t))) continue;
            return false;
        }
        return true;
    }

    public String getMetaDataValue(String key) {
        return this.metaData.get(key);
    }

    public Map<String, String> getActiveMetaData(Map<String, String> configuration) {
        HashMap<String, String> activeMetaData = new HashMap<String, String>();
        for (String metaDataKey : this.metaData.keySet()) {
            Map<String, List<String>> activationFilter = this.endpointDefinition.getMetaDataDefinition().getActivationFilter(metaDataKey);
            for (String configKey : activationFilter.keySet()) {
                if (!configuration.containsKey(configKey) || !activationFilter.get(configKey).contains(configuration.get(configKey))) continue;
                activeMetaData.put(metaDataKey, this.metaData.get(metaDataKey));
            }
        }
        return activeMetaData;
    }

    public Map<String, String> getMetaDataToPersist() {
        HashMap<String, String> persistentMetaData = new HashMap<String, String>();
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        for (String metaDataKey : this.metaData.keySet()) {
            if (!this.endpointDefinition.getMetaDataDefinition().isPersistent(metaDataKey)) continue;
            ObjectNode rootNode = mapper.createObjectNode();
            rootNode.put("guiName", this.endpointDefinition.getMetaDataDefinition().getGuiName(metaDataKey));
            rootNode.put("value", this.getMetaDataValue(metaDataKey));
            persistentMetaData.put(metaDataKey, rootNode.toString());
        }
        return persistentMetaData;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaDataValue(String key, String value) {
        this.metaData.put(key, value);
    }

    public void setMetaData(Map<String, String> newMetaData) {
        this.metaData = newMetaData;
    }

    public void addConnectedDataType(DataType type) {
        if (this.connectedDataTypes.containsKey(type) && this.connectedDataTypes.get(type) != 0) {
            this.connectedDataTypes.put(type, this.connectedDataTypes.get(type) + 1);
        } else {
            this.connectedDataTypes.put(type, 1);
        }
    }

    public void removeConnectedDataType(DataType type) {
        if (this.connectedDataTypes.containsKey(type)) {
            this.connectedDataTypes.put(type, this.connectedDataTypes.get(type) - 1);
            if (this.connectedDataTypes.get(type) <= 0) {
                this.connectedDataTypes.remove(type);
            }
        }
    }

    public List<DataType> getConnectedDataTypes() {
        return new ArrayList<DataType>(this.connectedDataTypes.keySet());
    }

    public boolean isConnected() {
        return !this.connectedDataTypes.isEmpty();
    }

    public boolean isRequired() {
        if (this.endpointDefinition == null || this.endpointDefinition.getEndpointType().equals((Object)EndpointType.OUTPUT)) {
            return false;
        }
        EndpointDefinition.InputExecutionContraint exeConstraint = this.getEndpointDefinition().getDefaultInputExecutionConstraint();
        if (this.getMetaDataValue("inputExecutionConstraint_4aae3eea") != null) {
            exeConstraint = EndpointDefinition.InputExecutionContraint.valueOf(this.getMetaDataValue("inputExecutionConstraint_4aae3eea"));
        }
        return exeConstraint.equals((Object)EndpointDefinition.InputExecutionContraint.Required);
    }

    public static EndpointDescription copy(EndpointDescription endpointDescription) {
        EndpointDescription copiedDesc = new EndpointDescription(endpointDescription.getEndpointDefinition(), endpointDescription.getIdentifier());
        copiedDesc.setDataType(endpointDescription.getDataType());
        copiedDesc.setDynamicEndpointIdentifier(endpointDescription.getDynamicEndpointIdentifier());
        copiedDesc.setParentGroupName(endpointDescription.getParentGroupName());
        for (DataType type : endpointDescription.getConnectedDataTypes()) {
            copiedDesc.addConnectedDataType(type);
        }
        for (String key : endpointDescription.getMetaData().keySet()) {
            if (endpointDescription.getMetaData().get(key) == null) continue;
            copiedDesc.setMetaDataValue(key, endpointDescription.getMetaData().get(key));
        }
        if (endpointDescription.getEndpointDefinition() == null || !endpointDescription.getEndpointDefinition().isStatic()) {
            copiedDesc.setName(endpointDescription.getName());
        }
        return copiedDesc;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String newIdentifier) {
        this.identifier = newIdentifier;
    }

    protected void bindTypedDatumService(TypedDatumService typedDatumService) {
        typedDatumConverter = typedDatumService.getConverter();
    }
}

