/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.internal;

import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.api.DistributedComponentEntryType;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.LogFactory;

public class DistributedComponentEntryImpl
implements DistributedComponentEntry {
    private final String displayName;
    private final ComponentInstallation componentInstallation;
    private final DistributedComponentEntryType type;
    private final AuthorizationPermissionSet declaredPermissionSet;
    private final AuthorizationPermissionSet matchingPermissionSet;
    private final String publicationData;

    public DistributedComponentEntryImpl(String displayNameParam, ComponentInstallation componentInstallation, AuthorizationPermissionSet declaredPermissionSetParam, AuthorizationPermissionSet matchingPermissionSetParam, boolean remote, String publicationDataParam) {
        boolean localExecutionOnly;
        this.displayName = displayNameParam;
        this.componentInstallation = componentInstallation;
        this.declaredPermissionSet = declaredPermissionSetParam;
        this.matchingPermissionSet = matchingPermissionSetParam;
        boolean bl = localExecutionOnly = componentInstallation != null && componentInstallation.getComponentInterface() != null && componentInstallation.getComponentInterface().getLocalExecutionOnly();
        if (remote) {
            if (localExecutionOnly) {
                LogFactory.getLog(this.getClass()).error((Object)("Inconsistent state: Received a remote component from " + componentInstallation.getNodeId() + " with the local-only flag set"));
            }
            this.type = DistributedComponentEntryType.REMOTE;
        } else {
            this.type = localExecutionOnly ? DistributedComponentEntryType.FORCED_LOCAL : (declaredPermissionSetParam == null || declaredPermissionSetParam.isLocalOnly() ? DistributedComponentEntryType.LOCAL : DistributedComponentEntryType.SHARED);
        }
        this.publicationData = publicationDataParam;
    }

    @Override
    public DistributedComponentEntryType getType() {
        return this.type;
    }

    @Override
    public AuthorizationPermissionSet getDeclaredPermissionSet() {
        return this.declaredPermissionSet;
    }

    @Override
    public AuthorizationPermissionSet getMatchingPermissionSet() {
        return this.matchingPermissionSet;
    }

    @Override
    public boolean isAccessible() {
        return this.componentInstallation != null;
    }

    @Override
    public ComponentInstallation getComponentInstallation() {
        return this.componentInstallation;
    }

    @Override
    public ComponentRevision getComponentRevision() {
        return this.componentInstallation.getComponentRevision();
    }

    @Override
    public ComponentInterface getComponentInterface() {
        return this.componentInstallation.getComponentInterface();
    }

    @Override
    public String getPublicationData() {
        return this.publicationData;
    }

    @Override
    public String getNodeId() {
        return this.componentInstallation.getNodeId();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{this.componentInstallation.getInstallationId(), this.declaredPermissionSet.toString()});
    }
}

