/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.api.ReliableRPCStreamHandle;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.authorization.api.ComponentExecutionAuthorizationService;
import de.rcenvironment.core.component.execution.api.ComponentControllerRoutingMap;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionController;
import de.rcenvironment.core.component.execution.api.ComponentExecutionControllerService;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.EndpointDatumSerializer;
import de.rcenvironment.core.component.execution.api.ExecutionContext;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.RemotableComponentExecutionControllerService;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallbackService;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionContextImpl;
import de.rcenvironment.core.component.execution.impl.ComponentExecutionInformationImpl;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionControllerImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDatumRecipientImpl;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class ComponentExecutionControllerServiceImpl
implements ComponentExecutionControllerService,
RemotableComponentExecutionControllerService {
    private static final boolean VERBOSE_LOGGING = DebugSettings.getVerboseLoggingEnabled((String)"WorkflowExecution");
    private static final int CANCEL_TIMEOUT_MSEC = 60000;
    private static final int COMPONENT_CONTROLLER_GARBAGE_COLLECTION_INTERVAL_MSEC = 90000;
    private BundleContext bundleContext;
    private CommunicationService communicationService;
    private LocalExecutionControllerUtilsService exeCtrlUtilsService;
    private DistributedComponentKnowledgeService compKnowledgeService;
    private ComponentExecutionAuthorizationService componentExecutionAuthorizationService;
    private EndpointDatumSerializer endpointDatumSerializer;
    private Map<String, ServiceRegistration<?>> componentServiceRegistrations = Collections.synchronizedMap(new HashMap());
    private Map<String, ComponentExecutionInformation> componentExecutionInformations = Collections.synchronizedMap(new HashMap());
    private ScheduledFuture<?> componentControllerGarbargeCollectionFuture;
    private final Log log = LogFactory.getLog(this.getClass());
    private PlatformService platformService;

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
        this.componentControllerGarbargeCollectionFuture = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Garbage collection: Component controllers", this::runGarbageCollection, 90000L);
    }

    @Deactivate
    protected void deactivate() {
        if (this.componentControllerGarbargeCollectionFuture != null) {
            this.componentControllerGarbargeCollectionFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public String createExecutionController(ComponentExecutionContext compExeCtx, String authToken, Long currentTimestampOnWorkflowNode) throws ComponentExecutionException, RemoteOperationException {
        ReliableRPCStreamHandle commonWfControllerNetworkDestination;
        if (!this.checkComponentExecutionAuthorization(compExeCtx, authToken)) {
            this.log.debug((Object)("Verification of a provided authorization token failed; aborting creation of component controller " + compExeCtx.getExecutionIdentifier()));
            throw new ComponentExecutionException(StringUtils.format((String)"The workflow initiator's permission to execute \"%s\" could not be verified; if you think this is an error, try starting the workflow again", (Object[])new Object[]{compExeCtx.getInstanceName()}));
        }
        HashMap<String, String> searchProperties = new HashMap<String, String>();
        searchProperties.put("rce.component.execution.id", compExeCtx.getWorkflowExecutionIdentifier());
        ComponentControllerRoutingMap componentControllerRoutingMap = new ComponentControllerRoutingMap();
        LogicalNodeId wfControllerNodeId = compExeCtx.getWorkflowNodeId();
        LogicalNodeId wfStorageNodeId = compExeCtx.getStorageNodeId();
        if (!wfControllerNodeId.equals(wfStorageNodeId)) {
            throw new IllegalStateException();
        }
        try {
            commonWfControllerNetworkDestination = this.communicationService.createReliableRPCStream((ResolvableNodeId)wfControllerNodeId);
        }
        catch (RemoteOperationException e) {
            throw new ComponentExecutionException("Failed to set up a reliable communication channel from component to workflow controller", e);
        }
        ((ComponentExecutionContextImpl)compExeCtx).setStorageNetworkDestination((NetworkDestination)commonWfControllerNetworkDestination);
        WorkflowExecutionControllerCallbackService wfExeCtrlCallbackService = (WorkflowExecutionControllerCallbackService)this.communicationService.getRemotableService(WorkflowExecutionControllerCallbackService.class, (NetworkDestination)commonWfControllerNetworkDestination);
        List<EndpointDatumRecipient> deserializedEndpointDatumRecipients = ((ComponentExecutionContextImpl)compExeCtx).deserializeEndpointDatumRecipients(this.communicationService);
        for (EndpointDatumRecipient recipient : deserializedEndpointDatumRecipients) {
            String componentExecutionIdentifier = recipient.getInputsComponentExecutionIdentifier();
            NetworkDestination networkDestination = componentControllerRoutingMap.getNetworkDestinationForComponentController(componentExecutionIdentifier);
            if (networkDestination == null) {
                networkDestination = this.determineNetworkDestinationForComponentController(recipient, (ResolvableNodeId)wfControllerNodeId);
                componentControllerRoutingMap.setNetworkDestinationForComponentController(componentExecutionIdentifier, networkDestination);
            }
            ((EndpointDatumRecipientImpl)recipient).setNetworkDestination(networkDestination);
        }
        ComponentExecutionControllerImpl componentController = new ComponentExecutionControllerImpl(compExeCtx, wfExeCtrlCallbackService, (NetworkDestination)commonWfControllerNetworkDestination, currentTimestampOnWorkflowNode);
        String executionId = compExeCtx.getExecutionIdentifier();
        this.registerExecutionController(componentController, executionId);
        ComponentExecutionInformationImpl componentExecutionInformation = new ComponentExecutionInformationImpl(compExeCtx);
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            this.componentExecutionInformations.put(compExeCtx.getExecutionIdentifier(), componentExecutionInformation);
        }
        return compExeCtx.getExecutionIdentifier();
    }

    private NetworkDestination determineNetworkDestinationForComponentController(EndpointDatumRecipient recipient, ResolvableNodeId workflowControllerNodeId) throws RemoteOperationException {
        LogicalNodeId networkDestination;
        LogicalNodeId destinationNodeId = recipient.getDestinationNodeId();
        if (this.platformService.matchesLocalInstance((ResolvableNodeId)destinationNodeId)) {
            networkDestination = destinationNodeId;
        } else if (this.isDestinationNodeReachable(destinationNodeId)) {
            networkDestination = this.communicationService.createReliableRPCStream((ResolvableNodeId)recipient.getDestinationNodeId());
        } else {
            this.log.debug((Object)("Cannot create a direct connection to component " + recipient.getInputsComponentExecutionIdentifier() + " on " + recipient.getInputsComponentInstanceName() + "; creating an indirect routing via the workflow controller"));
            networkDestination = this.communicationService.createReliableRPCStream(workflowControllerNodeId);
        }
        return networkDestination;
    }

    private boolean isDestinationNodeReachable(LogicalNodeId destinationNodeId) {
        return this.communicationService.getReachableLogicalNodes().contains(destinationNodeId.convertToDefaultLogicalNodeId());
    }

    private boolean checkComponentExecutionAuthorization(ExecutionContext executionContext, String authToken) {
        if (authToken == null) {
            this.log.error((Object)("Received a 'null' authorization token for component execution " + executionContext.getExecutionIdentifier()));
            return false;
        }
        return this.componentExecutionAuthorizationService.verifyAndUnregisterExecutionToken(authToken);
    }

    @Override
    @AllowRemoteAccess
    public void performPrepare(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).prepare();
    }

    @Override
    @AllowRemoteAccess
    public void performStart(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).start();
    }

    @Override
    @AllowRemoteAccess
    public void performCancel(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).cancel();
    }

    @Override
    @AllowRemoteAccess
    public void performPause(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).pause();
    }

    @Override
    @AllowRemoteAccess
    public void performResume(String executionId) throws ExecutionControllerException, RemoteOperationException {
        this.getExecutionController(executionId).resume();
    }

    @Override
    @AllowRemoteAccess
    public ComponentExecutionInformation getComponentExecutionInformation(String verificationToken) throws RemoteOperationException {
        for (Map.Entry<String, ComponentExecutionController> entry : this.listExecutionControllers().entrySet()) {
            if (entry.getValue().getVerificationToken() == null || !entry.getValue().getVerificationToken().equals(verificationToken)) continue;
            return this.componentExecutionInformations.get(entry.getKey());
        }
        return null;
    }

    @Override
    @AllowRemoteAccess
    public Boolean performVerifyResults(String executionId, String verificationToken, Boolean verified) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionController(executionId).verifyResults(verificationToken, verified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void performDispose(String executionId) throws ExecutionControllerException, RemoteOperationException {
        try {
            this.getExecutionController(executionId).dispose();
        }
        catch (ServiceException e) {
            this.log.warn((Object)("Ignored component disposal request as there is no component controller registered (anymore); most likely disposal was requested more than once: " + e.toString()));
        }
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            this.componentExecutionInformations.remove(executionId);
        }
        this.unregisterExecutionController(executionId);
    }

    @Override
    @AllowRemoteAccess
    public ComponentState getComponentState(String executionId) throws ExecutionControllerException, RemoteOperationException {
        return this.getExecutionController(executionId).getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComponentExecutionInformation> getComponentExecutionInformations() {
        Map<String, ComponentExecutionInformation> map = this.componentExecutionInformations;
        synchronized (map) {
            return new HashSet<ComponentExecutionInformation>(this.componentExecutionInformations.values());
        }
    }

    @Override
    public void onSendingEndointDatumFailed(String executionId, String serializedEndpointDatum, RemoteOperationException e) throws ExecutionControllerException {
        this.getExecutionController(executionId).onSendingEndointDatumFailed(this.endpointDatumSerializer.deserializeEndpointDatum(serializedEndpointDatum), e);
    }

    @Reference
    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    @Reference
    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    @Reference
    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeCtrlUtilsService = newService;
    }

    @Reference
    protected void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService componentKnowledgeService) {
        this.compKnowledgeService = componentKnowledgeService;
    }

    @Reference
    protected void bindEndpointDatumSerializer(EndpointDatumSerializer newService) {
        this.endpointDatumSerializer = newService;
    }

    @Reference
    protected void bindComponentExecutionAuthorizationService(ComponentExecutionAuthorizationService newService) {
        this.componentExecutionAuthorizationService = newService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExecutionController(ComponentExecutionController componentController, String executionId) {
        Hashtable<String, String> registerProperties = new Hashtable<String, String>();
        ((Dictionary)registerProperties).put("rce.component.execution.id", executionId);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(ComponentExecutionController.class.getName(), (Object)componentController, registerProperties);
        Map<String, ServiceRegistration<?>> map = this.componentServiceRegistrations;
        synchronized (map) {
            this.componentServiceRegistrations.put(executionId, serviceRegistration);
        }
    }

    private Map<String, ComponentExecutionController> listExecutionControllers() {
        return this.exeCtrlUtilsService.getExecutionControllers(ComponentExecutionController.class, this.bundleContext);
    }

    private ComponentExecutionController getExecutionController(String executionId) throws ExecutionControllerException {
        return this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterExecutionController(String executionId) {
        Map<String, ServiceRegistration<?>> map = this.componentServiceRegistrations;
        synchronized (map) {
            if (this.componentServiceRegistrations.containsKey(executionId)) {
                this.componentServiceRegistrations.get(executionId).unregister();
                this.componentServiceRegistrations.remove(executionId);
            }
        }
    }

    private void runGarbageCollection() {
        HashSet<String> compExeIds = new HashSet<String>(this.componentExecutionInformations.keySet());
        if (VERBOSE_LOGGING) {
            this.log.debug((Object)("Running garbage collection for component controllers: " + compExeIds));
        }
        for (String executionId : compExeIds) {
            ComponentExecutionController componentController = null;
            try {
                componentController = this.getExecutionController(executionId);
            }
            catch (ExecutionControllerException e) {
                this.log.debug((Object)StringUtils.format((String)"Component controller garbage collection: Skip component controller: %s; cause: %s", (Object[])new Object[]{executionId, e.getMessage()}));
                continue;
            }
            if (componentController.isWorkflowControllerReachable()) continue;
            this.log.debug((Object)("Found component controller with unreachable workflow controller: " + executionId));
            if (!ComponentConstants.FINAL_COMPONENT_STATES_WITH_DISPOSED.contains((Object)componentController.getState())) {
                try {
                    this.log.debug((Object)("Cancel component controller: " + executionId));
                    componentController.cancelSync(60000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("Cancelling component during garbage collecting failed: " + executionId), (Throwable)e);
                }
            }
            if (!ComponentConstants.FINAL_COMPONENT_STATES.contains((Object)componentController.getState())) continue;
            try {
                this.log.debug((Object)("Dispose component controller: " + executionId));
                this.performDispose(executionId);
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to dispose component during garbage collecting: %s; cause: %s", (Object[])new Object[]{executionId, e.toString()}));
            }
        }
    }
}

