/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.api;

import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.WorkflowGraphEdge;
import de.rcenvironment.core.component.execution.api.WorkflowGraphEdges;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.component.execution.api.WorkflowGraphNode;
import de.rcenvironment.core.component.execution.api.WorkflowGraphPath;
import de.rcenvironment.core.datamodel.api.EndpointCharacter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.GraphvizUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class WorkflowGraph
implements Serializable {
    private static final String DUMMY = "dummy";
    private static final long serialVersionUID = -2028814913500870207L;
    private final Map<ComponentExecutionIdentifier, WorkflowGraphNode> nodes;
    private final WorkflowGraphEdges edges;
    private final Map<ComponentExecutionIdentifier, Map<String, Set<WorkflowGraphPath>>> determinedHopsToDriverOnFailure = new HashMap<ComponentExecutionIdentifier, Map<String, Set<WorkflowGraphPath>>>();
    private final Map<ComponentExecutionIdentifier, WorkflowGraphNode> determinedDriverNodes = new HashMap<ComponentExecutionIdentifier, WorkflowGraphNode>();

    public WorkflowGraph(Map<ComponentExecutionIdentifier, WorkflowGraphNode> nodes, Set<WorkflowGraphEdge> edgeSet) {
        this.nodes = nodes;
        this.edges = WorkflowGraphEdges.create(edgeSet);
    }

    public synchronized Set<WorkflowGraphPath> getHopsToTraverseWhenResetting(ComponentExecutionIdentifier startNodeExecutionId) {
        HashSet<WorkflowGraphNode> alreadyVisitedNodes = new HashSet<WorkflowGraphNode>();
        ArrayList<List<WorkflowGraphEdge>> recursionResult = new ArrayList<List<WorkflowGraphEdge>>();
        this.recursion(alreadyVisitedNodes, this.nodes.get(startNodeExecutionId), EndpointCharacter.SAME_LOOP, new ArrayList<WorkflowGraphEdge>(), recursionResult);
        HashSet<WorkflowGraphPath> pathsSnapshot = new HashSet<WorkflowGraphPath>();
        for (List list : recursionResult) {
            ComponentExecutionIdentifier lastExeId;
            WorkflowGraphPath path = new WorkflowGraphPath();
            for (WorkflowGraphEdge edge : list) {
                WorkflowGraphNode currentNode = this.nodes.get(edge.getSourceExecutionIdentifier());
                WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
                WorkflowGraphHop nextHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), currentNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
                path.append(nextHop);
            }
            ComponentExecutionIdentifier firstExeId = ((WorkflowGraphEdge)list.get(0)).getSourceExecutionIdentifier();
            if (firstExeId.equals(lastExeId = ((WorkflowGraphEdge)list.get(list.size() - 1)).getTargetExecutionIdentifier())) {
                pathsSnapshot.add(path);
                continue;
            }
            String dummyHopOuputName = DUMMY + UUID.randomUUID().toString();
            ComponentExecutionIdentifier dummyTargetExecutionIdentifier = new ComponentExecutionIdentifier(DUMMY + UUID.randomUUID().toString());
            String dummyTargetInputName = DUMMY + UUID.randomUUID().toString();
            WorkflowGraphHop nextHop = new WorkflowGraphHop(lastExeId, dummyHopOuputName, dummyTargetExecutionIdentifier, dummyTargetInputName);
            path.append(nextHop);
            pathsSnapshot.add(path);
        }
        return pathsSnapshot;
    }

    private void recursion(Set<WorkflowGraphNode> alreadyVisitedNodes, WorkflowGraphNode node, EndpointCharacter startEndpointCharacter, List<WorkflowGraphEdge> currentChain, List<List<WorkflowGraphEdge>> completedChains) {
        List<WorkflowGraphEdge> nextEdgesToVisit = this.nextEdgesToVisit(alreadyVisitedNodes, node, startEndpointCharacter);
        if (nextEdgesToVisit.isEmpty()) {
            if (!currentChain.isEmpty()) {
                completedChains.add(currentChain);
            }
        } else {
            for (WorkflowGraphEdge nextEdge : nextEdgesToVisit) {
                WorkflowGraphNode nextNode = this.nodes.get(nextEdge.getTargetExecutionIdentifier());
                ArrayList<WorkflowGraphEdge> currentChainCopy = new ArrayList<WorkflowGraphEdge>(currentChain);
                currentChainCopy.add(nextEdge);
                this.recursion(alreadyVisitedNodes, nextNode, nextEdge.getInputCharacter(), currentChainCopy, completedChains);
            }
        }
    }

    private List<WorkflowGraphEdge> nextEdgesToVisit(Set<WorkflowGraphNode> alreadyVisitedNodes, WorkflowGraphNode startNode, EndpointCharacter startEndpointCharacter) {
        ArrayList<WorkflowGraphEdge> nextEdgesToVisit = new ArrayList<WorkflowGraphEdge>();
        for (String startNodeOutputId : startNode.getOutputIdentifiers()) {
            for (WorkflowGraphEdge edge : this.edges.getOutgoingEdges(startNode, startNodeOutputId)) {
                WorkflowGraphNode targetNode = this.nodes.get(edge.getTargetExecutionIdentifier());
                if (alreadyVisitedNodes.contains(targetNode)) continue;
                if (startNode.isDriver()) {
                    if (!startEndpointCharacter.equals((Object)edge.getOutputCharacter())) continue;
                    nextEdgesToVisit.add(edge);
                    alreadyVisitedNodes.add(targetNode);
                    continue;
                }
                nextEdgesToVisit.add(edge);
                alreadyVisitedNodes.add(targetNode);
            }
        }
        return nextEdgesToVisit;
    }

    public Map<String, Set<WorkflowGraphPath>> getHopsToTraverseOnFailure(ComponentExecutionIdentifier startNodeExecutionId) throws ComponentExecutionException {
        Map<String, Set<WorkflowGraphPath>> pathsPerOutput = this.nodes.get(startNodeExecutionId).isDriver() ? this.getHopsToTraverseToGetToLoopDriver(startNodeExecutionId, EndpointCharacter.OUTER_LOOP, this.determinedHopsToDriverOnFailure) : this.getHopsToTraverseToGetToLoopDriver(startNodeExecutionId, EndpointCharacter.SAME_LOOP, this.determinedHopsToDriverOnFailure);
        return pathsPerOutput;
    }

    private void sanitizePathsPerOutput(Map<String, Set<WorkflowGraphPath>> pathsPerOutput) {
        HashSet<String> visitedInputs = new HashSet<String>();
        Iterator<Map.Entry<String, Set<WorkflowGraphPath>>> pathsPerOutputIterator = pathsPerOutput.entrySet().iterator();
        while (pathsPerOutputIterator.hasNext()) {
            Map.Entry<String, Set<WorkflowGraphPath>> pathsForOutput = pathsPerOutputIterator.next();
            Iterator<WorkflowGraphPath> hopsForOutputIterator = pathsForOutput.getValue().iterator();
            while (hopsForOutputIterator.hasNext()) {
                WorkflowGraphPath hops = hopsForOutputIterator.next();
                String targetInputName = hops.getLast().getTargetInputName();
                if (visitedInputs.contains(targetInputName)) {
                    hopsForOutputIterator.remove();
                    continue;
                }
                visitedInputs.add(targetInputName);
            }
            if (!pathsForOutput.getValue().isEmpty()) continue;
            pathsPerOutputIterator.remove();
        }
    }

    public WorkflowGraphNode getLoopDriver(ComponentExecutionIdentifier executionIdentifier) throws ComponentExecutionException {
        if (!this.determinedDriverNodes.containsKey(executionIdentifier)) {
            this.getHopsToTraverseOnFailure(executionIdentifier);
        }
        return this.determinedDriverNodes.get(executionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<WorkflowGraphPath>> getHopsToTraverseToGetToLoopDriver(ComponentExecutionIdentifier startNodeExecutionId, EndpointCharacter startEndpointCharacter, Map<ComponentExecutionIdentifier, Map<String, Set<WorkflowGraphPath>>> alreadyDeterminedHops) throws ComponentExecutionException {
        Map<ComponentExecutionIdentifier, Map<String, Set<WorkflowGraphPath>>> map = alreadyDeterminedHops;
        synchronized (map) {
            if (!alreadyDeterminedHops.containsKey(startNodeExecutionId)) {
                HashMap pathsPerOutput = new HashMap();
                WorkflowGraphNode startNode = this.nodes.get(startNodeExecutionId);
                for (String startNodeOutputId : startNode.getOutputIdentifiers()) {
                    Set<Object> paths = new HashSet();
                    if (this.edges.containsOutgoingEdge(startNode, startNodeOutputId)) {
                        for (WorkflowGraphEdge startEdge : this.edges.getOutgoingEdges(startNode, startNodeOutputId)) {
                            if (startNode.isDriver()) {
                                if (!startEndpointCharacter.equals((Object)startEdge.getOutputCharacter())) continue;
                                paths = this.startNewHopsSearch(startNode, startEdge);
                                continue;
                            }
                            paths = this.startNewHopsSearch(startNode, startEdge);
                        }
                        pathsPerOutput.put(startNode.getEndpointName(startNodeOutputId), paths);
                        continue;
                    }
                    pathsPerOutput.put(startNode.getEndpointName(startNodeOutputId), paths);
                }
                alreadyDeterminedHops.put(startNodeExecutionId, pathsPerOutput);
            }
        }
        this.sanitizePathsPerOutput(alreadyDeterminedHops.get(startNodeExecutionId));
        return this.createSnapshotOfPaths(alreadyDeterminedHops.get(startNodeExecutionId));
    }

    private Map<String, Set<WorkflowGraphPath>> createSnapshotOfPaths(Map<String, Set<WorkflowGraphPath>> pathsMap) {
        HashMap<String, Set<WorkflowGraphPath>> pathsSnapshot = new HashMap<String, Set<WorkflowGraphPath>>();
        for (Map.Entry<String, Set<WorkflowGraphPath>> entry : pathsMap.entrySet()) {
            HashSet<WorkflowGraphPath> snapshotSet = new HashSet<WorkflowGraphPath>();
            for (WorkflowGraphPath path : entry.getValue()) {
                snapshotSet.add(WorkflowGraphPath.createCopy(path));
            }
            pathsSnapshot.put(entry.getKey(), snapshotSet);
        }
        return pathsSnapshot;
    }

    private Set<WorkflowGraphPath> startNewHopsSearch(WorkflowGraphNode startNode, WorkflowGraphEdge edge) throws ComponentExecutionException {
        HashSet<WorkflowGraphPath> paths = new HashSet<WorkflowGraphPath>();
        WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
        WorkflowGraphPath path = new WorkflowGraphPath();
        WorkflowGraphHop firstHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), startNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
        path.append(firstHop);
        this.determineHopsRecursively(startNode, edge, nextNode, path, paths);
        return paths;
    }

    private void determineHopsRecursively(WorkflowGraphNode startNode, WorkflowGraphEdge edge, WorkflowGraphNode targetNode, WorkflowGraphPath path, Set<WorkflowGraphPath> paths) throws ComponentExecutionException {
        if (targetNode.getExecutionIdentifier().equals(startNode.getExecutionIdentifier())) {
            return;
        }
        if (this.nodeAlreadyVisitedThatWay(path, targetNode, edge)) {
            return;
        }
        if (targetNode.isDriver()) {
            if (EndpointCharacter.OUTER_LOOP.equals((Object)edge.getInputCharacter())) {
                this.continueHopSearch(startNode, targetNode, path, paths, EndpointCharacter.OUTER_LOOP);
            } else {
                paths.add(path);
                this.addNodeToDeterminedDriverNodes(startNode, targetNode);
            }
        } else {
            EndpointCharacter outputCharacterToConsider = EndpointCharacter.SAME_LOOP;
            if (this.hasNodeOppositeOutputCharacters(targetNode)) {
                switch (edge.getInputCharacter()) {
                    case SAME_LOOP: {
                        outputCharacterToConsider = EndpointCharacter.OUTER_LOOP;
                        break;
                    }
                    case OUTER_LOOP: {
                        outputCharacterToConsider = EndpointCharacter.SAME_LOOP;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown endpoint character: " + edge.getInputCharacter());
                    }
                }
            }
            this.continueHopSearch(startNode, targetNode, path, paths, outputCharacterToConsider);
        }
    }

    private boolean nodeAlreadyVisitedThatWay(WorkflowGraphPath path, WorkflowGraphNode nodeToVisit, WorkflowGraphEdge usedEdge) {
        for (WorkflowGraphHop hop : path) {
            EndpointCharacter usedEdgesInputCharacter;
            if (!hop.getHopExecutionIdentifier().equals(nodeToVisit.getExecutionIdentifier())) continue;
            if (!this.hasNodeOppositeOutputCharacters(nodeToVisit)) {
                return true;
            }
            EndpointCharacter hopEdgesOutputCharacter = this.edges.getOutgoingEdges(this.nodes.get(hop.getHopExecutionIdentifier()), hop.getHopOutputIdentifier()).iterator().next().getOutputCharacter();
            if (hopEdgesOutputCharacter.equals((Object)(usedEdgesInputCharacter = usedEdge.getInputCharacter()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasNodeOppositeOutputCharacters(WorkflowGraphNode node) {
        boolean sameLoop = false;
        boolean outerLoop = false;
        for (String nodeOutputId : node.getOutputIdentifiers()) {
            for (WorkflowGraphEdge edge : this.edges.getOutgoingEdges(node, nodeOutputId)) {
                if (edge.getOutputCharacter().equals((Object)EndpointCharacter.SAME_LOOP)) {
                    sameLoop = true;
                    continue;
                }
                if (!edge.getOutputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) continue;
                outerLoop = true;
            }
        }
        return sameLoop && outerLoop;
    }

    private void continueHopSearch(WorkflowGraphNode startNode, WorkflowGraphNode targetNode, WorkflowGraphPath path, Set<WorkflowGraphPath> paths, EndpointCharacter outputCharacter) throws ComponentExecutionException {
        for (String targetNodeOutputId : targetNode.getOutputIdentifiers()) {
            for (WorkflowGraphEdge nextEdge : this.edges.getOutgoingEdges(targetNode, targetNodeOutputId)) {
                if (!outputCharacter.equals((Object)nextEdge.getOutputCharacter())) continue;
                this.continueHopsSearch(startNode, targetNode, nextEdge, path, paths);
            }
        }
    }

    private void continueHopsSearch(WorkflowGraphNode startNode, WorkflowGraphNode currentNode, WorkflowGraphEdge edge, WorkflowGraphPath path, Set<WorkflowGraphPath> paths) throws ComponentExecutionException {
        WorkflowGraphPath newPath = WorkflowGraphPath.createCopy(path);
        WorkflowGraphNode nextNode = this.nodes.get(edge.getTargetExecutionIdentifier());
        WorkflowGraphHop nextHop = new WorkflowGraphHop(edge.getSourceExecutionIdentifier(), currentNode.getEndpointName(edge.getOutputIdentifier()), edge.getTargetExecutionIdentifier(), nextNode.getEndpointName(edge.getInputIdentifier()), edge.getOutputIdentifier());
        newPath.append(nextHop);
        this.determineHopsRecursively(startNode, edge, nextNode, newPath, paths);
    }

    private void addNodeToDeterminedDriverNodes(WorkflowGraphNode startNode, WorkflowGraphNode driverNode) throws ComponentExecutionException {
        WorkflowGraphNode previousDriverNode = this.determinedDriverNodes.put(startNode.getExecutionIdentifier(), driverNode);
        if (previousDriverNode != null && !previousDriverNode.getExecutionIdentifier().equals(driverNode.getExecutionIdentifier())) {
            throw new ComponentExecutionException("Error in workflow graph search: newly determined driver node differs from driver node determined earlier");
        }
    }

    public String toDotScript() {
        GraphvizUtils.DotFileBuilder builder = GraphvizUtils.createDotFileBuilder((String)"wf_graph");
        for (WorkflowGraphNode workflowGraphNode : this.nodes.values()) {
            builder.addVertex(workflowGraphNode.getExecutionIdentifier().toString(), workflowGraphNode.getName());
            if (workflowGraphNode.isDriver()) {
                builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "color", "#AA3939");
            } else if (this.hasNodeOppositeOutputCharacters(workflowGraphNode)) {
                builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "color", "#D4AA6A");
            }
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "shape", "rectangle");
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "fontsize", "10");
            builder.addVertexProperty(workflowGraphNode.getExecutionIdentifier().toString(), "fontname", "Consolas");
        }
        for (Set set : this.edges.getAllEdges()) {
            for (WorkflowGraphEdge edge : set) {
                HashMap<String, String> edgeProps = new HashMap<String, String>();
                edgeProps.put("fontsize", "10");
                edgeProps.put("fontname", "Consolas");
                if (edge.getInputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) {
                    edgeProps.put("color", "#55AA55");
                } else if (edge.getOutputCharacter().equals((Object)EndpointCharacter.OUTER_LOOP)) {
                    edgeProps.put("color", "#4B698B");
                }
                String label = StringUtils.format((String)"%s > %s", (Object[])new Object[]{this.nodes.get(edge.getSourceExecutionIdentifier()).getEndpointName(edge.getOutputIdentifier()), this.nodes.get(edge.getTargetExecutionIdentifier()).getEndpointName(edge.getInputIdentifier())});
                builder.addEdge(edge.getSourceExecutionIdentifier().toString(), edge.getTargetExecutionIdentifier().toString(), label, edgeProps);
            }
        }
        return builder.getScriptContent();
    }
}

