/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.optimizer.execution;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.optimizer.common.MethodDescription;
import de.rcenvironment.components.optimizer.common.OptimizerComponentConstants;
import de.rcenvironment.components.optimizer.common.OptimizerFileLoader;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptimizerPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String REQUIRED = "Required";
    private static final String INPUT_EXECUTION_CONSTRAINT = "inputExecutionConstraint_4aae3eea";
    private static final String PRE_CALC_FILE_PATH = "preCalcFilePath";
    private static final String SELF_LOOP_ENDPOINT = "SelfLoopEndpoint";
    private static final String OUTER_LOOP_ENDPOINT = "OuterLoopEndpoint";
    private static final String DYNAMIC_OUTPUTS = "dynamicOutputs";
    private static final String GOAL = "goal";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String SPECIFIC_SETTINGS = "specificSettings";
    private static final String DAKOTA_COLINY_EVOLUTIONARY_ALGORITHM = "Dakota Coliny Evolutionary Algorithm";
    private static final String DAKOTA_COLINY_COBYLA_CONSTRAINT_OPTIMIZATION_BY_LINEAR_APPROXIMATIONS = "Dakota Coliny COBYLA (Constraint Optimization By Linear Approximations)";
    private static final String DAKOTA_QUASI_NEWTON_METHOD = "Dakota Quasi-Newton method";
    private static final String EP_IDENTIFIER = "epIdentifier";
    private static final String CONSTRAINT = "Constraint";
    private static final String OBJECTIVE = "Objective";
    private static final String NAME = "name";
    private static final String STATIC_OUTPUTS = "staticOutputs";
    private static final String NAN = "NaN";
    private static final String WEIGHT = "weight";
    private static final String METADATA = "metadata";
    private static final String METHOD_CONFIGURATIONS = "methodConfigurations";
    private static final String ALGORITHM = "algorithm";
    private static final String CONFIGURATION = "configuration";
    private static final String LOOP_ENDPOINT_TYPE = "loopEndpointType_5e0ed1cd";
    private static final Log LOGGER = LogFactory.getLog(OptimizerPersistentComponentDescriptionUpdater.class);
    private static final String COLON = ":";
    private static final String V1_0 = "1.0";
    private static final String V3_0 = "3.0";
    private static final String V5_0 = "5.0";
    private static final String V5_1 = "5.1";
    private static final String V6_0 = "6.0";
    private static final String V6_1 = "6.1";
    private static final String V6_2 = "6.2";
    private static final String V7_0 = "7.0";
    private static final String V7_1 = "7.1";
    private static final String V8 = "8";
    private static final String V8_1 = "8.1";
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return OptimizerComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!(silent || persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V1_0) >= 0)) {
            versionsToUpdate |= 1;
        }
        if (!silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
            versionsToUpdate |= 2;
        }
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V8_1) < 0) {
            versionsToUpdate |= 4;
        }
        if (silent && persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V7_1) < 0) {
            versionsToUpdate |= 4;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block43: {
            block41: {
                block44: {
                    block42: {
                        if (silent) break block41;
                        if (formatVersion != 1) break block42;
                        description = this.updateBeforeVersion3(description);
                        break block43;
                    }
                    if (formatVersion != 2) break block44;
                    description = this.updateToVersion3(description);
                    break block43;
                }
                if (formatVersion != 4) break block43;
                switch (description.getComponentVersion()) {
                    case "3.0": {
                        description = this.updateToVersion50(description);
                    }
                    case "5.0": {
                        description = this.updateToVersion51(description);
                    }
                    case "5.1": {
                        description = this.updateToVersion60(description);
                    }
                    case "6.0": {
                        description = this.updateToVersion61(description);
                    }
                    case "6.1": {
                        description = this.updateFrom61To62(description);
                    }
                    case "6.2": {
                        description = this.updateToVersion70(description);
                    }
                    case "7.0": {
                        description = this.updateFrom70To71(description);
                    }
                    case "7.1": {
                        description = this.updateFrom71To8(description);
                    }
                    case "8": {
                        description = this.updateFrom8To81(description);
                    }
                }
                break block43;
            }
            if (formatVersion != 4) break block43;
            switch (description.getComponentVersion()) {
                case "7.0": {
                    description = this.updateFrom70To71(description);
                }
                case "8": {
                    description = this.updateFrom8To81(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFrom8To81(PersistentComponentDescription description) throws IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode dynamicOutputs = node.get(DYNAMIC_OUTPUTS);
        boolean isDiscrete = true;
        for (JsonNode output : dynamicOutputs) {
            if (!output.get(EP_IDENTIFIER).asText().equals("Design")) continue;
            isDiscrete = output.get(METADATA).get("isDiscrete").asBoolean();
        }
        if (isDiscrete) {
            ((ObjectNode)node.get(CONFIGURATION)).remove(ALGORITHM);
            ((ObjectNode)node.get(CONFIGURATION)).put(ALGORITHM, "");
            LOGGER.info((Object)"The optimizer configuration was incorrect. The selected algorithm does not support discrete optimization and has therefore been removed. Please select a valid algorithm from the drop-down menu.");
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V8_1);
        return newdesc;
    }

    private PersistentComponentDescription updateFrom71To8(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoints((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData((PersistentComponentDescription)description);
        description.setComponentVersion(V8);
        return description;
    }

    private PersistentComponentDescription updateFrom70To71(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        PersistentComponentDescription updatedDesc = PersistentComponentDescriptionUpdaterUtils.updateFaultToleranceOfLoopDriver((PersistentComponentDescription)description);
        JsonNode node = mapper.readTree(updatedDesc.getComponentDescriptionAsString());
        JsonNode configuration = node.get(CONFIGURATION);
        if (configuration != null) {
            ObjectNode configNode = (ObjectNode)configuration;
            configNode.put("usePrecalculation", "false");
            configNode.put(PRE_CALC_FILE_PATH, "");
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V7_1);
        return newdesc;
    }

    private PersistentComponentDescription updateToVersion70(PersistentComponentDescription description) throws JsonParseException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode dynamicInputs;
        JsonNode dynamicOutputs;
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                Iterator metaData = (ObjectNode)outputEndpoint.get(METADATA);
                if (metaData == null) {
                    metaData = JsonNodeFactory.instance.objectNode();
                    ((ObjectNode)outputEndpoint).put(METADATA, (JsonNode)metaData);
                }
                if (outputEndpoint.get(NAME).textValue().equals("Outer loop done")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, "InnerLoopEndpoint");
                }
                if (outputEndpoint.get(NAME).textValue().equals("Iteration")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                }
                if (outputEndpoint.get(NAME).textValue().equals("Gradient request")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                }
                if (!outputEndpoint.get(NAME).textValue().equals("Done")) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
            }
        }
        if ((dynamicOutputs = node.get(DYNAMIC_OUTPUTS)) != null) {
            for (JsonNode outputEndpoint : dynamicOutputs) {
                Iterator metaData = (ObjectNode)outputEndpoint.get(METADATA);
                if (outputEndpoint.get(EP_IDENTIFIER).textValue().equals("Design")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                }
                if (!outputEndpoint.get(EP_IDENTIFIER).textValue().equals("optima")) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
            }
        }
        if ((dynamicInputs = node.get(DYNAMIC_INPUTS)) != null) {
            for (JsonNode inputEndpoint : dynamicInputs) {
                ObjectNode metaData = (ObjectNode)inputEndpoint.get(METADATA);
                if (inputEndpoint.get(EP_IDENTIFIER).textValue().equals(OBJECTIVE) || inputEndpoint.get(EP_IDENTIFIER).textValue().equals(CONSTRAINT) || inputEndpoint.get(EP_IDENTIFIER).textValue().equals("gradients")) {
                    metaData.put(LOOP_ENDPOINT_TYPE, SELF_LOOP_ENDPOINT);
                }
                if (!inputEndpoint.get(EP_IDENTIFIER).textValue().equals("startvalues") && !inputEndpoint.get(EP_IDENTIFIER).textValue().equals("outerLoopDone")) continue;
                metaData.put(LOOP_ENDPOINT_TYPE, OUTER_LOOP_ENDPOINT);
                metaData.put(INPUT_EXECUTION_CONSTRAINT, REQUIRED);
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V7_0);
        return newdesc;
    }

    private PersistentComponentDescription updateFrom61To62(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                ((ObjectNode)outputEndpoint).remove(EP_IDENTIFIER);
                if (!outputEndpoint.get(NAME).textValue().equals("Optimizer is finished")) continue;
                ((ObjectNode)outputEndpoint).put(NAME, "Done");
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V6_2);
        return newdesc;
    }

    private PersistentComponentDescription updateToVersion61(PersistentComponentDescription description) throws JsonParseException, IOException {
        Map specifics;
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        ((ObjectNode)node.get(CONFIGURATION)).put(PRE_CALC_FILE_PATH, "${preCalcFilePath}");
        TextNode methodConfigurations = (TextNode)node.get(CONFIGURATION).get(METHOD_CONFIGURATIONS);
        Map configs = (Map)mapper.readValue(methodConfigurations.textValue(), new HashMap().getClass());
        ObjectNode accuracyNode = mapper.createObjectNode();
        accuracyNode.put("GuiName", "Solution accuracy");
        accuracyNode.put("dataType", "Real");
        accuracyNode.put("SWTWidget", "Text");
        accuracyNode.put("DefaultValue", "1.E-4");
        accuracyNode.put("Value", "");
        accuracyNode.put("Validation", "required");
        if (configs != null && configs.get(DAKOTA_COLINY_COBYLA_CONSTRAINT_OPTIMIZATION_BY_LINEAR_APPROXIMATIONS) != null) {
            specifics = (Map)((HashMap)configs.get(DAKOTA_COLINY_COBYLA_CONSTRAINT_OPTIMIZATION_BY_LINEAR_APPROXIMATIONS)).get(SPECIFIC_SETTINGS);
            specifics.put("solution_accuracy", accuracyNode);
        }
        if (configs != null && configs.get(DAKOTA_COLINY_EVOLUTIONARY_ALGORITHM) != null) {
            specifics = (Map)((HashMap)configs.get(DAKOTA_COLINY_EVOLUTIONARY_ALGORITHM)).get(SPECIFIC_SETTINGS);
            specifics.put("solution_accuracy", accuracyNode);
        }
        ((ObjectNode)node.get(CONFIGURATION)).remove(METHOD_CONFIGURATIONS);
        ((ObjectNode)node.get(CONFIGURATION)).put(METHOD_CONFIGURATIONS, mapper.writeValueAsString((Object)configs));
        ArrayNode inputs = (ArrayNode)node.get(DYNAMIC_INPUTS);
        if (inputs != null) {
            for (ObjectNode input : inputs) {
                if (((ObjectNode)input.get(METADATA)).get(GOAL) == null || !((ObjectNode)input.get(METADATA)).get(GOAL).textValue().equals("Solve for")) continue;
                ((ObjectNode)input.get(METADATA)).put(GOAL, "Minimize");
                ((ObjectNode)input.get(METADATA)).remove("solve");
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V6_1);
        return description;
    }

    private PersistentComponentDescription updateToVersion60(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateSchedulingInformation((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.updateIsNestedLoop((PersistentComponentDescription)description);
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        ArrayNode statEndpoints = (ArrayNode)node.get(STATIC_OUTPUTS);
        if (statEndpoints != null) {
            ObjectNode gradientRequest = mapper.createObjectNode();
            gradientRequest.put("identifier", UUID.randomUUID().toString());
            gradientRequest.put(NAME, "Gradient request");
            gradientRequest.put(EP_IDENTIFIER, (JsonNode)NullNode.instance);
            gradientRequest.put("datatype", "Boolean");
            statEndpoints.add((JsonNode)gradientRequest);
            for (JsonNode o : statEndpoints) {
                ObjectNode outNode = (ObjectNode)o;
                if (!outNode.get(NAME).textValue().equals("Iteration count")) continue;
                outNode.remove(NAME);
                outNode.put(NAME, "Iteration");
            }
        }
        ((ObjectNode)node.get(CONFIGURATION)).put(PRE_CALC_FILE_PATH, "${preCalcFilePath}");
        TextNode methodConfigurations = (TextNode)node.get(CONFIGURATION).get(METHOD_CONFIGURATIONS);
        Map configs = (Map)mapper.readValue(methodConfigurations.textValue(), new HashMap().getClass());
        if (configs != null && configs.get("Dakota Surrogate-Based Local") != null) {
            ((HashMap)configs.get("Dakota Surrogate-Based Local")).put("methodCode", "surrogate_based_local");
        }
        if (configs != null && configs.get(DAKOTA_QUASI_NEWTON_METHOD) != null) {
            Map specifics = (Map)((HashMap)configs.get(DAKOTA_QUASI_NEWTON_METHOD)).get(SPECIFIC_SETTINGS);
            specifics.remove("central_path");
            ((Map)specifics.get("merit_function")).put("dataType", "None");
            ((Map)specifics.get("merit_function")).put("defaultValue", "argaez_tapia");
        }
        Map moga = (Map)mapper.readValue(OptimizerFileLoader.class.getResourceAsStream("/resources/optimizer/dakota/dakotaMOGA.json"), new HashMap().getClass());
        Map soga = (Map)mapper.readValue(OptimizerFileLoader.class.getResourceAsStream("/resources/optimizer/dakota/dakotaSOGA.json"), new HashMap().getClass());
        Map defaults = (Map)mapper.readValue(OptimizerFileLoader.class.getResourceAsStream("/resources/optimizer/dakota/defaults.json"), new HashMap().getClass());
        moga.put("commonSettings", defaults);
        soga.put("commonSettings", defaults);
        if (configs != null) {
            configs.put("Dakota Multi Objective Genetic Algorithm", moga);
            configs.put("Dakota Single Objective Genetic Algorithm", soga);
        }
        ((ObjectNode)node.get(CONFIGURATION)).remove(METHOD_CONFIGURATIONS);
        ((ObjectNode)node.get(CONFIGURATION)).put(METHOD_CONFIGURATIONS, mapper.writeValueAsString((Object)configs));
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V6_0);
        return description;
    }

    private PersistentComponentDescription updateToVersion51(PersistentComponentDescription description) throws JsonParseException, IOException {
        if (!description.getComponentVersion().equals(V5_0)) {
            description = this.updateToVersion50(description);
        }
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        ArrayNode dynEndpoints = (ArrayNode)node.get(DYNAMIC_INPUTS);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (endpoint.get(NAME) == null || !endpoint.get(NAME).textValue().contains("\u2202")) continue;
                ((ObjectNode)endpoint).put(EP_IDENTIFIER, "gradients");
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V5_1);
        return description;
    }

    private PersistentComponentDescription updateToVersion50(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        ArrayNode dynEndpoints = (ArrayNode)node.get(DYNAMIC_OUTPUTS);
        if (dynEndpoints != null) {
            LinkedList<ObjectNode> newNodes = new LinkedList<ObjectNode>();
            for (JsonNode jsonNode : dynEndpoints) {
                if (jsonNode.get(NAME) != null && dynEndpoints.get(String.valueOf(jsonNode.get(NAME).textValue()) + "_optimal") == null) {
                    ObjectNode optimalNode = (ObjectNode)this.copy(jsonNode);
                    optimalNode.put("identifier", UUID.randomUUID().toString());
                    optimalNode.put(NAME, String.valueOf(optimalNode.get(NAME).textValue()) + "_optimal");
                    optimalNode.put(EP_IDENTIFIER, "optima");
                    newNodes.add(optimalNode);
                }
                if (jsonNode.get(METADATA) == null) continue;
                ((ObjectNode)jsonNode.get(METADATA)).put("hasStartValue", true);
            }
            for (JsonNode jsonNode : newNodes) {
                dynEndpoints.add(jsonNode);
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V5_0);
        return description;
    }

    private <T extends JsonNode> T copy(T node) {
        try {
            return (T)((JsonNode)JsonUtils.getDefaultObjectMapper().readTree(node.traverse()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private PersistentComponentDescription updateToVersion3(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)DYNAMIC_OUTPUTS, (String)"Design", (PersistentComponentDescription)description);
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        JsonNode dynEndpoints = node.get(DYNAMIC_INPUTS);
        if (dynEndpoints != null) {
            for (JsonNode endpoint : dynEndpoints) {
                if (endpoint.get(EP_IDENTIFIER) != null && !endpoint.get(EP_IDENTIFIER).isNull() && !endpoint.get(EP_IDENTIFIER).textValue().equals("null")) continue;
                ObjectNode objectEndpoint = (ObjectNode)endpoint;
                objectEndpoint.remove(EP_IDENTIFIER);
                String identifier = "";
                if (objectEndpoint.get(METADATA) != null && !((ObjectNode)objectEndpoint.get(METADATA)).get(WEIGHT).textValue().equals(NAN)) {
                    identifier = OBJECTIVE;
                    this.updateMetaData(objectEndpoint, dynEndpoints);
                } else if ((ObjectNode)objectEndpoint.get(METADATA) != null) {
                    identifier = CONSTRAINT;
                    this.updateMetaData(objectEndpoint, dynEndpoints);
                } else if (objectEndpoint.get(NAME).textValue().contains("\u2202")) {
                    ObjectNode newMetadataObjectNode = JsonNodeFactory.instance.objectNode();
                    objectEndpoint.put(METADATA, (JsonNode)newMetadataObjectNode);
                    String functionName = objectEndpoint.get(NAME).textValue().substring(1, objectEndpoint.get(NAME).textValue().indexOf(46));
                    for (JsonNode otherEndpoint : dynEndpoints) {
                        if (otherEndpoint.get(NAME).textValue().equals(functionName) && otherEndpoint.get(METADATA) != null && !((ObjectNode)otherEndpoint.get(METADATA)).get(WEIGHT).textValue().equals(NAN)) {
                            identifier = OBJECTIVE;
                            break;
                        }
                        identifier = CONSTRAINT;
                    }
                }
                objectEndpoint.put(EP_IDENTIFIER, (JsonNode)TextNode.valueOf((String)identifier));
            }
        }
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V3_0);
        return description;
    }

    private void updateMetaData(ObjectNode objectEndpoint, JsonNode dynEndpoints) {
        ObjectNode metadata = (ObjectNode)objectEndpoint.get(METADATA);
        if (metadata.get(GOAL).textValue().equals("0")) {
            metadata.put(GOAL, (JsonNode)TextNode.valueOf((String)"Minimize"));
        } else if (metadata.get(GOAL).textValue().equals("1")) {
            metadata.put(GOAL, (JsonNode)TextNode.valueOf((String)"Maximize"));
        } else {
            metadata.put(GOAL, (JsonNode)TextNode.valueOf((String)"Solve for"));
        }
        boolean hasMetaData = false;
        for (JsonNode otherEndpoint : dynEndpoints) {
            if (!otherEndpoint.get(NAME).textValue().contains("\u2202") || !otherEndpoint.get(NAME).textValue().contains("\u2202" + objectEndpoint.get(NAME).textValue() + ".")) continue;
            hasMetaData = true;
        }
        metadata.put("hasGradient", (JsonNode)JsonNodeFactory.instance.booleanNode(hasMetaData));
        objectEndpoint.remove(METADATA);
        objectEndpoint.put(METADATA, (JsonNode)metadata);
    }

    private PersistentComponentDescription updateBeforeVersion3(PersistentComponentDescription description) throws IOException, JsonParseException, JsonProcessingException, JsonGenerationException, JsonMappingException {
        JsonNode completeComponent;
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var5_5 = null;
        try (JsonParser jsonParser = jsonFactory.createJsonParser(description.getComponentDescriptionAsString());){
            completeComponent = (JsonNode)mapper.readTree(jsonParser);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonNode completeConfiguration = completeComponent.get(CONFIGURATION);
        JsonNode algorithmNode = null;
        JsonNode methodsConfigurationNode = null;
        TextNode optimizerPackageNode = null;
        boolean foundMethodConfigurations = false;
        boolean foundPackageDeclaration = false;
        int i = 0;
        while (i < completeConfiguration.size()) {
            if (completeConfiguration.get(i).textValue() != null) {
                String[] configItem = completeConfiguration.get(i).textValue().split(COLON);
                if (configItem[0].equals(ALGORITHM)) {
                    algorithmNode = OptimizerPersistentComponentDescriptionUpdater.updateAlgorithm(completeConfiguration.get(i));
                }
                if (configItem[0].contains(METHOD_CONFIGURATIONS) && configItem.length > 2 && configItem[2] != null) {
                    String configs = completeConfiguration.get(i).textValue();
                    configs = configs.substring(configs.indexOf("{"));
                    methodsConfigurationNode = this.updateMethods(configs);
                    foundMethodConfigurations = true;
                }
                if (configItem[0].equals("optimizerPackageCode")) {
                    foundPackageDeclaration = true;
                    optimizerPackageNode = configItem.length > 2 && configItem[2] != null && !configItem[2].isEmpty() && algorithmNode != null && algorithmNode.textValue().contains("Pyranha") ? TextNode.valueOf((String)"optimizerPackageCode:java.lang.String:pyranha") : (configItem.length > 2 && configItem[2] != null && !configItem[2].isEmpty() && algorithmNode != null && algorithmNode.textValue().contains("Dakota") ? TextNode.valueOf((String)"optimizerPackageCode:java.lang.String:dakota") : TextNode.valueOf((String)"optimizerPackageCode:java.lang.String:generic"));
                }
            }
            ++i;
        }
        if (!foundMethodConfigurations) {
            methodsConfigurationNode = OptimizerPersistentComponentDescriptionUpdater.writeNewMethodConfigurationsNode();
        }
        if (!foundPackageDeclaration) {
            optimizerPackageNode = TextNode.valueOf((String)"optimizerPackageCode:java.lang.String:dakota");
        }
        if (completeConfiguration.get("genericPythonPath") != null) {
            ((ObjectNode)completeConfiguration).put("genericPythonPath", (JsonNode)TextNode.valueOf((String)"${genericPythonPath}"));
        }
        if (completeConfiguration.get("pyranhaPythonPath") != null) {
            ((ObjectNode)completeConfiguration).put("pyranhaPythonPath", (JsonNode)TextNode.valueOf((String)"${pyranhaPythonPath}"));
        }
        ArrayNode newConfig = mapper.createArrayNode();
        newConfig.add(algorithmNode);
        if (methodsConfigurationNode != null) {
            newConfig.add(methodsConfigurationNode);
        }
        newConfig.add((JsonNode)optimizerPackageNode);
        ((ObjectNode)completeComponent).remove(CONFIGURATION);
        ((ObjectNode)completeComponent).put(CONFIGURATION, (JsonNode)newConfig);
        PersistentComponentDescription newDesc = new PersistentComponentDescription(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)completeComponent));
        newDesc.setComponentVersion(V1_0);
        return newDesc;
    }

    private JsonNode updateMethods(String methodConfigs) {
        TextNode returnNode = null;
        try {
            Map methodConfigurations;
            String newMethodConfiguations = "methodConfigurations:java.lang.String:";
            Map defaultMethodConfigurations = OptimizerFileLoader.getAllMethodDescriptions((String)"/optimizer");
            for (String key : defaultMethodConfigurations.keySet()) {
                defaultMethodConfigurations.put(key, (MethodDescription)mapper.convertValue(defaultMethodConfigurations.get(key), MethodDescription.class));
            }
            if (!methodConfigs.equals("")) {
                methodConfigs = StringUtils.unescapeSeparator((String)methodConfigs);
                methodConfigurations = (Map)mapper.readValue(methodConfigs, new HashMap().getClass());
                for (String key : methodConfigurations.keySet()) {
                    methodConfigurations.put(key, (MethodDescription)mapper.convertValue(methodConfigurations.get(key), MethodDescription.class));
                }
            } else {
                return OptimizerPersistentComponentDescriptionUpdater.writeNewMethodConfigurationsNode();
            }
            this.replaceConfigurations(methodConfigurations, defaultMethodConfigurations);
            returnNode = TextNode.valueOf((String)(String.valueOf(newMethodConfiguations) + StringUtils.escapeSeparator((String)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)methodConfigurations))));
        }
        catch (JsonParseException e) {
            LOGGER.error((Object)"Could not parse method file ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOGGER.error((Object)"Could not map method file ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Could not load method file ", (Throwable)e);
        }
        return returnNode;
    }

    private static JsonNode writeNewMethodConfigurationsNode() {
        JsonNode returnNode = null;
        String newMethodConfiguations = "methodConfigurations:java.lang.String:";
        try {
            Map defaultMethodConfigurations = OptimizerFileLoader.getAllMethodDescriptions((String)"/optimizer");
            for (String key : defaultMethodConfigurations.keySet()) {
                defaultMethodConfigurations.put(key, (MethodDescription)mapper.convertValue(defaultMethodConfigurations.get(key), MethodDescription.class));
            }
            String configs = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)defaultMethodConfigurations);
            configs = StringUtils.escapeSeparator((String)configs);
            returnNode = mapper.valueToTree((Object)(String.valueOf(newMethodConfiguations) + configs));
            return returnNode;
        }
        catch (JsonParseException e) {
            LOGGER.warn((Object)"", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOGGER.warn((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"", (Throwable)e);
        }
        return null;
    }

    private static JsonNode updateAlgorithm(JsonNode algorithm) {
        TextNode returnNode = null;
        String prefix = "algorithm:java.lang.String:";
        String[] algorithmItem = algorithm.textValue().split(COLON);
        if (algorithmItem.length > 2) {
            if (algorithmItem[2] != null && algorithmItem[2].equals("HOPSPACK Asynch Pattern Search")) {
                returnNode = TextNode.valueOf((String)(String.valueOf(prefix) + "Dakota HOPSPACK Asynch Pattern Search"));
            }
            if (algorithmItem[2] != null && !algorithmItem[2].contains("Dakota")) {
                if (algorithmItem[2].contains("COBYLA")) {
                    returnNode = TextNode.valueOf((String)(String.valueOf(prefix) + DAKOTA_COLINY_COBYLA_CONSTRAINT_OPTIMIZATION_BY_LINEAR_APPROXIMATIONS));
                }
                if (algorithmItem[2].contains("Newton")) {
                    returnNode = TextNode.valueOf((String)(String.valueOf(prefix) + DAKOTA_QUASI_NEWTON_METHOD));
                }
                if (algorithmItem[2].contains("Evolutionary")) {
                    returnNode = TextNode.valueOf((String)(String.valueOf(prefix) + DAKOTA_COLINY_EVOLUTIONARY_ALGORITHM));
                }
            }
        }
        if (returnNode != null) {
            return returnNode;
        }
        return algorithm;
    }

    private void replaceConfigurations(Map<String, MethodDescription> methodConfigurations, Map<String, MethodDescription> defaultMethodConfigurations) {
        LinkedList<String> keysToDelete = new LinkedList<String>();
        for (String key : methodConfigurations.keySet()) {
            if (defaultMethodConfigurations.containsKey(key)) continue;
            keysToDelete.add(key);
        }
        for (String key : keysToDelete) {
            methodConfigurations.remove(key);
        }
        for (String key : methodConfigurations.keySet()) {
            MethodDescription oldDescription = methodConfigurations.get(key);
            MethodDescription defaultdescription = defaultMethodConfigurations.get(key);
            oldDescription.setFollowingMethods(defaultdescription.getFollowingMethods());
            oldDescription.setMethodCode(defaultdescription.getMethodCode());
            oldDescription.setMethodName(defaultdescription.getMethodName());
            oldDescription.setOptimizerPackage(defaultdescription.getOptimizerPackage());
            this.replaceKeyValueMaps(oldDescription.getSpecificSettings(), defaultdescription.getSpecificSettings());
            this.replaceKeyValueMaps(oldDescription.getResponsesSettings(), defaultdescription.getResponsesSettings());
        }
        for (String key : defaultMethodConfigurations.keySet()) {
            if (methodConfigurations.containsKey(key)) continue;
            methodConfigurations.put(key, defaultMethodConfigurations.get(key));
        }
    }

    private void replaceKeyValueMaps(Map<String, Map<String, String>> currentSettings, Map<String, Map<String, String>> defaultSettings) {
        if (currentSettings != null) {
            LinkedList<String> keysToDelete = new LinkedList<String>();
            for (String key : currentSettings.keySet()) {
                if (defaultSettings.containsKey(key)) continue;
                keysToDelete.add(key);
            }
            for (String key : keysToDelete) {
                currentSettings.remove(key);
            }
        }
        if (currentSettings != null) {
            for (String controlKey : currentSettings.keySet()) {
                Map<String, String> currentProperties = currentSettings.get(controlKey);
                Map<String, String> defaultProperties = defaultSettings.get(controlKey);
                for (String propertyKey : currentProperties.keySet()) {
                    if (defaultProperties.containsKey(propertyKey)) continue;
                    currentProperties.remove(propertyKey);
                }
                for (String propertyKey : currentProperties.keySet()) {
                    if (!propertyKey.equalsIgnoreCase("Value")) {
                        currentProperties.put(propertyKey, defaultProperties.get(propertyKey));
                        continue;
                    }
                    if (!currentProperties.get(propertyKey).equals(defaultProperties.get("DefaultValue"))) continue;
                    currentProperties.put(propertyKey, defaultProperties.get(propertyKey));
                }
                for (String propertyKey : defaultProperties.keySet()) {
                    if (currentProperties.containsKey(propertyKey)) continue;
                    currentProperties.put(propertyKey, defaultProperties.get(propertyKey));
                }
            }
        }
        if (defaultSettings != null && currentSettings != null) {
            for (String controlKey : defaultSettings.keySet()) {
                if (currentSettings.containsKey(controlKey)) continue;
                currentSettings.put(controlKey, defaultSettings.get(controlKey));
            }
        }
    }
}

