/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.components.database.common.DatabaseStatementHistoryData;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DatabaseComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    private static final long serialVersionUID = -8675762321318573550L;
    private static final String STATEMENT_PATTERN = "statementPattern";
    private static final String STATEMENT_EFFECTIVE = "statementEffective";
    private static final String STATEMENT_NAME = "statementName";
    private static final String STATEMENT_ID = "statementId";
    private static final String STATEMENT_ROOT = "statementRoot";
    private List<DatabaseStatementHistoryData> databaseStatementHistoryDataList = new ArrayList<DatabaseStatementHistoryData>();
    private String identifier;

    public DatabaseComponentHistoryDataItem(String identifier) {
        this.identifier = identifier;
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String data = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(data);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        ArrayNode statementsArrayNode = ((ObjectNode)rootNode).putArray(STATEMENT_ROOT);
        for (DatabaseStatementHistoryData historyDatum : this.databaseStatementHistoryDataList) {
            ObjectNode statementObjectNode = statementsArrayNode.addObject();
            statementObjectNode.put(STATEMENT_ID, historyDatum.getStatementIndex());
            statementObjectNode.put(STATEMENT_NAME, historyDatum.getStatementName());
            statementObjectNode.put(STATEMENT_PATTERN, historyDatum.getStatementPattern());
            statementObjectNode.put(STATEMENT_EFFECTIVE, historyDatum.getStatementEffective());
        }
        return rootNode.toString();
    }

    private static void readReferenceFromString(String historyData, DatabaseComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        JsonNode statementsNode = ((ObjectNode)rootNode).get(STATEMENT_ROOT);
        Iterator statementNodeElements = statementsNode.elements();
        while (statementNodeElements.hasNext()) {
            JsonNode node = (JsonNode)statementNodeElements.next();
            int index = node.get(STATEMENT_ID).asInt();
            String statementName = node.get(STATEMENT_NAME).asText();
            String statementPattern = node.get(STATEMENT_PATTERN).asText();
            String statementEffective = node.get(STATEMENT_EFFECTIVE).asText();
            historyDataItem.addDatabaseStatementHistoryData(index, statementName, statementPattern, statementEffective);
        }
    }

    public static DatabaseComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        DatabaseComponentHistoryDataItem historyDataItem = new DatabaseComponentHistoryDataItem(identifier);
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        DatabaseComponentHistoryDataItem.readReferenceFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    public void addDatabaseStatementHistoryData(int index, String statementName, String statementPattern, String effectiveStatement) {
        this.databaseStatementHistoryDataList.add(new DatabaseStatementHistoryData(index, statementName, statementPattern, effectiveStatement));
    }

    public List<DatabaseStatementHistoryData> getDatabaseStatementHistoryDataList() {
        return this.databaseStatementHistoryDataList;
    }
}

