/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class WorkflowNodeUtil {
    private WorkflowNodeUtil() {
    }

    public static boolean hasInputs(WorkflowNode workflowNode) {
        ComponentDescription compDescription = workflowNode.getComponentDescription();
        return !compDescription.getInputDescriptionsManager().getEndpointDescriptions().isEmpty();
    }

    public static boolean hasOutputs(WorkflowNode workflowNode) {
        ComponentDescription compDescription = workflowNode.getComponentDescription();
        return !compDescription.getOutputDescriptionsManager().getEndpointDescriptions().isEmpty();
    }

    public static boolean hasInputs(WorkflowNode workflowNode, DataType type) {
        return !WorkflowNodeUtil.getInputsByDataType(workflowNode, type).isEmpty();
    }

    public static boolean hasOutputs(WorkflowNode workflowNode, DataType type) {
        return !WorkflowNodeUtil.getOutputs(workflowNode, type).isEmpty();
    }

    public static Set<EndpointDescription> getInputs(WorkflowNode workflowNode) {
        return Collections.unmodifiableSet(workflowNode.getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions());
    }

    public static Set<EndpointDescription> getInputsByDataType(WorkflowNode workflowNode, DataType type) {
        return WorkflowNodeUtil.getEndpointsByDataType(workflowNode.getInputDescriptionsManager(), type);
    }

    public static Set<EndpointDescription> getOutputs(WorkflowNode workflowNode) {
        return Collections.unmodifiableSet(workflowNode.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions());
    }

    public static Set<EndpointDescription> getOutputs(WorkflowNode workflowNode, DataType type) {
        return WorkflowNodeUtil.getEndpointsByDataType(workflowNode.getOutputDescriptionsManager(), type);
    }

    private static Set<EndpointDescription> getEndpointsByDataType(EndpointDescriptionsManager endpointManager, DataType type) {
        HashSet<EndpointDescription> result = new HashSet<EndpointDescription>();
        for (EndpointDescription endpointDesc : endpointManager.getEndpointDescriptions()) {
            if (type != endpointDesc.getDataType()) continue;
            result.add(endpointDesc);
        }
        return Collections.unmodifiableSet(result);
    }

    public static boolean hasConfigurationValue(WorkflowNode workflowNode, String key) {
        return workflowNode.getConfigurationDescription().getComponentConfigurationDefinition().getConfigurationKeys().contains(key);
    }

    public static boolean isConfigurationValueSet(ComponentInstanceProperties workflowNode, String key) {
        boolean result = WorkflowNodeUtil.getConfigurationValue(workflowNode, key) != null;
        return result;
    }

    public static String getConfigurationValue(ComponentInstanceProperties workflowNode, String key) {
        return workflowNode.getConfigurationDescription().getConfigurationValue(key);
    }
}

