/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.ReliableRPCStreamHandle;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.LoopComponentConstants;
import de.rcenvironment.core.component.execution.api.ComponentControllerRoutingMap;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContextBuilder;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.ComponentExecutionService;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ConsoleRowBuilder;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.execution.api.EndpointDatumDispatchService;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.WorkflowGraph;
import de.rcenvironment.core.component.execution.api.WorkflowGraphEdge;
import de.rcenvironment.core.component.execution.api.WorkflowGraphNode;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipient;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatumRecipientFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.api.WorkflowConstants;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyListener;
import de.rcenvironment.core.component.workflow.execution.internal.ComponentStatesChangedEntirelyVerifier;
import de.rcenvironment.core.component.workflow.execution.internal.ParallelComponentCaller;
import de.rcenvironment.core.component.workflow.execution.internal.ProvenanceFacade;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionStatsService;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowExecutionStorageBridge;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineContext;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineEvent;
import de.rcenvironment.core.component.workflow.execution.internal.WorkflowStateMachineEventType;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.datamodel.api.FinalWorkflowState;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.AbstractFixedTransitionsStateMachine;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.incubator.StateChangeException;
import de.rcenvironment.provenance.api.ProvenanceEventListener;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class WorkflowStateMachine
extends AbstractFixedTransitionsStateMachine<WorkflowState, WorkflowStateMachineEvent>
implements ComponentStatesChangedEntirelyListener {
    private static final long WAIT_INTERVAL_TERMINATED_SEC = 60L;
    private static final String CAUSE_WAITING_TIME_ELAPSED_SEC = "; cause: waiting time (%d seconds) elapsed";
    private static final String CAUSE_WAITING_TIME_ELAPSED_HRS = "; cause: waiting time (%d hours) elapsed";
    private static final Log LOG = LogFactory.getLog(WorkflowStateMachine.class);
    private static final WorkflowState[][] VALID_WORKFLOW_STATE_TRANSITIONS = new WorkflowState[][]{{WorkflowState.INIT, WorkflowState.PREPARING}, {WorkflowState.PREPARING, WorkflowState.STARTING}, {WorkflowState.PREPARING, WorkflowState.FINISHED}, {WorkflowState.STARTING, WorkflowState.RUNNING}, {WorkflowState.RUNNING, WorkflowState.FINISHED}, {WorkflowState.FINISHED, WorkflowState.DISPOSING}, {WorkflowState.DISPOSING, WorkflowState.DISPOSED}, {WorkflowState.RUNNING, WorkflowState.PAUSING}, {WorkflowState.PAUSING, WorkflowState.PAUSED}, {WorkflowState.PAUSING, WorkflowState.FINISHED}, {WorkflowState.PAUSED, WorkflowState.RESUMING}, {WorkflowState.RESUMING, WorkflowState.RUNNING}, {WorkflowState.PREPARING, WorkflowState.CANCELING}, {WorkflowState.RUNNING, WorkflowState.CANCELING}, {WorkflowState.PAUSED, WorkflowState.CANCELING}, {WorkflowState.CANCELING, WorkflowState.CANCELLED}, {WorkflowState.CANCELLED, WorkflowState.DISPOSING}, {WorkflowState.PREPARING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.STARTING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.RUNNING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.PAUSING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.RESUMING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.CANCELING, WorkflowState.CANCELING_AFTER_FAILED}, {WorkflowState.CANCELING, WorkflowState.FAILED}, {WorkflowState.CANCELING_AFTER_FAILED, WorkflowState.FAILED}, {WorkflowState.RUNNING, WorkflowState.CANCELING_AFTER_RESULTS_REJECTED}, {WorkflowState.CANCELING_AFTER_RESULTS_REJECTED, WorkflowState.RESULTS_REJECTED}, {WorkflowState.RESULTS_REJECTED, WorkflowState.DISPOSING}, {WorkflowState.FAILED, WorkflowState.DISPOSING}};
    protected final Map<WorkflowStateMachineEventType, EventProcessor> eventProcessors = new HashMap<WorkflowStateMachineEventType, EventProcessor>();
    private final CommunicationService communicationService;
    private final DistributedNotificationService notificationService;
    private final ComponentExecutionService componentExecutionService;
    private final WorkflowExecutionStatsService wfExeStatsService;
    private final EndpointDatumDispatchService endpointDatumDispatchService;
    private final ProvenanceFacade provenanceFacade;
    private String wfNameAndIdMessagePart;
    private final ComponentControllerRoutingMap componentControllerCommandDestinations = new ComponentControllerRoutingMap();
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private WorkflowStateMachineContext wfStateMachineCtx;
    private WorkflowDescription fullWorkflowDescription;
    private Map<String, String> executionAuthTokens;
    private ScheduledFuture<?> heartbeatFuture;
    private ScheduledFuture<?> compRestartDetectionFuture;
    private final Map<String, LogicalNodeId> componentNodeIds = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> componentInstanceNames = Collections.synchronizedMap(new HashMap());
    private final CountDownLatch workflowTerminatedLatch = new CountDownLatch(2);
    private CountDownLatch pausedComonentStateLatch = new CountDownLatch(1);
    private CountDownLatch resumedComonentStateLatch = new CountDownLatch(1);
    private final CountDownLatch disposedComponentStateLatch = new CountDownLatch(1);
    private Future<?> currentTask = null;

    @Deprecated
    public WorkflowStateMachine() {
        super((Enum)WorkflowState.INIT, (Enum[][])VALID_WORKFLOW_STATE_TRANSITIONS);
        this.communicationService = null;
        this.notificationService = null;
        this.componentExecutionService = null;
        this.wfExeStatsService = null;
        this.endpointDatumDispatchService = null;
        this.provenanceFacade = null;
    }

    public WorkflowStateMachine(WorkflowStateMachineContext wfStateMachineCtx) {
        super((Enum)WorkflowState.INIT, (Enum[][])VALID_WORKFLOW_STATE_TRANSITIONS);
        this.wfStateMachineCtx = wfStateMachineCtx;
        this.fullWorkflowDescription = wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().clone();
        WorkflowExecutionUtils.removeDisabledWorkflowNodesWithoutNotify(wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription());
        this.wfNameAndIdMessagePart = StringUtils.format((String)"'%s' (%s)", (Object[])new Object[]{wfStateMachineCtx.getWorkflowExecutionContext().getInstanceName(), wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()});
        ServiceRegistryAccess serviceRegistryAccess = wfStateMachineCtx.getServiceRegistryAccess();
        this.communicationService = (CommunicationService)serviceRegistryAccess.getService(CommunicationService.class);
        this.notificationService = (DistributedNotificationService)serviceRegistryAccess.getService(DistributedNotificationService.class);
        this.componentExecutionService = (ComponentExecutionService)serviceRegistryAccess.getService(ComponentExecutionService.class);
        this.wfExeStatsService = (WorkflowExecutionStatsService)serviceRegistryAccess.getService(WorkflowExecutionStatsService.class);
        this.endpointDatumDispatchService = (EndpointDatumDispatchService)serviceRegistryAccess.getService(EndpointDatumDispatchService.class);
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        Optional<ServiceReference> provenanceReference = Optional.ofNullable(context.getServiceReference(ProvenanceEventListener.class));
        Optional<ProvenanceEventListener> provenanceService = provenanceReference.map(arg_0 -> ((BundleContext)context).getService(arg_0));
        this.provenanceFacade = new ProvenanceFacade(provenanceService);
        this.initializeEventProcessors();
    }

    protected void initializeEventProcessors() {
        this.eventProcessors.put(WorkflowStateMachineEventType.START_REQUESTED, new StartRequestedEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.PREPARE_ATTEMPT_SUCCESSFUL, new PrepareAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.START_ATTEMPT_SUCCESSFUL, new StartAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.PAUSE_REQUESTED, new PauseRequestedEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.PAUSE_ATTEMPT_SUCCESSFUL, new PauseAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.RESUME_REQUESTED, new ResumeRequestedEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.RESUME_ATTEMPT_SUCCESSFUL, new ResumeAttemptSuccessfulEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_REQUESTED, new CancelRequestedEventProcessor(WorkflowState.CANCELING));
        CancelRequestedEventProcessor cancelRequestedEventProcessor = new CancelRequestedEventProcessor(WorkflowState.CANCELING_AFTER_FAILED);
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_AFTER_COMPONENT_LOST_REQUESTED, cancelRequestedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_AFTER_FAILED_REQUESTED, cancelRequestedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_AFTER_RESULTS_REJECTED_REQUESTED, new CancelRequestedEventProcessor(WorkflowState.CANCELING_AFTER_RESULTS_REJECTED));
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_ATTEMPT_SUCCESSFUL, new CancelAttemptSuccessufulEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.DISPOSE_REQUESTED, new DisposeRequestedEventProcessor());
        DisposeAttemptSuccessfulOrFailedEventProcessor disposeAttemptSuccessfulOrFailedEventProcessor = new DisposeAttemptSuccessfulOrFailedEventProcessor();
        this.eventProcessors.put(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_SUCCESSFUL, disposeAttemptSuccessfulOrFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_FAILED, disposeAttemptSuccessfulOrFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.ON_COMPONENTS_FINISHED, new OnComponentsFinishedEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.FINISHED, new FinishedEventProcessor());
        PrepareStartPauseResumeFinishTimelineAttemptFailedEventProcessor variousAttemptsFailedEventProcessor = new PrepareStartPauseResumeFinishTimelineAttemptFailedEventProcessor();
        this.eventProcessors.put(WorkflowStateMachineEventType.PREPARE_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.START_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.PAUSE_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.RESUME_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.VERIFICATION_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.FINISH_ATTEMPT_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.PROCESS_COMPONENT_TIMELINE_EVENTS_FAILED, variousAttemptsFailedEventProcessor);
        this.eventProcessors.put(WorkflowStateMachineEventType.COMPONENT_HEARTBEAT_LOST, new ComponentHeartbeatLostEventProcessor());
        this.eventProcessors.put(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, new CancelAttemptFailedEventProcessor());
    }

    protected WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) throws StateChangeException {
        return this.eventProcessors.get((Object)event.getType()).processEvent(currentState, event);
    }

    public void setComponentExecutionAuthTokens(Map<String, String> exeAuthTokens) {
        this.executionAuthTokens = exeAuthTokens;
    }

    private boolean checkStateChange(WorkflowState currentState, WorkflowState newState) {
        if (this.isStateChangeValid(currentState, newState)) {
            return true;
        }
        this.logInvalidStateChangeRequest(currentState, newState);
        return false;
    }

    private void handleFailure(WorkflowStateMachineEvent event) {
        if (event.getThrowable() != null) {
            String errorMessagePrefix = StringUtils.format((String)"Workflow %s failed and will be cancelled", (Object[])new Object[]{this.wfNameAndIdMessagePart});
            String errorId = LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)LOG, (String)errorMessagePrefix, (Throwable)event.getThrowable());
            String errorMessage = ComponentUtils.createErrorLogMessage((Throwable)event.getThrowable(), (String)errorId);
            this.storeAndSendErrorLogMessage(ConsoleRow.Type.WORKFLOW_ERROR, errorMessage, "", "");
        } else {
            LogicalNodeId componentNode = this.componentNodeIds.get(event.getComponentExecutionId());
            String componentName = this.componentInstanceNames.get(event.getComponentExecutionId());
            String errorMessagePrefix = StringUtils.format((String)"Workflow %s will be cancelled because component '%s' on %s failed", (Object[])new Object[]{this.wfNameAndIdMessagePart, componentName, componentNode});
            if (event.getErrorMessage() != null) {
                String errorMessage = ComponentUtils.createErrorLogMessage((String)event.getErrorMessage(), (String)event.getErrorId());
                this.storeAndSendErrorLogMessage(ConsoleRow.Type.COMPONENT_ERROR, errorMessage, event.getComponentExecutionId(), componentName);
            }
            LOG.error((Object)StringUtils.format((String)"%s: for more information, look for the error marker %s in the log files of %s", (Object[])new Object[]{errorMessagePrefix, event.getErrorId(), componentNode}));
        }
    }

    private void logInvalidStateChangeRequest(WorkflowState currentState, WorkflowState requestedState) {
        LOG.debug((Object)StringUtils.format((String)"Ignored workflow state change request for workflow %s as it would cause an invalid state transition: %s -> %s", (Object[])new Object[]{this.wfNameAndIdMessagePart, currentState, requestedState}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStateChanged(WorkflowState oldState, WorkflowState newState) {
        LOG.debug((Object)StringUtils.format((String)"Workflow %s is now %s (previous state: %s)", (Object[])new Object[]{this.wfNameAndIdMessagePart, newState, oldState}));
        this.sendNewWorkflowStateAsConsoleRow(newState);
        this.notificationService.send("rce.component.workflow.state:" + this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier(), (Serializable)((Object)newState.name()));
        if (newState == WorkflowState.DISPOSED) {
            this.disposeNotificationBuffers();
        }
        if (WorkflowConstants.FINAL_WORKFLOW_STATES.contains((Object)newState)) {
            this.wfExeStatsService.addStatsAtWorkflowTermination(this.wfStateMachineCtx.getWorkflowExecutionContext(), newState);
            ComponentStatesChangedEntirelyVerifier componentStatesChangedEntirelyVerifier = this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier();
            synchronized (componentStatesChangedEntirelyVerifier) {
                if (this.heartbeatFuture != null && !this.heartbeatFuture.isCancelled()) {
                    this.heartbeatFuture.cancel(false);
                }
                if (this.compRestartDetectionFuture != null && !this.compRestartDetectionFuture.isCancelled()) {
                    this.compRestartDetectionFuture.cancel(false);
                }
            }
            this.sendLifeCycleEventAsConsoleRow(ConsoleRow.WorkflowLifecyleEventType.WORKFLOW_FINISHED);
        }
    }

    protected void onStateChangeException(WorkflowStateMachineEvent event, StateChangeException e) {
        LOG.error((Object)StringUtils.format((String)"Invalid state change attempt for workflow %s, caused by event '%s'", (Object[])new Object[]{this.wfNameAndIdMessagePart, event}), (Throwable)e);
    }

    void prepareAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncPrepareTask());
    }

    void startAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncStartTask());
    }

    void cancelAsync() {
        this.threadPool.submit((Runnable)new AsyncCancelTask(this.currentTask));
    }

    void pauseAsync() {
        this.threadPool.submit((Runnable)new AsyncPauseTask());
    }

    void resumeAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncResumeTask());
    }

    void disposeAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncDisposeTask());
    }

    void waitForFinishAsync() {
        this.currentTask = this.threadPool.submit((Runnable)new AsyncWaitForFinishTask());
    }

    private void checkForUnreachableComponentNodes(Map<WorkflowNodeIdentifier, ComponentExecutionContext> compExeCtxts) throws WorkflowExecutionException {
        HashMap<String, ComponentExecutionContext> notReachableCompExeIds = new HashMap<String, ComponentExecutionContext>();
        Set reachableNodes = this.communicationService.getReachableLogicalNodes();
        for (ComponentExecutionContext compExeCtx : compExeCtxts.values()) {
            this.componentInstanceNames.put(compExeCtx.getExecutionIdentifier(), compExeCtx.getInstanceName());
            this.componentNodeIds.put(compExeCtx.getExecutionIdentifier(), compExeCtx.getNodeId());
            if (reachableNodes.contains(compExeCtx.getNodeId().convertToDefaultLogicalNodeId())) continue;
            notReachableCompExeIds.put(compExeCtx.getExecutionIdentifier(), compExeCtx);
        }
        try {
            if (!notReachableCompExeIds.isEmpty()) {
                for (ComponentExecutionContext compExeCtx : compExeCtxts.values()) {
                    String compExeId = compExeCtx.getExecutionIdentifier();
                    this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().accounceComponentInAnyFinalState(compExeId);
                    this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().announceLastConsoleRow(compExeId);
                    if (reachableNodes.contains(compExeCtx.getNodeId())) {
                        this.sendComponentStateCanceled(compExeId);
                        continue;
                    }
                    this.sendComponentStateFailed(compExeId);
                }
                throw new WorkflowExecutionException("Failed to execute workflow because component node(s) not reachable: " + this.createMessageListingComponents(notReachableCompExeIds.keySet()));
            }
        }
        finally {
            this.componentInstanceNames.clear();
            this.componentNodeIds.clear();
        }
    }

    private void initializeComponentConsoleLogWriting(String compExeId) {
        try {
            this.wfStateMachineCtx.getComponentsConsoleLogFileWriter().initializeComponentLogFile(compExeId);
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.format((String)"Failed to initialize console log file writers for workflow %s", (Object[])new Object[]{this.wfNameAndIdMessagePart}), (Throwable)e);
        }
    }

    private void initializeConsoleLogWriting() {
        try {
            this.wfStateMachineCtx.getComponentsConsoleLogFileWriter().initializeWorkflowLogFile();
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.format((String)"Failed to initialize console log file writer for workflow %s", (Object[])new Object[]{this.wfNameAndIdMessagePart}), (Throwable)e);
        }
    }

    private void initializeNotificationBuffers() {
        this.notificationService.setBufferSize(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()), 500);
        this.notificationService.setBufferSize("rce.component.workflow.state:" + this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier(), 1);
        this.notificationService.setBufferSize(StringUtils.format((String)"rce.component.input:%s:%s", (Object[])new Object[]{this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId().getLogicalNodeIdString(), this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()}), 500);
        for (WorkflowNode wfNode : this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes()) {
            ComponentExecutionIdentifier compExeId = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wfNode);
            this.notificationService.setBufferSize("rce.component.state:" + compExeId.toString(), 3);
            this.notificationService.setBufferSize("rce.component.noofruns:" + compExeId.toString(), 1);
        }
    }

    private Map<WorkflowNodeIdentifier, ComponentExecutionContext> createComponentExecutionContexts(WorkflowExecutionStorageBridge.DataManagementIdsHolder dmIds) throws WorkflowExecutionException {
        WorkflowDescription workflowDescription = this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription();
        WorkflowGraph workflowGraph = this.createWorkflowGraph(workflowDescription);
        HashMap<WorkflowNodeIdentifier, ComponentExecutionContext> compExeCtxs = new HashMap<WorkflowNodeIdentifier, ComponentExecutionContext>();
        for (WorkflowNode wfNode : workflowDescription.getWorkflowNodes()) {
            compExeCtxs.put(wfNode.getIdentifierAsObject(), this.createComponentExecutionContext(wfNode, workflowGraph, dmIds));
        }
        return compExeCtxs;
    }

    private WorkflowGraph createWorkflowGraph(WorkflowDescription workflowDescription) throws WorkflowExecutionException {
        HashMap<ComponentExecutionIdentifier, WorkflowGraphNode> workflowGraphNodes = new HashMap<ComponentExecutionIdentifier, WorkflowGraphNode>();
        for (WorkflowNode wn : workflowDescription.getWorkflowNodes()) {
            HashMap<String, String> endpointNames = new HashMap<String, String>();
            HashSet<String> inputIds = new HashSet<String>();
            for (EndpointDescription ep : wn.getInputDescriptionsManager().getEndpointDescriptions()) {
                inputIds.add(ep.getIdentifier());
                endpointNames.put(ep.getIdentifier(), ep.getName());
            }
            HashSet<String> outputIds = new HashSet<String>();
            for (EndpointDescription ep : wn.getOutputDescriptionsManager().getEndpointDescriptions()) {
                outputIds.add(ep.getIdentifier());
                endpointNames.put(ep.getIdentifier(), ep.getName());
            }
            ComponentExecutionIdentifier compExeId = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wn);
            workflowGraphNodes.put(compExeId, new WorkflowGraphNode(wn.getIdentifier(), compExeId, inputIds, outputIds, endpointNames, wn.getComponentDescription().getComponentInstallation().getComponentInterface().getIsLoopDriver(), this.isDrivingFaultTolerantNode(wn), wn.getName()));
        }
        HashSet<WorkflowGraphEdge> workflowGraphEdges = new HashSet<WorkflowGraphEdge>();
        for (Connection cn : workflowDescription.getConnections()) {
            WorkflowGraphEdge edge = new WorkflowGraphEdge(this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(cn.getSourceNode()), cn.getOutput().getIdentifier(), cn.getOutput().getEndpointDefinition().getEndpointCharacter(), this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(cn.getTargetNode()), cn.getInput().getIdentifier(), cn.getInput().getEndpointDefinition().getEndpointCharacter());
            workflowGraphEdges.add(edge);
        }
        WorkflowGraph workflowGraph = new WorkflowGraph(workflowGraphNodes, workflowGraphEdges);
        this.validatedNestedLoopDriverConfiguration(workflowDescription, workflowGraph);
        return workflowGraph;
    }

    private void validatedNestedLoopDriverConfiguration(WorkflowDescription workflowDescription, WorkflowGraph workflowGraph) throws WorkflowExecutionException {
        for (WorkflowNode wn : workflowDescription.getWorkflowNodes()) {
            boolean isDriverComp = wn.getComponentDescription().getComponentInstallation().getComponentInterface().getIsLoopDriver();
            if (!isDriverComp) continue;
            ComponentExecutionIdentifier compExeId = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wn);
            Boolean nestedLoop = Boolean.valueOf(wn.getConfigurationDescription().getConfigurationValue("isNestedLoop_5e0ed1cd"));
            try {
                if (nestedLoop.booleanValue() && workflowGraph.getLoopDriver(compExeId) == null) {
                    this.storeAndSendErrorLogMessage(ConsoleRow.Type.WORKFLOW_ERROR, StringUtils.format((String)"Potential configuration error: '%s' is configured as a nested loop driver component but doesn't seem to be part of a loop driven by an outer loop driver component", (Object[])new Object[]{wn.getComponentDescription().getName()}), "", "");
                    continue;
                }
                if (nestedLoop.booleanValue() || workflowGraph.getLoopDriver(compExeId) == null) continue;
                this.storeAndSendErrorLogMessage(ConsoleRow.Type.WORKFLOW_ERROR, StringUtils.format((String)"Potential configuration error: '%s' is part of a loop driven by an outer loop driver component but is not configured as a nested loop driver component", (Object[])new Object[]{wn.getComponentDescription().getName()}), "", "");
            }
            catch (ComponentExecutionException e) {
                throw new WorkflowExecutionException("Wokflow logic invalid", (Exception)((Object)e));
            }
        }
    }

    private boolean isDrivingFaultTolerantNode(WorkflowNode wn) {
        ConfigurationDescription configDesc = wn.getComponentDescription().getConfigurationDescription();
        LoopComponentConstants.LoopBehaviorInCaseOfFailure behavior = LoopComponentConstants.LoopBehaviorInCaseOfFailure.fromString((String)configDesc.getConfigurationValue("loopFaultTolerance_5e0ed1cd"));
        return behavior.equals((Object)LoopComponentConstants.LoopBehaviorInCaseOfFailure.Discard);
    }

    private ComponentExecutionContext createComponentExecutionContext(WorkflowNode wfNode, WorkflowGraph workflowGraph, WorkflowExecutionStorageBridge.DataManagementIdsHolder dmIds) throws WorkflowExecutionException {
        ComponentExecutionIdentifier compExeId = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wfNode);
        WorkflowDescription workflowDescription = this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription();
        ComponentExecutionContextBuilder builder = new ComponentExecutionContextBuilder();
        builder.setExecutionIdentifiers(compExeId.toString(), this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier());
        builder.setInstanceNames(wfNode.getName(), this.wfStateMachineCtx.getWorkflowExecutionContext().getInstanceName());
        builder.setComponentDescription(wfNode.getComponentDescription());
        builder.setNodes(this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), this.wfStateMachineCtx.getWorkflowExecutionContext().getStorageNodeId());
        boolean isConnectedToEndpointDatumSenders = false;
        for (Connection cn : workflowDescription.getConnections()) {
            if (!cn.getTargetNode().equals(wfNode)) continue;
            isConnectedToEndpointDatumSenders = true;
            break;
        }
        HashMap endpointDatumRecipients = new HashMap();
        for (Connection cn : workflowDescription.getConnections()) {
            if (!cn.getSourceNode().equals(wfNode)) continue;
            EndpointDatumRecipient endpointDatumRecipient = EndpointDatumRecipientFactory.createEndpointDatumRecipient((String)cn.getInput().getName(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(cn.getTargetNode()).toString(), (String)cn.getTargetNode().getName(), (LogicalNodeId)cn.getTargetNode().getComponentDescription().getNode());
            if (!endpointDatumRecipients.containsKey(cn.getOutput().getName())) {
                endpointDatumRecipients.put(cn.getOutput().getName(), new ArrayList());
            }
            ((List)endpointDatumRecipients.get(cn.getOutput().getName())).add(endpointDatumRecipient);
        }
        builder.setPredecessorAndSuccessorInformation(isConnectedToEndpointDatumSenders, endpointDatumRecipients);
        builder.setWorkflowGraph(workflowGraph);
        ComponentExecutionIdentifier cei = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wfNode);
        Long compInstanceDmId = dmIds.compInstDmIds.get(cei);
        Map<String, Long> inputDataManagementIds = dmIds.inputDmIds.get(cei);
        Map<String, Long> outputDataManagementIds = dmIds.outputDmIds.get(cei);
        builder.setDataManagementIds(this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().getWorkflowInstanceDataManamagementId(), compInstanceDmId, inputDataManagementIds, outputDataManagementIds);
        return builder.build();
    }

    private void workflowExecutionFinished() {
        if (!this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes().isEmpty()) {
            this.flushAndDisposeComponentLogFiles();
        }
        try {
            this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().setWorkflowExecutionFinished(FinalWorkflowState.FINISHED);
            this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.FINISHED));
        }
        catch (WorkflowExecutionException e) {
            this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.FINISH_ATTEMPT_FAILED, e));
        }
    }

    private void flushAndDisposeComponentLogFiles() {
        this.wfStateMachineCtx.getComponentsConsoleLogFileWriter().addWorkflowConsoleRow(this.createConsoleRowForWorkflowLifeCycleEvent(ConsoleRow.WorkflowLifecyleEventType.WORKFLOW_LOG_FINISHED.name()));
        this.wfStateMachineCtx.getComponentsConsoleLogFileWriter().flushAndDisposeLogFiles();
    }

    private void disposeNotificationBuffers() {
        this.notificationService.removePublisher("rce.component.workflow.state:" + this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier());
        this.notificationService.removePublisher(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()));
        this.notificationService.removePublisher(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()));
        for (WorkflowNode wfNode : this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes()) {
            ComponentExecutionIdentifier compExeId = this.wfStateMachineCtx.getWorkflowExecutionContext().getCompExeIdByWfNode(wfNode);
            this.notificationService.removePublisher("rce.component.state:" + compExeId.toString());
            this.notificationService.removePublisher("rce.component.noofruns:" + compExeId.toString());
        }
    }

    private Set<String> getComponentsToConsider(boolean ignoreCompsInFinalState, boolean ignoreDisposedComps) {
        HashSet<String> compsToConsider = new HashSet<String>(this.componentNodeIds.keySet());
        if (ignoreCompsInFinalState) {
            compsToConsider.removeAll(this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().getComponentsInFinalState());
        } else if (ignoreDisposedComps) {
            compsToConsider.removeAll(this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().getDisposedComponents());
        }
        return compsToConsider;
    }

    private String createMessageListingComponents(Set<String> compExeIds) {
        String message = "";
        for (String compExeId : compExeIds) {
            if (!message.isEmpty()) {
                message = String.valueOf(message) + ", ";
            }
            message = String.valueOf(message) + StringUtils.format((String)"'%s' (%s) at %s", (Object[])new Object[]{this.componentInstanceNames.get(compExeId), compExeId, this.componentNodeIds.get(compExeId)});
        }
        return message;
    }

    private void sendLifeCycleEventAsConsoleRow(ConsoleRow.WorkflowLifecyleEventType type) {
        ConsoleRow consoleRow = this.createConsoleRowForWorkflowLifeCycleEvent(type.name());
        this.sendConsoleRowAsNotification(consoleRow);
    }

    private void sendNewWorkflowStateAsConsoleRow(WorkflowState newState) {
        String payload = StringUtils.escapeAndConcat((String[])new String[]{ConsoleRow.WorkflowLifecyleEventType.NEW_STATE.name(), newState.name()});
        this.sendConsoleRowAsNotification(this.createConsoleRowForWorkflowLifeCycleEvent(payload));
    }

    private void sendConsoleRowAsNotification(ConsoleRow consoleRow) {
        this.notificationService.send(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()), (Serializable)consoleRow);
    }

    private ConsoleRow createConsoleRowForWorkflowLifeCycleEvent(String payload) {
        return this.createConsoleRow(ConsoleRow.Type.LIFE_CYCLE_EVENT, payload, "", "");
    }

    private ConsoleRow createConsoleRow(ConsoleRow.Type type, String payload, String compExeId, String compInstanceName) {
        ConsoleRowBuilder consoleRowBuilder = new ConsoleRowBuilder();
        consoleRowBuilder.setExecutionIdentifiers(this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier(), compExeId).setInstanceNames(this.wfStateMachineCtx.getWorkflowExecutionContext().getInstanceName(), compInstanceName).setType(type).setPayload(payload);
        return consoleRowBuilder.build();
    }

    private void storeAndSendErrorLogMessage(ConsoleRow.Type type, String message, String compExeId, String compInstanceName) {
        ConsoleRow consoleRow = this.createConsoleRow(type, message, compExeId, compInstanceName);
        this.wfStateMachineCtx.getComponentsConsoleLogFileWriter().addWorkflowConsoleRow(consoleRow);
        this.notificationService.send(ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)this.wfStateMachineCtx.getWorkflowExecutionContext().getNodeId(), (String)this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()), (Serializable)consoleRow);
    }

    @Override
    public void onComponentStatesChangedCompletelyToPrepared() {
        this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PREPARE_ATTEMPT_SUCCESSFUL));
    }

    @Override
    public void onComponentStatesChangedCompletelyToPaused() {
        this.pausedComonentStateLatch.countDown();
    }

    @Override
    public void onComponentStatesChangedCompletelyToResumed() {
        this.resumedComonentStateLatch.countDown();
    }

    @Override
    public void onComponentStatesChangedCompletelyToFinished() {
        this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.ON_COMPONENTS_FINISHED));
    }

    @Override
    public void onComponentStatesChangedCompletelyToDisposed() {
        this.disposedComponentStateLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComponentStatesChangedCompletelyToAnyFinalState() {
        ComponentStatesChangedEntirelyVerifier componentStatesChangedEntirelyVerifier = this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier();
        synchronized (componentStatesChangedEntirelyVerifier) {
            if (this.heartbeatFuture != null && !this.heartbeatFuture.isCancelled()) {
                this.heartbeatFuture.cancel(false);
            }
            if (this.compRestartDetectionFuture != null && !this.compRestartDetectionFuture.isCancelled()) {
                this.compRestartDetectionFuture.cancel(false);
            }
        }
        this.workflowTerminatedLatch.countDown();
    }

    @Override
    public void onLastConsoleRowsReceived() {
        this.workflowTerminatedLatch.countDown();
    }

    private Set<String> getComponentsToConsider(boolean ignoreCompsInFinalState) {
        return this.getComponentsToConsider(ignoreCompsInFinalState, true);
    }

    private void sendComponentStateCanceled(String compExeId) {
        this.notificationService.send("rce.component.state:" + compExeId, (Serializable)((Object)ComponentState.CANCELED.name()));
    }

    private void sendComponentStateFailed(String compExeId) {
        this.notificationService.send("rce.component.state:" + compExeId, (Serializable)((Object)ComponentState.FAILED.name()));
    }

    @Override
    public void onComponentsLost(Set<String> compExeIdsLost) {
        for (String compExeIdLost : compExeIdsLost) {
            this.sendComponentStateFailed(compExeIdLost);
        }
        this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.COMPONENT_HEARTBEAT_LOST, new WorkflowExecutionException(StringUtils.format((String)("Component(s) not reachable (anymore): " + this.createMessageListingComponents(compExeIdsLost)), (Object[])new Object[0]))));
    }

    private final class AsyncCancelTask
    implements Runnable {
        private static final int WAIT_INTERVAL_CANCEL_SEC = 90;
        private final Future<?> future;

        protected AsyncCancelTask(Future<?> future) {
            this.future = future;
        }

        @Override
        @TaskDescription(value="Cancel workflow")
        public void run() {
            if (this.future != null) {
                try {
                    this.future.get(90L, TimeUnit.SECONDS);
                }
                catch (ExecutionException e) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, e));
                    return;
                }
                catch (InterruptedException | TimeoutException e) {
                    this.future.cancel(true);
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, e));
                    return;
                }
            }
            Throwable throwable = null;
            if (!WorkflowStateMachine.this.componentNodeIds.isEmpty()) {
                throwable = new ParallelComponentCaller(WorkflowStateMachine.this.getComponentsToConsider(true), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext()){

                    @Override
                    public void callSingleComponent(String compExeId) throws ExecutionControllerException, RemoteOperationException {
                        try {
                            ((AsyncCancelTask)AsyncCancelTask.this).WorkflowStateMachine.this.componentExecutionService.cancel(compExeId, (NetworkDestination)((AsyncCancelTask)AsyncCancelTask.this).WorkflowStateMachine.this.componentNodeIds.get(compExeId));
                        }
                        catch (ExecutionControllerException e) {
                            LOG.debug((Object)StringUtils.format((String)"Failed to cancel component(s) of %s; cause: %s", (Object[])new Object[]{this.getMethodToCallAsString(), e.toString()}));
                        }
                    }

                    @Override
                    public void onErrorInSingleComponentCall(String compExeId, Throwable t) {
                        ((AsyncCancelTask)AsyncCancelTask.this).WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().accounceComponentInAnyFinalState(compExeId);
                        ((AsyncCancelTask)AsyncCancelTask.this).WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().announceLastConsoleRow(compExeId);
                        WorkflowStateMachine.this.sendComponentStateFailed(compExeId);
                    }

                    @Override
                    public String getMethodToCallAsString() {
                        return "cancel";
                    }
                }.callParallelAndWait();
                int compsNotInitCount = WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes().size() - WorkflowStateMachine.this.componentNodeIds.size();
                int i = 0;
                while (i < compsNotInitCount) {
                    String pseudoCompExeId = String.valueOf(i);
                    WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().accounceComponentInAnyFinalState(pseudoCompExeId);
                    WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().announceLastConsoleRow(pseudoCompExeId);
                    ++i;
                }
                try {
                    boolean timeNotElapsed = WorkflowStateMachine.this.workflowTerminatedLatch.await(60L, TimeUnit.SECONDS);
                    if (!timeNotElapsed) {
                        WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for workflow %s to cancel failed; cause: waiting time (%d seconds) elapsed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, 90}))));
                        return;
                    }
                }
                catch (InterruptedException e) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for components to cancel (workflow %s) was interrupted", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), e)));
                    return;
                }
            }
            try {
                WorkflowStateMachine.this.flushAndDisposeComponentLogFiles();
                if (WorkflowStateMachine.this.getState() == WorkflowState.CANCELING_AFTER_FAILED || throwable != null) {
                    WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().setWorkflowExecutionFinished(FinalWorkflowState.FAILED);
                } else if (WorkflowStateMachine.this.getState() == WorkflowState.CANCELING_AFTER_RESULTS_REJECTED) {
                    WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().setWorkflowExecutionFinished(FinalWorkflowState.RESULTS_REJECTED);
                } else if (WorkflowStateMachine.this.getState() == WorkflowState.CANCELING) {
                    WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().setWorkflowExecutionFinished(FinalWorkflowState.CANCELLED);
                }
            }
            catch (WorkflowExecutionException e) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, e));
                return;
            }
            if (throwable == null) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_SUCCESSFUL));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_ATTEMPT_FAILED, throwable));
            }
        }
    }

    private final class AsyncDisposeTask
    implements Runnable {
        private static final int WAIT_INTERVAL_DISPOSE_SEC = 60;

        private AsyncDisposeTask() {
        }

        @Override
        @TaskDescription(value="Dispose workflow")
        public void run() {
            WorkflowExecutionContext workflowExecutionContext = WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext();
            WorkflowStateMachine.this.endpointDatumDispatchService.unregisterComponentControllerForwardingMap(workflowExecutionContext.getWorkflowExecutionHandle().getIdentifier());
            WorkflowStateMachine.this.notificationService.send("rce.component.workflow.state.disposed", (Serializable)((Object)workflowExecutionContext.getExecutionIdentifier()));
            ParallelComponentCaller ppc = new ParallelComponentCaller(WorkflowStateMachine.this.getComponentsToConsider(false, true), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext()){

                @Override
                public void onErrorInSingleComponentCall(String compExeId, Throwable t) {
                    ((AsyncDisposeTask)AsyncDisposeTask.this).WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().announceComponentState(compExeId, ComponentState.DISPOSED);
                }

                @Override
                public void callSingleComponent(String compExeId) throws ExecutionControllerException, RemoteOperationException {
                    ((AsyncDisposeTask)AsyncDisposeTask.this).WorkflowStateMachine.this.componentExecutionService.dispose(compExeId, (NetworkDestination)((AsyncDisposeTask)AsyncDisposeTask.this).WorkflowStateMachine.this.componentNodeIds.get(compExeId));
                }

                @Override
                public String getMethodToCallAsString() {
                    return "dispose";
                }
            };
            Throwable throwable = ppc.callParallelAndWait();
            try {
                boolean timeNotElapsed = WorkflowStateMachine.this.disposedComponentStateLatch.await(60L, TimeUnit.SECONDS);
                if (!timeNotElapsed) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for workflow %s to dispose failed; cause: waiting time (%d seconds) elapsed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, 60}))));
                }
            }
            catch (InterruptedException e) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for components to dispose (workflow %s) was interrupted", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), e)));
                return;
            }
            if (throwable == null) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_SUCCESSFUL));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.DISPOSE_ATTEMPT_FAILED, throwable));
            }
        }
    }

    private final class AsyncPauseTask
    implements Runnable {
        private static final int WAIT_INTERVAL_PAUSE_HRS = 10;

        private AsyncPauseTask() {
        }

        @Override
        @TaskDescription(value="Pause workflow")
        public void run() {
            ParallelComponentCaller ppc = new ParallelComponentCaller(WorkflowStateMachine.this.getComponentsToConsider(true), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext()){

                @Override
                public void onErrorInSingleComponentCall(String compExeId, Throwable t) {
                    ((AsyncPauseTask)AsyncPauseTask.this).WorkflowStateMachine.this.pausedComonentStateLatch.countDown();
                    WorkflowStateMachine.this.sendComponentStateFailed(compExeId);
                }

                @Override
                public void callSingleComponent(String compExeId) throws ExecutionControllerException, RemoteOperationException {
                    ((AsyncPauseTask)AsyncPauseTask.this).WorkflowStateMachine.this.componentExecutionService.pause(compExeId, ((AsyncPauseTask)AsyncPauseTask.this).WorkflowStateMachine.this.componentControllerCommandDestinations.getNetworkDestinationForComponentController(compExeId));
                }

                @Override
                public String getMethodToCallAsString() {
                    return "pause";
                }
            };
            Throwable throwable = ppc.callParallelAndWait();
            try {
                boolean timeNotElapsed = WorkflowStateMachine.this.pausedComonentStateLatch.await(10L, TimeUnit.HOURS);
                if (!timeNotElapsed) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PAUSE_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for workflow %s to pause failed; cause: waiting time (%d hours) elapsed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, 10}))));
                    return;
                }
            }
            catch (InterruptedException e) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PAUSE_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for components to pause (workflow %s) was interrupted", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), e)));
                return;
            }
            if (throwable == null) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PAUSE_ATTEMPT_SUCCESSFUL));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PAUSE_ATTEMPT_FAILED, throwable));
            }
        }
    }

    private final class AsyncPrepareTask
    implements Runnable {
        private AsyncPrepareTask() {
        }

        @Override
        @TaskDescription(value="Prepare workflow")
        public void run() {
            Map<WorkflowNodeIdentifier, ComponentExecutionContext> compExeCtxts;
            WorkflowExecutionStorageBridge.DataManagementIdsHolder dmIds;
            WorkflowExecutionContext workflowExecutionContext = WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext();
            WorkflowStateMachine.this.wfExeStatsService.addStatsAtWorkflowStart(workflowExecutionContext);
            WorkflowStateMachine.this.notificationService.send("rce.component.workflow.new", (Serializable)((Object)WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()));
            WorkflowStateMachine.this.initializeNotificationBuffers();
            WorkflowStateMachine.this.initializeConsoleLogWriting();
            try {
                try {
                    dmIds = WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().addWorkflowExecution(WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext(), WorkflowStateMachine.this.fullWorkflowDescription);
                }
                catch (WorkflowExecutionException e) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PREPARE_ATTEMPT_FAILED, e));
                    WorkflowStateMachine.this.fullWorkflowDescription = null;
                    return;
                }
            }
            finally {
                WorkflowStateMachine.this.fullWorkflowDescription = null;
            }
            if (WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes().isEmpty()) {
                WorkflowStateMachine.this.onComponentStatesChangedCompletelyToPrepared();
            }
            try {
                compExeCtxts = WorkflowStateMachine.this.createComponentExecutionContexts(dmIds);
                WorkflowStateMachine.this.checkForUnreachableComponentNodes(compExeCtxts);
                WorkflowStateMachine.this.wfStateMachineCtx.getNodeRestartWatcher().initialize(compExeCtxts.values());
            }
            catch (WorkflowExecutionException e) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PREPARE_ATTEMPT_FAILED, e));
                return;
            }
            CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(Throwable.class);
            final Long referenceTimestamp = System.currentTimeMillis();
            final ComponentControllerRoutingMap endpointDatumForwardingMap = new ComponentControllerRoutingMap();
            Iterator<WorkflowNode> iterator = WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes().iterator();
            while (iterator.hasNext()) {
                WorkflowNode wfNode;
                final WorkflowNode finalWfNode = wfNode = iterator.next();
                final WorkflowNodeIdentifier workflowNodeId = wfNode.getIdentifierAsObject();
                final ComponentExecutionContext compExeCtx = compExeCtxts.get(workflowNodeId);
                callablesGroup.add((Callable)new Callable<Throwable>(){

                    @Override
                    @TaskDescription(value="Create component execution controller and perform prepare")
                    public Exception call() {
                        try {
                            LOG.debug((Object)("Spawning component controller for workflow node id " + workflowNodeId + " mapped to component execution id " + compExeCtx.getExecutionIdentifier()));
                            ReliableRPCStreamHandle reliableWfCtrlToCompCtrlRPCStream = ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.communicationService.createReliableRPCStream((ResolvableNodeId)compExeCtx.getNodeId());
                            String compExeId = ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.componentExecutionService.init(compExeCtx, ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.executionAuthTokens.get(finalWfNode.getIdentifierAsObject().toString()), referenceTimestamp);
                            ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.provenanceFacade.onComponentInit(compExeId, wfNode.getName());
                            ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.componentNodeIds.put(compExeId, compExeCtx.getNodeId());
                            ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.componentControllerCommandDestinations.setNetworkDestinationForComponentController(compExeId, (NetworkDestination)reliableWfCtrlToCompCtrlRPCStream);
                            ReliableRPCStreamHandle endpointForwardingStream = ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.communicationService.createReliableRPCStream((ResolvableNodeId)compExeCtx.getNodeId());
                            endpointDatumForwardingMap.setNetworkDestinationForComponentController(compExeId, (NetworkDestination)endpointForwardingStream);
                            ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.componentInstanceNames.put(compExeId, compExeCtx.getInstanceName());
                            WorkflowStateMachine.this.initializeComponentConsoleLogWriting(compExeId);
                            ((AsyncPrepareTask)AsyncPrepareTask.this).WorkflowStateMachine.this.componentExecutionService.prepare(compExeId, (NetworkDestination)compExeCtx.getNodeId());
                            LOG.debug((Object)StringUtils.format((String)"Created component '%s' (%s) on node %s", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeId, compExeCtx.getNodeId()}));
                        }
                        catch (ComponentExecutionException | ExecutionControllerException | RemoteOperationException | RuntimeException e) {
                            String errorMessage = StringUtils.format((String)"Failed to initialize component execution of '%s' on %s: %s", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeCtx.getNodeId(), e.toString()});
                            LOG.debug((Object)errorMessage);
                            return new ComponentExecutionException(errorMessage);
                        }
                        return null;
                    }
                }, "Prepare component: " + compExeCtx.getExecutionIdentifier());
            }
            WorkflowStateMachine.this.endpointDatumDispatchService.registerComponentControllerForwardingMap(workflowExecutionContext.getWorkflowExecutionHandle().getIdentifier(), endpointDatumForwardingMap);
            List throwables = callablesGroup.executeParallel(new AsyncExceptionListener(){

                public void onAsyncException(Exception e) {
                }
            });
            for (Throwable t : throwables) {
                if (t == null) continue;
                if (t instanceof ComponentExecutionException) {
                    LOG.error((Object)StringUtils.format((String)"Failed to prepare workflow %s: %s", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, t.toString()}));
                    continue;
                }
                LOG.error((Object)StringUtils.format((String)"Failed to prepare workflow %s", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), t);
            }
            for (Throwable t : throwables) {
                if (t == null) continue;
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.PREPARE_ATTEMPT_FAILED, new Throwable("Failed to prepare workflow: " + t.getMessage())));
                return;
            }
            LOG.debug((Object)StringUtils.format((String)"Workflow %s is prepared (%d component(s))", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, compExeCtxts.size()}));
        }
    }

    private final class AsyncResumeTask
    implements Runnable {
        private static final int WAIT_INTERVAL_CANCEL_SEC = 60;

        private AsyncResumeTask() {
        }

        @Override
        @TaskDescription(value="Resume workflow")
        public void run() {
            ParallelComponentCaller ppc = new ParallelComponentCaller(WorkflowStateMachine.this.getComponentsToConsider(true), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext()){

                @Override
                public void onErrorInSingleComponentCall(String compExeId, Throwable t) {
                    ((AsyncResumeTask)AsyncResumeTask.this).WorkflowStateMachine.this.resumedComonentStateLatch.countDown();
                    WorkflowStateMachine.this.sendComponentStateFailed(compExeId);
                }

                @Override
                public void callSingleComponent(String compExeId) throws ExecutionControllerException, RemoteOperationException {
                    ((AsyncResumeTask)AsyncResumeTask.this).WorkflowStateMachine.this.componentExecutionService.resume(compExeId, ((AsyncResumeTask)AsyncResumeTask.this).WorkflowStateMachine.this.componentControllerCommandDestinations.getNetworkDestinationForComponentController(compExeId));
                }

                @Override
                public String getMethodToCallAsString() {
                    return "resume";
                }
            };
            Throwable throwable = ppc.callParallelAndWait();
            try {
                boolean timeNotElapsed = WorkflowStateMachine.this.resumedComonentStateLatch.await(60L, TimeUnit.SECONDS);
                if (!timeNotElapsed) {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.RESUME_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for workflow %s to resume failed; cause: waiting time (%d seconds) elapsed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart, 60}))));
                    return;
                }
            }
            catch (InterruptedException e) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.RESUME_ATTEMPT_FAILED, new WorkflowExecutionException(StringUtils.format((String)"Waiting for components to resume (workflow %s) was interrupted", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), e)));
                return;
            }
            if (throwable == null) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.RESUME_ATTEMPT_SUCCESSFUL));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.RESUME_ATTEMPT_FAILED, throwable));
            }
        }
    }

    private final class AsyncStartTask
    implements Runnable {
        private AsyncStartTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TaskDescription(value="Start workflow")
        public void run() {
            WorkflowStateMachine.this.sendLifeCycleEventAsConsoleRow(ConsoleRow.WorkflowLifecyleEventType.WORKFLOW_STARTING);
            WorkflowStateMachine.this.provenanceFacade.onWorkflowStart(WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription(), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext());
            ParallelComponentCaller ppc = new ParallelComponentCaller(WorkflowStateMachine.this.componentNodeIds.keySet(), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext()){

                @Override
                public void onErrorInSingleComponentCall(String compExeId, Throwable t) {
                    WorkflowStateMachine.this.sendComponentStateFailed(compExeId);
                }

                @Override
                public void callSingleComponent(String compExeId) throws ExecutionControllerException, RemoteOperationException {
                    ((AsyncStartTask)AsyncStartTask.this).WorkflowStateMachine.this.componentExecutionService.start(compExeId, ((AsyncStartTask)AsyncStartTask.this).WorkflowStateMachine.this.componentControllerCommandDestinations.getNetworkDestinationForComponentController(compExeId));
                    ((AsyncStartTask)AsyncStartTask.this).WorkflowStateMachine.this.wfStateMachineCtx.getComponentLostWatcher().announceComponentHeartbeat(compExeId);
                }

                @Override
                public String getMethodToCallAsString() {
                    return "start";
                }
            };
            Throwable throwable = ppc.callParallelAndWait();
            if (throwable == null) {
                ComponentStatesChangedEntirelyVerifier componentStatesChangedEntirelyVerifier = WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier();
                synchronized (componentStatesChangedEntirelyVerifier) {
                    WorkflowStateMachine.this.heartbeatFuture = WorkflowStateMachine.this.threadPool.scheduleAtFixedInterval("Peridically check for heartbeat messages from components", (Runnable)WorkflowStateMachine.this.wfStateMachineCtx.getComponentLostWatcher(), 10000L);
                    WorkflowStateMachine.this.compRestartDetectionFuture = WorkflowStateMachine.this.threadPool.scheduleAtFixedInterval("Periodically check for restarts of nodes running workflow components", (Runnable)WorkflowStateMachine.this.wfStateMachineCtx.getNodeRestartWatcher(), 10000L);
                }
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.START_ATTEMPT_SUCCESSFUL));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.START_ATTEMPT_FAILED, throwable));
            }
            if (WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getWorkflowDescription().getWorkflowNodes().isEmpty()) {
                WorkflowStateMachine.this.onComponentStatesChangedCompletelyToFinished();
                WorkflowStateMachine.this.onComponentStatesChangedCompletelyToAnyFinalState();
                WorkflowStateMachine.this.onLastConsoleRowsReceived();
                WorkflowStateMachine.this.disposedComponentStateLatch.countDown();
            }
        }
    }

    private final class AsyncWaitForFinishTask
    implements Runnable {
        private AsyncWaitForFinishTask() {
        }

        @Override
        @TaskDescription(value="Wait for workflow to finish")
        public void run() {
            try {
                boolean timeNotElapsed = WorkflowStateMachine.this.workflowTerminatedLatch.await(60L, TimeUnit.SECONDS);
                if (timeNotElapsed) {
                    WorkflowStateMachine.this.workflowExecutionFinished();
                } else {
                    WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.FINISH_ATTEMPT_FAILED, new WorkflowExecutionException(String.valueOf(StringUtils.format((String)"Waiting for workflow %s to finish failed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart})) + " cause: waiting time elapsed")));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)(String.valueOf(StringUtils.format((String)"Waiting for workflow %s to finish failed", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart})) + "cause: waiting interrupted"), (Throwable)e);
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.FINISH_ATTEMPT_FAILED, e));
            }
        }
    }

    private class CancelAttemptFailedEventProcessor
    implements EventProcessor {
        private CancelAttemptFailedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.FAILED)) {
                if (event.getThrowable() != null) {
                    LOG.error((Object)StringUtils.format((String)"Failed to cancel workflow %s", (Object[])new Object[]{WorkflowStateMachine.this.wfNameAndIdMessagePart}), event.getThrowable());
                }
                WorkflowStateMachine.this.flushAndDisposeComponentLogFiles();
                try {
                    WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionStorageBridge().setWorkflowExecutionFinished(FinalWorkflowState.FAILED);
                }
                catch (WorkflowExecutionException workflowExecutionException) {
                    LOG.error((Object)StringUtils.format((String)"Failed to set final state of workflow %s (%s)", (Object[])new Object[]{WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getInstanceName(), WorkflowStateMachine.this.wfStateMachineCtx.getWorkflowExecutionContext().getExecutionIdentifier()}));
                }
                state = WorkflowState.FAILED;
            }
            return state;
        }
    }

    private class CancelAttemptSuccessufulEventProcessor
    implements EventProcessor {
        private CancelAttemptSuccessufulEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (currentState == WorkflowState.CANCELING) {
                if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.CANCELLED)) {
                    state = WorkflowState.CANCELLED;
                }
            } else if (currentState == WorkflowState.CANCELING_AFTER_FAILED) {
                if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.FAILED)) {
                    state = WorkflowState.FAILED;
                }
            } else if (currentState == WorkflowState.CANCELING_AFTER_RESULTS_REJECTED && WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.RESULTS_REJECTED)) {
                state = WorkflowState.RESULTS_REJECTED;
            }
            return state;
        }
    }

    private class CancelRequestedEventProcessor
    implements EventProcessor {
        private final WorkflowState cancelingWfState;

        CancelRequestedEventProcessor(WorkflowState cancelingWfState) {
            this.cancelingWfState = cancelingWfState;
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, this.cancelingWfState)) {
                state = this.cancelingWfState;
                if (this.cancelingWfState.equals((Object)WorkflowState.CANCELING_AFTER_FAILED)) {
                    WorkflowStateMachine.this.handleFailure(event);
                }
                WorkflowStateMachine.this.cancelAsync();
            }
            return state;
        }
    }

    private class ComponentHeartbeatLostEventProcessor
    implements EventProcessor {
        private ComponentHeartbeatLostEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowStateMachine.this.currentTask = null;
            WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().declareLostComponentsAsBeingInFinalStateAndDisposed();
            WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_AFTER_COMPONENT_LOST_REQUESTED, event.getThrowable()));
            return currentState;
        }
    }

    private class DisposeAttemptSuccessfulOrFailedEventProcessor
    implements EventProcessor {
        private DisposeAttemptSuccessfulOrFailedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.DISPOSED)) {
                WorkflowStateMachine.this.currentTask = null;
                state = WorkflowState.DISPOSED;
            }
            return state;
        }
    }

    private class DisposeRequestedEventProcessor
    implements EventProcessor {
        private DisposeRequestedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.DISPOSING)) {
                state = WorkflowState.DISPOSING;
                WorkflowStateMachine.this.disposeAsync();
            }
            return state;
        }
    }

    private static interface EventProcessor {
        public WorkflowState processEvent(WorkflowState var1, WorkflowStateMachineEvent var2);
    }

    private class FinishedEventProcessor
    implements EventProcessor {
        private FinishedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowStateMachine.this.provenanceFacade.onWorkflowFinish();
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.FINISHED)) {
                state = WorkflowState.FINISHED;
            }
            return state;
        }
    }

    private class OnComponentsFinishedEventProcessor
    implements EventProcessor {
        private OnComponentsFinishedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.FINISHED)) {
                WorkflowStateMachine.this.waitForFinishAsync();
            }
            return currentState;
        }
    }

    private class PauseAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private PauseAttemptSuccessfulEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.PAUSED)) {
                state = WorkflowState.PAUSED;
            }
            return state;
        }
    }

    private class PauseRequestedEventProcessor
    implements EventProcessor {
        private PauseRequestedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.PAUSING)) {
                WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().enablePausedComponentStateVerification();
                WorkflowStateMachine.this.pausedComonentStateLatch = new CountDownLatch(1);
                WorkflowStateMachine.this.pauseAsync();
                state = WorkflowState.PAUSING;
            }
            return state;
        }
    }

    private class PrepareAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private PrepareAttemptSuccessfulEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.STARTING)) {
                WorkflowStateMachine.this.currentTask = null;
                WorkflowStateMachine.this.startAsync();
                state = WorkflowState.STARTING;
            }
            return state;
        }
    }

    private class PrepareStartPauseResumeFinishTimelineAttemptFailedEventProcessor
    implements EventProcessor {
        private PrepareStartPauseResumeFinishTimelineAttemptFailedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowStateMachine.this.currentTask = null;
            if (event.getThrowable() != null) {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_AFTER_FAILED_REQUESTED, event.getThrowable()));
            } else {
                WorkflowStateMachine.this.postEvent(new WorkflowStateMachineEvent(WorkflowStateMachineEventType.CANCEL_AFTER_FAILED_REQUESTED, event.getErrorId(), event.getErrorMessage(), event.getComponentExecutionId()));
            }
            return currentState;
        }
    }

    private class ResumeAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private ResumeAttemptSuccessfulEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.RUNNING)) {
                state = WorkflowState.RUNNING;
            }
            return state;
        }
    }

    private class ResumeRequestedEventProcessor
    implements EventProcessor {
        private ResumeRequestedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.RESUMING)) {
                WorkflowStateMachine.this.wfStateMachineCtx.getComponentStatesChangedEntirelyVerifier().enableResumedComponentStateVerification();
                WorkflowStateMachine.this.resumedComonentStateLatch = new CountDownLatch(1);
                WorkflowStateMachine.this.resumeAsync();
                state = WorkflowState.RESUMING;
            }
            return state;
        }
    }

    private class StartAttemptSuccessfulEventProcessor
    implements EventProcessor {
        private StartAttemptSuccessfulEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.RUNNING)) {
                WorkflowStateMachine.this.currentTask = null;
                state = WorkflowState.RUNNING;
            }
            return state;
        }
    }

    private class StartRequestedEventProcessor
    implements EventProcessor {
        private StartRequestedEventProcessor() {
        }

        @Override
        public WorkflowState processEvent(WorkflowState currentState, WorkflowStateMachineEvent event) {
            WorkflowState state = currentState;
            if (WorkflowStateMachine.this.checkStateChange(currentState, WorkflowState.PREPARING)) {
                state = WorkflowState.PREPARING;
                WorkflowStateMachine.this.prepareAsync();
            }
            return state;
        }
    }
}

