/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.spi.MultipleWorkflowsStateChangeListener;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.notification.DefaultNotificationSubscriber;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class WorkflowStateNotificationSubscriber
extends DefaultNotificationSubscriber {
    private static final long serialVersionUID = 421042056359014273L;
    private static final transient long IS_ALIVE_CHECK_INTERVAL_MSEC = 20000L;
    private final transient boolean considersMultipleWorkflows;
    private transient MultipleWorkflowsStateChangeListener multiWfStateChangeListener;
    private transient SingleWorkflowStateChangeListener singleWfStateChangeListener;
    private transient String singleWfExecutionId;
    private volatile transient long latestIsAliveReceived = 0L;
    private transient ScheduledFuture<?> isWorkflowAliveCheckTask = null;
    private AtomicBoolean isStopped = new AtomicBoolean(false);

    public WorkflowStateNotificationSubscriber(MultipleWorkflowsStateChangeListener listener) {
        this.multiWfStateChangeListener = listener;
        this.considersMultipleWorkflows = true;
    }

    public WorkflowStateNotificationSubscriber(SingleWorkflowStateChangeListener listener, String wfExecutionId) {
        this.singleWfStateChangeListener = listener;
        this.singleWfExecutionId = wfExecutionId;
        this.considersMultipleWorkflows = false;
    }

    public Class<?> getInterface() {
        return NotificationSubscriber.class;
    }

    public void processNotification(Notification notification) {
        if (notification.getHeader().getNotificationIdentifier().equals("rce.component.workflow.new")) {
            this.onWorkflowStateChanged((String)((Object)notification.getBody()), WorkflowState.INIT);
        } else if (WorkflowState.isWorkflowStateValid((String)((Object)notification.getBody()))) {
            WorkflowState workflowState = WorkflowState.valueOf((String)((Object)notification.getBody()));
            String wfExecutionId = this.extractWorkflowIdFromNotificationId(notification);
            this.onWorkflowStateChanged(wfExecutionId, workflowState);
        }
    }

    private void onWorkflowStateChanged(String wfExecutionId, WorkflowState newWorkflowState) {
        if (!newWorkflowState.equals((Object)WorkflowState.IS_ALIVE)) {
            if (this.considersMultipleWorkflows) {
                this.multiWfStateChangeListener.onWorkflowStateChanged(wfExecutionId, newWorkflowState);
            } else {
                this.singleWfStateChangeListener.onWorkflowStateChanged(newWorkflowState);
            }
        }
        if (!this.considersMultipleWorkflows) {
            if (FinalWorkflowState.isFinalWorkflowState(newWorkflowState)) {
                this.stopCheckingForWorkflowNotAlive();
            } else if (!newWorkflowState.equals((Object)WorkflowState.DISPOSING) && !newWorkflowState.equals((Object)WorkflowState.DISPOSED)) {
                this.startCheckingForWorkflowNotAlive();
            }
            if (newWorkflowState.equals((Object)WorkflowState.IS_ALIVE)) {
                this.latestIsAliveReceived = System.currentTimeMillis();
            }
        }
    }

    private String extractWorkflowIdFromNotificationId(Notification notification) {
        String topic = notification.getHeader().getNotificationIdentifier();
        return topic.replace("rce.component.workflow.state:", "");
    }

    private synchronized void startCheckingForWorkflowNotAlive() {
        if (this.isWorkflowAliveCheckTask == null) {
            this.latestIsAliveReceived = System.currentTimeMillis();
            this.isWorkflowAliveCheckTask = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedInterval("Check workflow is alive", this::checkIsWorkflowAlive, 20000L);
        }
    }

    private void checkIsWorkflowAlive() {
        if (!this.isStopped.get() && System.currentTimeMillis() - this.latestIsAliveReceived > 20000L) {
            this.isStopped.set(true);
            String errorMessage = StringUtils.format((String)"Receiving 'is alive' message from workflow '%s' stopped. Most likely, because the network connection to the workflow host node was interrupted", (Object[])new Object[]{this.singleWfExecutionId});
            this.singleWfStateChangeListener.onWorkflowNotAliveAnymore(errorMessage);
            ConcurrencyUtils.getAsyncTaskService().submit("Stop checking workflow is alive", this::stopCheckingForWorkflowNotAlive);
        }
    }

    private synchronized void stopCheckingForWorkflowNotAlive() {
        if (this.isWorkflowAliveCheckTask != null) {
            this.isWorkflowAliveCheckTask.cancel(false);
        }
    }
}

