/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.notification.DefaultNotificationSubscriber;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.notification.NotificationSubscriber;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class GenericSubscriptionEventProcessor
extends DefaultNotificationSubscriber {
    private static final long serialVersionUID = 3619909997095130853L;
    private static final int LOCAL_NOTIFICATION_BATCH_SIZE_LIMIT = 2000;
    private static final int LOCAL_NOTIFICATION_BATCH_TIME_LIMIT_MSEC = 200;
    private final transient Map<String, Long> lastMissedNotifications = new HashMap<String, Long>();
    private final transient Map<String, Boolean> catchingUpWithMissedNotifications = new HashMap<String, Boolean>();
    private final transient Map<String, Deque<Notification>> queuedNotifications = new HashMap<String, Deque<Notification>>();
    private final transient BatchAggregator<Notification> batchAggregator;

    public GenericSubscriptionEventProcessor() {
        ConcurrencyUtilsFactory factory = ConcurrencyUtils.getFactory();
        this.batchAggregator = factory.createBatchAggregator(2000, 200L, (BatchProcessor)new BatchProcessor<Notification>(){

            public void processBatch(List<Notification> batch) {
                GenericSubscriptionEventProcessor.this.processCollectedNotifications(batch);
            }
        });
    }

    protected void processNotification(Notification notification) {
        String notifId = this.createIdentifier(notification);
        if (this.catchingUpWithMissedNotifications.containsKey(notifId) && this.catchingUpWithMissedNotifications.get(notifId).booleanValue() && this.lastMissedNotifications.get(notifId) == -1L) {
            this.queuedNotifications.get(notifId).add(notification);
        } else if (this.catchingUpWithMissedNotifications.containsKey(notifId) && this.catchingUpWithMissedNotifications.get(notifId).booleanValue() && notification.getHeader().getNumber() > this.lastMissedNotifications.get(notifId)) {
            this.queuedNotifications.get(notifId).add(notification);
        } else {
            this.handleIncomingNotification(notification);
            if (this.catchingUpWithMissedNotifications.containsKey(notifId) && this.catchingUpWithMissedNotifications.get(notifId).booleanValue() && notification.getHeader().getNumber() == this.lastMissedNotifications.get(notifId).longValue()) {
                this.catchingUpWithMissedNotifications.put(notifId, false);
                while (!this.queuedNotifications.get(notifId).isEmpty()) {
                    this.processNotification(this.queuedNotifications.get(notifId).pollFirst());
                }
            }
        }
    }

    private String createIdentifier(Notification notification) {
        return this.createIdentifier(notification.getHeader().getNotificationIdentifier(), notification.getHeader().getPublishPlatform().getInstanceNodeSessionIdString());
    }

    private String createIdentifier(String notifId, String nodeId) {
        return String.valueOf(notifId) + nodeId;
    }

    private void handleIncomingNotification(Notification notification) {
        this.batchAggregator.enqueue((Object)notification);
    }

    protected abstract void processCollectedNotifications(List<Notification> var1);

    public Class<? extends Serializable> getInterface() {
        return NotificationSubscriber.class;
    }

    public void setNumberOfLastMissingNotification(String notifId, String nodeId, Long lastMissedNumber) {
        String notificationId = this.createIdentifier(notifId, nodeId);
        this.queuedNotifications.put(notificationId, new LinkedList());
        this.lastMissedNotifications.put(notificationId, lastMissedNumber);
        this.catchingUpWithMissedNotifications.put(notificationId, true);
    }

    public void flush() {
    }
}

