/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.internal;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.workflow.execution.SynchronousWorkflowExecutionService;
import de.rcenvironment.core.workflow.execution.internal.WorkflowRunAdapter;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class SynchronousWorkflowExecutionServiceImpl
implements SynchronousWorkflowExecutionService {
    private WorkflowExecutionService workflowExecutionService;
    private DistributedNotificationService notificationService;
    private AsyncTaskService taskService;

    @Override
    public boolean executeWorkflow(WorkflowExecutionContext workflowExecutionContext) throws ComponentException {
        WorkflowExecutionInformation handle = this.startWorkflowExecutionAndGetHandle(workflowExecutionContext);
        return this.awaitWorkflowTermination(handle);
    }

    private WorkflowExecutionInformation startWorkflowExecutionAndGetHandle(WorkflowExecutionContext workflowExecutionContext) throws ComponentException {
        WorkflowExecutionInformation handle;
        try {
            handle = this.workflowExecutionService.startWorkflowExecution(workflowExecutionContext);
        }
        catch (WorkflowExecutionException | RemoteOperationException e) {
            throw new ComponentException("Unexpected exception thrown during start of workflow execution", e);
        }
        return handle;
    }

    private boolean awaitWorkflowTermination(WorkflowExecutionInformation handle) throws ComponentException {
        WorkflowRunAdapter workflowRun;
        WorkflowRunAdapter.Builder workflowRunBuilder = this.createWorkflowRunAdapterBuilder(handle);
        try {
            workflowRun = workflowRunBuilder.buildAndRegisterForWorkflowStateUpdates();
        }
        catch (RemoteOperationException e) {
            throw new ComponentException("Error during registration for workflow state updates", (Throwable)e);
        }
        try {
            workflowRun.awaitWorkflowTermination();
        }
        catch (InterruptedException e) {
            throw new ComponentException("Interrupted while waiting for workflow to finish", (Throwable)e);
        }
        return !workflowRun.executionFailed();
    }

    protected WorkflowRunAdapter.Builder createWorkflowRunAdapterBuilder(WorkflowExecutionInformation handle) {
        return new WorkflowRunAdapter.Builder().workflowExecutionIdentifier(handle.getExecutionIdentifier()).distributedNotificationService(this.notificationService).timeService(this::getWalltime).taskService(this.taskService);
    }

    protected long getWalltime() {
        return System.currentTimeMillis();
    }

    @Reference
    public void bindWorkflowExecutionService(WorkflowExecutionService service) {
        this.workflowExecutionService = service;
    }

    @Reference
    public void bindDistributedNotificationService(DistributedNotificationService service) {
        this.notificationService = service;
    }

    @Reference
    public void bindTaskService(AsyncTaskService service) {
        this.taskService = service;
    }
}

