/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import de.rcenvironment.core.gui.utils.common.configuration.AdapterManager;
import de.rcenvironment.core.gui.utils.common.configuration.BeanPropertyWidget;
import de.rcenvironment.core.gui.utils.common.configuration.IConfigurationSource;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class BeanConfigurationWidget
extends BeanPropertyWidget {
    private IConfigurationSource configurationSource;

    public BeanConfigurationWidget(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void setObject(Object object, boolean lookupPropertySource) {
        if (lookupPropertySource) {
            IConfigurationSource newConfigurationSource = (IConfigurationSource)AdapterManager.getInstance().getAdapter(object, IConfigurationSource.class);
            if (newConfigurationSource == null) {
                newConfigurationSource = (IConfigurationSource)Platform.getAdapterManager().getAdapter(object, IConfigurationSource.class);
            }
            this.configurationSource = newConfigurationSource;
            this.setPropertySource((IPropertySource)newConfigurationSource);
        }
        this.createControls();
        this.resetFocus();
    }

    @Override
    protected void createControls() {
        List<IPropertyDescriptor> descriptors = Arrays.asList(this.configurationSource.getConfigurationPropertyDescriptors());
        this.sortPropertyDescriptors(descriptors);
        for (IPropertyDescriptor descriptor : descriptors) {
            this.createControls(descriptor);
        }
    }
}

