/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;

public final class ClipboardHelper {
    private static final Log LOG = LogFactory.getLog(ClipboardHelper.class);

    private ClipboardHelper() {
    }

    public static void setContent(String content) {
        Clipboard cb = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        try {
            cb.setContents(new Object[]{content}, new Transfer[]{textTransfer});
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        cb.dispose();
    }

    public static String getContentAsStringOrNull() {
        Clipboard cb = new Clipboard(Display.getDefault());
        TransferData[] availableTypes = cb.getAvailableTypes();
        boolean textTransferAvailable = false;
        TransferData[] transferDataArray = availableTypes;
        int n = availableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData availableType = transferDataArray[n2];
            if (TextTransfer.getInstance().isSupportedType(availableType)) {
                textTransferAvailable = true;
                break;
            }
            ++n2;
        }
        if (!textTransferAvailable) {
            cb.dispose();
            return null;
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        String clipboardText = (String)cb.getContents((Transfer)textTransfer);
        cb.dispose();
        return clipboardText;
    }
}

