/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.InputWithOutputsCommandUtils;
import de.rcenvironment.core.gui.workflow.editor.commands.endpoint.RemoveDynamicInputWithOutputCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import java.util.List;

public class RemoveDynamicInputWithOutputsCommand
extends RemoveDynamicInputWithOutputCommand {
    private final String addDynOutputId;
    private final String outputNameSuffix;

    public RemoveDynamicInputWithOutputsCommand(String dynEndpointId, String addDynOutputId, String outputNameSuffix, List<String> names, Refreshable ... panes) {
        super(dynEndpointId, names, panes);
        this.addDynOutputId = addDynOutputId;
        this.outputNameSuffix = outputNameSuffix;
    }

    @Override
    public void initialize() {
        for (String name : this.names) {
            this.oldDescriptions.put(name, this.getProperties().getInputDescriptionsManager().getEndpointDescription(name));
        }
    }

    @Override
    public void execute() {
        for (String name : this.names) {
            InputWithOutputsCommandUtils.removeOutputWithSuffix(this.getProperties(), name, this.outputNameSuffix);
        }
        super.execute();
    }

    @Override
    public void undo() {
        for (String name : this.names) {
            EndpointDescription oldDescription = (EndpointDescription)this.oldDescriptions.get(name);
            InputWithOutputsCommandUtils.addOutputWithSuffix(this.getProperties(), this.addDynOutputId, name, oldDescription.getDataType(), this.outputNameSuffix);
        }
        super.undo();
    }
}

