/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.Map;

public class EditDynamicOutputCommand
extends WorkflowNodeCommand {
    protected String endpointId;
    protected String oldName;
    protected String newName;
    protected DataType newType;
    protected Map<String, String> newMetaData;
    protected String newGroup;
    protected Refreshable[] refreshable;
    private EndpointDescription oldDesc = null;
    private boolean executable = true;
    private boolean undoable = false;

    public EditDynamicOutputCommand(String endpointId, String oldName, String newName, DataType newType, Map<String, String> newMetaData, String newGroup, Refreshable ... refreshable) {
        this.endpointId = endpointId;
        this.oldName = oldName;
        this.newName = newName;
        this.newType = newType;
        this.newMetaData = newMetaData;
        this.newGroup = newGroup;
        this.refreshable = refreshable;
    }

    public EditDynamicOutputCommand(String endpointId, String oldName, String newName, DataType newType, Map<String, String> newMetaData, Refreshable ... refreshable) {
        this(endpointId, oldName, newName, newType, newMetaData, (String)null, refreshable);
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        if (this.executable) {
            String group;
            Map metaData;
            EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
            this.oldDesc = this.getProperties().getOutputDescriptionsManager().getEndpointDescription(this.oldName);
            DataType type = this.newType;
            if (this.newType == null) {
                type = this.oldDesc.getDataType();
            }
            if ((metaData = this.newMetaData) == null) {
                metaData = this.oldDesc.getMetaData();
            }
            if ((group = this.newGroup) == null) {
                group = this.oldDesc.getParentGroupName();
            }
            outputManager.editDynamicEndpointDescription(this.oldName, this.newName, type, metaData, this.endpointId, group);
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        if (this.undoable) {
            EndpointDescriptionsManager outputManager = this.getProperties().getOutputDescriptionsManager();
            outputManager.editDynamicEndpointDescription(this.newName, this.oldName, this.oldDesc.getDataType(), this.oldDesc.getMetaData(), this.oldDesc.getDynamicEndpointIdentifier(), this.oldDesc.getParentGroupName());
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }
}

