/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.loader.execution;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.api.EndpointXMLService;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlLoaderComponent
extends DefaultComponent {
    private ComponentContext componentContext;
    private ComponentDataManagementService dataManagementService;
    private String xmlContent = null;
    private XmlComponentHistoryDataItem historyDataItem = null;
    private File tempFile = null;
    private EndpointXMLService endpointXmlUtils;

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }

    public boolean treatStartAsComponentRun() {
        return this.componentContext.getInputs().isEmpty();
    }

    public void start() throws ComponentException {
        this.dataManagementService = (ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class);
        this.endpointXmlUtils = (EndpointXMLService)this.componentContext.getService(EndpointXMLService.class);
        this.xmlContent = this.componentContext.getConfigurationValue("xmlContent");
        if (this.xmlContent == null) {
            throw new ComponentException("No XML content configured that should be loaded and sent");
        }
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public void processInputs() throws ComponentException {
        FileReferenceTD fileReference;
        this.initializeNewHistoryDataItem();
        try {
            this.tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("XMLLoader-*.xml");
            FileUtils.writeStringToFile((File)this.tempFile, (String)this.xmlContent);
        }
        catch (IOException e) {
            throw new ComponentException("Failed to write XML file into a temporary file (that is required for XML Loader)", (Throwable)e);
        }
        HashMap<String, TypedDatum> variableInputs = new HashMap<String, TypedDatum>();
        for (String inputName : this.componentContext.getInputsWithDatum()) {
            if (!this.componentContext.isDynamicInput(inputName)) continue;
            variableInputs.put(inputName, this.componentContext.readInput(inputName));
        }
        if (this.historyDataItem != null && !variableInputs.isEmpty()) {
            try {
                this.historyDataItem.setPlainXMLFileReference(this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, this.tempFile, "plain.xml").getFileReference());
                this.storeHistoryDataItem();
            }
            catch (IOException e) {
                String errorMessage = "Failed to store plain XML file into the data management; it will not be available in the workflow data browser";
                String errorId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LogFactory.getLog(XmlLoaderComponent.class), (String)errorMessage, (Throwable)e);
                this.componentContext.getLog().componentError(errorMessage, (Throwable)e, errorId);
            }
        }
        try {
            this.endpointXmlUtils.updateXMLWithInputs(this.tempFile, variableInputs, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to add dynamic input values to the XML file", (Throwable)e);
        }
        try {
            fileReference = this.dataManagementService.createFileReferenceTDFromLocalFile(this.componentContext, this.tempFile, String.valueOf(this.componentContext.getInstanceName()) + ".xml");
        }
        catch (IOException e) {
            throw new ComponentException("Failed to store XML file into the data management - if it is not stored in the data management, it can not be sent as output value", (Throwable)e);
        }
        this.componentContext.writeOutput("XML", (TypedDatum)fileReference);
        try {
            this.endpointXmlUtils.updateOutputsFromXML(this.tempFile, this.componentContext);
        }
        catch (DataTypeException e) {
            throw new ComponentException("Failed to extract dynamic output values from the XML file", (Throwable)e);
        }
        this.deleteTempFile();
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.storeHistoryDataItem();
        this.deleteTempFile();
    }

    private void deleteTempFile() {
        if (this.tempFile != null) {
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tempFile);
            }
            catch (IOException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)("Failed to delete temp file: " + this.tempFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new XmlComponentHistoryDataItem("de.rcenvironment.xmlloader");
        }
    }

    private void storeHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }
}

