/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.api;

import org.apache.commons.logging.LogFactory;

public final class ThreadGuard {
    private static final Policy BEHAVIOUR_ON_DETECTION = Policy.LOG_STACKTRACE;
    private static volatile Thread forbiddenThread;

    private ThreadGuard() {
    }

    public static void checkForForbiddenThread() {
        if (forbiddenThread == null || BEHAVIOUR_ON_DETECTION == Policy.DISABLED) {
            return;
        }
        if (Thread.currentThread() == forbiddenThread) {
            IllegalStateException exception = new IllegalStateException("Operation run in forbidden thread (usually the GUI thread)");
            if (BEHAVIOUR_ON_DETECTION == Policy.THROW_EXCEPTION) {
                throw exception;
            }
            if (BEHAVIOUR_ON_DETECTION == Policy.LOG_STACKTRACE) {
                LogFactory.getLog(ThreadGuard.class).warn((Object)"Operation run in forbidden thread, creating a stack trace (no exception was thrown)", (Throwable)exception);
            }
        }
    }

    public static void setForbiddenThread(Thread forbiddenThread) {
        ThreadGuard.forbiddenThread = forbiddenThread;
    }

    public static enum Policy {
        DISABLED,
        LOG_STACKTRACE,
        THROW_EXCEPTION;

    }
}

