/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.textstream;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;

public class TextStreamWatcher {
    private final AsyncTaskService asyncTaskService;
    private final List<WatcherRunnable> watcherRunnables = new ArrayList<WatcherRunnable>(4);
    private List<Future<?>> watcherTaskFutures;

    public TextStreamWatcher(AsyncTaskService asyncTaskService) {
        this.asyncTaskService = asyncTaskService;
    }

    public TextStreamWatcher(InputStream input, AsyncTaskService asyncTaskService, TextOutputReceiver ... receivers) {
        this.asyncTaskService = asyncTaskService;
        this.registerStream(input, receivers);
    }

    public synchronized TextStreamWatcher registerStream(InputStream inputStream, TextOutputReceiver ... receivers) {
        this.watcherRunnables.add(new WatcherRunnable(inputStream, receivers));
        return this;
    }

    public synchronized TextStreamWatcher start() {
        if (this.wasStarted()) {
            throw new IllegalStateException("Watcher task was already started");
        }
        this.watcherTaskFutures = new ArrayList(this.watcherRunnables.size());
        for (WatcherRunnable watcherRunnable : this.watcherRunnables) {
            this.watcherTaskFutures.add(this.asyncTaskService.submit((Runnable)watcherRunnable));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTermination() {
        ArrayList watcherTaskFuturesCopy;
        TextStreamWatcher textStreamWatcher = this;
        synchronized (textStreamWatcher) {
            if (!this.wasStarted()) {
                throw new IllegalStateException("Watcher task was not started yet");
            }
            watcherTaskFuturesCopy = new ArrayList(this.watcherTaskFutures);
        }
        try {
            for (Future future : watcherTaskFuturesCopy) {
                future.get();
            }
        }
        catch (InterruptedException interruptedException) {
            LogFactory.getLog(this.getClass()).debug((Object)"Interrupted while waiting for stream watcher task to finish");
        }
        catch (ExecutionException executionException) {
            LogFactory.getLog(this.getClass()).warn((Object)"Exception while waiting for stream watcher task to finish", (Throwable)executionException);
        }
    }

    public synchronized void cancel() {
        if (!this.wasStarted()) {
            throw new IllegalStateException("Watcher task was not started yet");
        }
        for (Future<?> watcherTaskFuture : this.watcherTaskFutures) {
            watcherTaskFuture.cancel(true);
        }
    }

    private boolean wasStarted() {
        return this.watcherTaskFutures != null;
    }

    private final class WatcherRunnable
    implements Runnable {
        private BufferedReader bufferedReader;
        private final TextOutputReceiver[] receivers;

        private WatcherRunnable(InputStream inputStream, TextOutputReceiver ... receivers) {
            Objects.requireNonNull(inputStream, "The input stream to be read from cannot be null");
            TextOutputReceiver[] textOutputReceiverArray = receivers;
            int n = receivers.length;
            int n2 = 0;
            while (n2 < n) {
                TextOutputReceiver r = textOutputReceiverArray[n2];
                Objects.requireNonNull(r, "Received a 'null' receiver argument");
                ++n2;
            }
            this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.receivers = receivers;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @TaskDescription(value="Text stream watching/reading")
        public void run() {
            block9: {
                var4_1 = this.receivers;
                var3_5 = this.receivers.length;
                var2_7 = 0;
                while (var2_7 < var3_5) {
                    receiver = var4_1[var2_7];
                    receiver.onStart();
                    ++var2_7;
                }
                try {
                    while ((line = this.bufferedReader.readLine()) != null) {
                        var5_12 = this.receivers;
                        var4_2 = this.receivers.length;
                        var3_5 = 0;
                        while (var3_5 < var4_2) {
                            receiver = var5_12[var3_5];
                            receiver.addOutput(line);
                            ++var3_5;
                        }
                    }
                    var5_12 = this.receivers;
                    var4_3 = this.receivers.length;
                    var3_5 = 0;
                    while (var3_5 < var4_3) {
                        receiver = var5_12[var3_5];
                        receiver.onFinished();
                        ++var3_5;
                    }
                    break block9;
                }
                catch (IOException e) {
                    var6_14 = this.receivers;
                    var5_13 = this.receivers.length;
                    var4_4 = 0;
                    ** while (var4_4 < var5_13)
                }
lbl-1000:
                // 1 sources

                {
                    receiver = var6_14[var4_4];
                    try {
                        receiver.onFatalError(e);
                    }
                    catch (RuntimeException e1) {
                        LogFactory.getLog(this.getClass()).error((Object)"Exception in onException() callback", (Throwable)e1);
                    }
                    ++var4_4;
                    continue;
                }
            }
            IOUtils.closeQuietly((Reader)this.bufferedReader);
        }
    }
}

