/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import com.jcraft.jsch.JSchException;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.AbstractStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ExternalServiceHolder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import de.rcenvironment.toolkit.modules.concurrency.api.RunnablesGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class InstanceManagementStepDefinitionBase
extends AbstractStepDefinitionBase {
    protected static final AtomicInteger PORT_NUMBER_GENERATOR = new AtomicInteger(52100);
    protected static final InstanceManagementService INSTANCE_MANAGEMENT_SERVICE = ExternalServiceHolder.getInstanceManagementService();
    private static final int CONCURRENT_INSTANCE_STARTING_STAGGERED_DELAY_MSEC = 1000;

    public InstanceManagementStepDefinitionBase(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    protected final String executeCommandOnInstance(ManagedInstance instance, String commandString, boolean isMainAction) throws OperationFailureException {
        String instanceId = instance.getId();
        String startInfoText = StringUtils.format((String)"Executing command \"%s\" on instance \"%s\"", (Object[])new Object[]{commandString, instanceId});
        if (isMainAction) {
            this.printToCommandConsole(startInfoText);
        }
        this.log.debug((Object)startInfoText);
        CapturingTextOutReceiver commandOutputReceiver = new CapturingTextOutReceiver();
        try {
            int numAttempts = 0;
            while (numAttempts < 3) {
                try {
                    INSTANCE_MANAGEMENT_SERVICE.executeCommandOnInstance(instanceId, commandString, (TextOutputReceiver)commandOutputReceiver);
                    break;
                }
                catch (JSchException e) {
                    if (!e.toString().contains("Connection refused: connect")) {
                        throw this.testExecutionError(StringUtils.format((String)"Failed to execute command \"%s\" on instance \"%s\": %s", (Object[])new Object[]{commandString, instanceId, e.toString()}));
                    }
                    ++numAttempts;
                }
            }
            if (numAttempts >= 3) {
                throw this.testExecutionError(StringUtils.format((String)"Failed to execute command \"%s\" on instance \"%s\": Maximum number of attempts exceeded", (Object[])new Object[]{commandString, instanceId}));
            }
            if (numAttempts > 1) {
                String retrySuffix = " after retrying the SSH connection for " + (numAttempts - 1) + " times";
                this.printToCommandConsole(StringUtils.format((String)"  (Executed command \"%s\" on instance \"%s\"%s)", (Object[])new Object[]{commandString, instanceId, retrySuffix}));
            }
            String commandOutput = commandOutputReceiver.getBufferedOutput();
            instance.setLastCommandOutput(commandOutput);
            this.log.debug((Object)StringUtils.format((String)"Finished execution of command \"%s\" on instance \"%s\"", (Object[])new Object[]{commandString, instanceId}));
            return commandOutput;
        }
        catch (SshParameterException | IOException | InterruptedException | TimeoutException e) {
            throw this.testExecutionError(StringUtils.format((String)"Failed to execute command \"%s\" on instance \"%s\": %s", (Object[])new Object[]{commandString, instanceId, e.toString()}));
        }
    }

    protected void iterateInstances(InstanceIterator instanceIterator, String allFlag, String instanceIds) throws OperationFailureException, IOException {
        for (ManagedInstance instance : this.resolveInstanceList(allFlag != null, instanceIds)) {
            instanceIterator.iterateActionOverInstance(instance);
        }
    }

    protected void performActionOnInstances(final InstanceAction action, final List<ManagedInstance> instances, InstanceActionExecutionType executionMode) {
        switch (executionMode) {
            case CONCURRENT: {
                RunnablesGroup runnablesGroup = ConcurrencyUtils.getFactory().createRunnablesGroup();
                int staggeredStartDelayCounter = 0;
                for (final ManagedInstance instance : instances) {
                    final int staggeredStartDelayForInstance = staggeredStartDelayCounter;
                    runnablesGroup.add(new Runnable(){

                        @Override
                        public void run() {
                            if (action.getClass().getSimpleName().endsWith("StartInstanceAction")) {
                                try {
                                    Thread.sleep(staggeredStartDelayForInstance);
                                }
                                catch (InterruptedException interruptedException) {
                                    InstanceManagementStepDefinitionBase.this.log.warn((Object)("Interrupted while waiting to initiate staggered start of instance " + instance.getId()));
                                    return;
                                }
                            }
                            try {
                                action.performActionOnInstance(instance, 60 * instances.size());
                            }
                            catch (OperationFailureException | IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    staggeredStartDelayCounter += 1000;
                }
                this.executeRunnablesGroupAndHandlePotentialErrors(runnablesGroup, "performing action on instance");
                break;
            }
            case ORDERED: {
                for (ManagedInstance instance : instances) {
                    try {
                        action.performActionOnInstance(instance, 60 * instances.size());
                    }
                    catch (OperationFailureException | IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                break;
            }
            case RANDOM: {
                Collections.shuffle(instances);
                for (ManagedInstance instance : instances) {
                    try {
                        action.performActionOnInstance(instance, 60 * instances.size());
                    }
                    catch (OperationFailureException | IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                break;
            }
            default: {
                throw this.internalError("unknown execution mode");
            }
        }
    }

    protected InstanceActionExecutionType resolveExecutionMode(String executionDesc, InstanceActionExecutionType fallback) {
        if (executionDesc == null) {
            if (fallback != null) {
                return fallback;
            }
            throw this.internalError("executionDesc was set to null, which is not supported. Provide a fallback execution mode to circumvent this.");
        }
        switch (executionDesc) {
            case "in the given order": {
                return InstanceActionExecutionType.ORDERED;
            }
            case "concurrently": {
                return InstanceActionExecutionType.CONCURRENT;
            }
            case "in a random order": {
                return InstanceActionExecutionType.RANDOM;
            }
        }
        if (fallback != null) {
            return fallback;
        }
        throw this.internalError("executionDesc was set to an unsupported value. Provide a fallback execution mode to circumvent this.");
    }

    protected InstanceActionExecutionType resolveExecutionMode(String executionDesc) {
        return this.resolveExecutionMode(executionDesc, null);
    }

    protected final ManagedInstance resolveInstance(String instanceId) throws OperationFailureException {
        ManagedInstance instanceIfPresent = this.executionContext.getInstanceFromId(instanceId);
        if (instanceIfPresent == null) {
            throw new OperationFailureException(StringUtils.format((String)"Unregistered instance id '%s'", (Object[])new Object[]{instanceId}));
        }
        return instanceIfPresent;
    }

    protected List<ManagedInstance> resolveInstanceList(boolean allFlag, String instanceIds) throws OperationFailureException {
        ArrayList<ManagedInstance> instances;
        if (instanceIds == null) {
            instances = new ArrayList<ManagedInstance>(this.executionContext.getEnabledInstances());
        } else if (!allFlag) {
            instances = new ArrayList();
            for (String instanceId : this.parseCommaSeparatedList(instanceIds)) {
                instances.add(this.resolveInstance(instanceId));
            }
        } else {
            throw this.internalError("calling this operation for all instances and providing a list is not supported. Choose either one.");
        }
        return instances;
    }

    private void executeRunnablesGroupAndHandlePotentialErrors(RunnablesGroup runnablesGroup, String singleTaskDescription) {
        List exceptions = runnablesGroup.executeParallel();
        boolean hasFailure = false;
        for (RuntimeException e : exceptions) {
            if (e == null) continue;
            this.log.warn((Object)("Exception while asynchronously " + singleTaskDescription), (Throwable)e);
            hasFailure = true;
        }
        if (hasFailure) {
            for (RuntimeException e : exceptions) {
                if (e == null) continue;
                throw e;
            }
        }
    }

    protected static interface InstanceAction {
        public void performActionOnInstance(ManagedInstance var1, long var2) throws OperationFailureException, IOException;
    }

    protected static enum InstanceActionExecutionType {
        ORDERED,
        CONCURRENT,
        RANDOM;

    }

    protected static interface InstanceIterator {
        public void iterateActionOverInstance(ManagedInstance var1) throws OperationFailureException, IOException;
    }
}

