/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.MultiStateParameter;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedListParameter;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.StringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.extras.testscriptrunner.internal.CucumberTestFrameworkAdapter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestScriptRunnerCommandPlugin
implements CommandPlugin {
    private static final String SEPARATOR_TEXT_LINE = "-----------------------------------------------------------------------------------------------";
    private static final String FORMAT = "--format";
    private static final String PRETTY = "pretty";
    private static final String JSON = "json";
    private static final String ALL_TOKEN = ":all";
    private static final StringParameter BUILD_UNDER_TEST_ID_PARAMETER = new StringParameter(null, "build under test id", "build version to be used");
    private static final StringParameter TAG_NAME_FILTER_PARAMETER = new StringParameter(null, "tag name filter", "filter for tag names");
    private static final ListCommandParameter LIST_TAG_NAME_FILTER_PARAMETER = new ListCommandParameter((AbstractCommandParameter)TAG_NAME_FILTER_PARAMETER, "tag name filters", "filter for tag names");
    private static final MultiStateParameter FORMAT_PARAMETER = new MultiStateParameter("format", "output format", new String[]{"pretty", "json"});
    private static final NamedSingleParameter NAMED_FORMAT_PARAMETER = new NamedSingleParameter("--format", "output format", (AbstractCommandParameter)FORMAT_PARAMETER);
    private ConfigurationSegment configuration;
    private File scriptLocationRoot;
    private final CucumberTestFrameworkAdapter testFrameworkAdapter;
    private final Log log = LogFactory.getLog(this.getClass());
    private final File reportsRootDir;

    public TestScriptRunnerCommandPlugin() throws IOException {
        this.testFrameworkAdapter = new CucumberTestFrameworkAdapter();
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            TempFileServiceAccess.setupUnitTestEnvironment();
        }
        this.reportsRootDir = TempFileServiceAccess.getInstance().createManagedTempDir("tsr_reports");
    }

    protected void bindConfigurationService(ConfigurationService configurationService) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.configuration = configurationService.getConfigurationSegment("testScriptRunner");
        String scriptLocation = this.configuration.getString("scriptLocation");
        if (!StringUtils.isNullorEmpty((String)scriptLocation)) {
            this.scriptLocationRoot = new File(scriptLocation);
        } else {
            try {
                this.scriptLocationRoot = configurationService.getUnpackedFilesLocation("testScripts");
            }
            catch (ConfigurationException e) {
                this.log.error((Object)"Failed to locate the default script file location, and no explicit path setting found - disabling TestScriptRunner", (Throwable)e);
                this.scriptLocationRoot = null;
                return;
            }
        }
        this.log.debug((Object)("Using test script folder " + this.scriptLocationRoot));
    }

    private void performRunTests(CommandContext context) throws IOException, CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter buildUnderTestIdParameter = (ParsedStringParameter)modifiers.getPositionalCommandParameter(1);
        String buildUnderTestId = buildUnderTestIdParameter.getResult();
        CucumberTestFrameworkAdapter.ReportOutputFormat reportFormat = this.extractReportFormat(context);
        String tagNameFilter = this.extractTagNameFilter(modifiers);
        CucumberTestFrameworkAdapter.ExecutionResult result = this.testFrameworkAdapter.executeTestScripts(this.scriptLocationRoot, tagNameFilter, context.getOutputReceiver(), buildUnderTestId, this.reportsRootDir, reportFormat);
        if (result.getExecutionResultStatus().equals((Object)CucumberTestFrameworkAdapter.ExecutionResultStatus.UNSUCCESSFUL)) {
            List<String> reportLines = result.getReportFileLines();
            if (reportLines != null) {
                context.println((Object)"");
                context.println((Object)"Test run complete, content of report file:");
                context.println((Object)SEPARATOR_TEXT_LINE);
                for (String line : reportLines) {
                    context.println((Object)line);
                }
                context.println((Object)SEPARATOR_TEXT_LINE);
            } else {
                context.println((Object)"Test run complete (no report file found)");
            }
            List<String> stdOutLines = result.getCapturedStdOutLines();
            if (!stdOutLines.isEmpty()) {
                context.println((Object)"");
                context.println((Object)"Captured Output:");
                context.println((Object)SEPARATOR_TEXT_LINE);
                for (String line : stdOutLines) {
                    context.println((Object)line);
                }
                context.println((Object)SEPARATOR_TEXT_LINE);
            }
        }
    }

    private String extractTagNameFilter(ParsedCommandModifiers modifiers) {
        ParsedListParameter tagNameFilterParameter = (ParsedListParameter)modifiers.getPositionalCommandParameter(0);
        StringJoiner joiner = new StringJoiner(",");
        int i = 0;
        while (i < tagNameFilterParameter.getResult().size()) {
            ParsedStringParameter parameter = (ParsedStringParameter)tagNameFilterParameter.getResult().get(i);
            if (parameter.getResult().equals(ALL_TOKEN)) {
                return null;
            }
            joiner.add(parameter.getResult());
            ++i;
        }
        return joiner.toString();
    }

    private CucumberTestFrameworkAdapter.ReportOutputFormat extractReportFormat(CommandContext context) throws CommandException {
        ParsedCommandModifiers modifiers = context.getParsedModifiers();
        ParsedStringParameter formatParameter = (ParsedStringParameter)modifiers.getCommandParameter(FORMAT);
        switch (formatParameter.getResult()) {
            case "pretty": {
                return CucumberTestFrameworkAdapter.ReportOutputFormat.PRETTY;
            }
            case "json": {
                return CucumberTestFrameworkAdapter.ReportOutputFormat.JSON;
            }
        }
        throw CommandException.syntaxError((String)StringUtils.format((String)"Unknown report format specifier '%s'. Supported report formats: pretty, json", (Object[])new Object[]{formatParameter.getResult()}), (CommandContext)context);
    }

    public MainCommandDescription[] getCommands() {
        return new MainCommandDescription[]{new MainCommandDescription("run-test", "run a test", "run a test", context -> {
            try {
                this.performRunTests(context);
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }, new CommandModifierInfo(new AbstractCommandParameter[]{LIST_TAG_NAME_FILTER_PARAMETER, BUILD_UNDER_TEST_ID_PARAMETER}, new NamedParameter[]{NAMED_FORMAT_PARAMETER}), true, new SubCommandDescription[0]), new MainCommandDescription("run-tests", "(alias of \"run-test\")", "(alias of \"run-test\")", context -> {
            try {
                this.performRunTests(context);
            }
            catch (IOException e) {
                throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
            }
        }, new CommandModifierInfo(new AbstractCommandParameter[]{LIST_TAG_NAME_FILTER_PARAMETER, BUILD_UNDER_TEST_ID_PARAMETER}, new NamedParameter[]{NAMED_FORMAT_PARAMETER}), true, new SubCommandDescription[0])};
    }
}

