/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.gui.Messages;
import de.rcenvironment.components.switchcmp.gui.SwitchAddDynamicEndpointCommand;
import de.rcenvironment.components.switchcmp.gui.SwitchEditDynamicEndpointCommand;
import de.rcenvironment.components.switchcmp.gui.SwitchEndpointEditDialog;
import de.rcenvironment.components.switchcmp.gui.SwitchRemoveDynamicEndpointCommand;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointSelectionPane;
import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

public class SwitchDataInputSelectionPane
extends EndpointSelectionPane {
    private EndpointSelectionPane[] panes;

    public SwitchDataInputSelectionPane(WorkflowNodeCommand.Executor executor) {
        super(Messages.dataInputString, EndpointType.INPUT, "dataToInput", new String[0], new String[0], executor);
    }

    protected void onAddClicked() {
        SwitchEndpointEditDialog dialog = new SwitchEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.ADD, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, this.endpointManager.getDynamicEndpointDefinition(this.dynEndpointIdToManage).getMetaDataDefinition(), new HashMap<String, String>());
        this.onAddClicked(dialog);
    }

    protected void onEditClicked() {
        String name = (String)this.table.getSelection()[0].getData();
        EndpointDescription endpoint = this.endpointManager.getEndpointDescription(name);
        Map newMetaData = this.cloneMetaData(endpoint.getMetaData());
        SwitchEndpointEditDialog dialog = new SwitchEndpointEditDialog(Display.getDefault().getActiveShell(), EndpointActionType.EDIT, this.configuration, this.endpointType, this.dynEndpointIdToManage, false, endpoint.getEndpointDefinition().getMetaDataDefinition(), newMetaData);
        this.onEditClicked(name, dialog);
    }

    protected void executeEditCommand(EndpointDescription oldDescription, EndpointDescription newDescription) {
        SwitchEditDynamicEndpointCommand command = new SwitchEditDynamicEndpointCommand(this.endpointType, oldDescription, newDescription, (Refreshable[])this.panes);
        this.execute((WorkflowNodeCommand)command);
    }

    protected void executeAddCommand(String name, DataType type, Map<String, String> metaData) {
        SwitchAddDynamicEndpointCommand command = new SwitchAddDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, name, type, metaData, (Refreshable[])this.panes);
        this.execute((WorkflowNodeCommand)command);
    }

    protected void executeRemoveCommand(List<String> names) {
        SwitchRemoveDynamicEndpointCommand command = new SwitchRemoveDynamicEndpointCommand(this.endpointType, this.dynEndpointIdToManage, names, (Refreshable[])this.panes);
        this.execute((WorkflowNodeCommand)command);
    }

    public void setAllPanes(EndpointSelectionPane[] allPanes) {
        this.panes = allPanes;
    }
}

