/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import javax.mail.Quota;

public class SetQuotaCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "SETQUOTA";

    SetQuotaCommand() {
        super(NAME, null);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) {
        if (!session.getHost().getStore().isQuotaSupported()) {
            response.commandFailed(this, "Quota is not supported. Activate quota capability first");
        }
        try {
            String root = this.parser.mailbox(request);
            Quota quota = new Quota(root);
            this.parser.consumeChar(request, ' ');
            this.parser.consumeChar(request, '(');
            quota.setResourceLimit(this.parser.astring(request), this.parser.consumeLong(request));
            char c = request.nextWordChar();
            if (')' != c) {
                quota.setResourceLimit(this.parser.astring(request), this.parser.consumeLong(request));
            }
            this.parser.consumeChar(request, ')');
            session.getHost().getStore().setQuota(quota, session.getUser().getQualifiedMailboxName());
            response.commandComplete(this);
        }
        catch (ProtocolException e) {
            response.commandFailed(this, "Can not parse command" + e.getMessage());
        }
    }
}

