/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

public class TerminalPosition {
    private int row;
    private int column;

    public TerminalPosition(TerminalPosition position) {
        this(position.getColumn(), position.getRow());
    }

    public TerminalPosition(int column, int row) {
        this.row = row;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void ensurePositivePosition() {
        if (this.row < 0) {
            this.row = 0;
        }
        if (this.column < 0) {
            this.column = 0;
        }
    }

    public String toString() {
        return "[" + this.column + ":" + this.row + "]";
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.row;
        hash = 53 * hash + this.column;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalPosition other = (TerminalPosition)obj;
        if (this.row != other.row) {
            return false;
        }
        return this.column == other.column;
    }
}

