/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalPosition;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScreenInfoCharacterPattern
implements CharacterPattern {
    private static final Pattern REPORT_CURSOR_PATTERN = Pattern.compile("\\[([0-9]+);([0-9]+)R");

    @Override
    public Key getResult(List<Character> matching) {
        return new Key(Key.Kind.CursorLocation);
    }

    @Override
    public boolean isCompleteMatch(List<Character> currentMatching) {
        if (currentMatching.isEmpty()) {
            return false;
        }
        if (currentMatching.get(0).charValue() != '\u001b') {
            return false;
        }
        String asString = "";
        for (int i = 1; i < currentMatching.size(); ++i) {
            asString = asString + currentMatching.get(i);
        }
        Matcher matcher = REPORT_CURSOR_PATTERN.matcher(asString);
        return matcher.matches();
    }

    @Override
    public boolean matches(List<Character> currentMatching) {
        if (currentMatching.isEmpty()) {
            return true;
        }
        if (currentMatching.get(0).charValue() != '\u001b') {
            return false;
        }
        if (currentMatching.size() == 1) {
            return true;
        }
        if (currentMatching.get(1).charValue() != '[') {
            return false;
        }
        if (currentMatching.size() == 2) {
            return true;
        }
        int i = 2;
        for (i = 2; i < currentMatching.size(); ++i) {
            if (!Character.isDigit(currentMatching.get(i).charValue()) && ';' != currentMatching.get(i).charValue()) {
                return false;
            }
            if (';' == currentMatching.get(i).charValue()) break;
        }
        if (i == currentMatching.size()) {
            return true;
        }
        ++i;
        while (i < currentMatching.size()) {
            if (!Character.isDigit(currentMatching.get(i).charValue()) && 'R' != currentMatching.get(i).charValue()) {
                return false;
            }
            if ('R' == currentMatching.get(i).charValue()) break;
            ++i;
        }
        return true;
    }

    public static TerminalPosition getCursorPosition(List<Character> currentMatching) {
        if (currentMatching.isEmpty()) {
            return null;
        }
        if (currentMatching.get(0).charValue() != '\u001b') {
            return null;
        }
        String asString = "";
        for (int i = 1; i < currentMatching.size(); ++i) {
            asString = asString + currentMatching.get(i);
        }
        Matcher matcher = REPORT_CURSOR_PATTERN.matcher(asString);
        if (!matcher.matches()) {
            return null;
        }
        return new TerminalPosition(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(1)));
    }
}

