/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Component;
import com.googlecode.lanterna.gui.Container;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.InteractableContainer;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.component.AbstractComponent;
import com.googlecode.lanterna.gui.component.EmptySpace;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.layout.LayoutParameter;
import com.googlecode.lanterna.gui.layout.LinearLayout;
import com.googlecode.lanterna.gui.util.ShortcutHelper;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table
extends AbstractComponent
implements InteractableContainer {
    private final ShortcutHelper shortcutHelper;
    private final Panel mainPanel;
    private final List<Component[]> rows;
    private Panel[] columns;

    public Table() {
        this(1);
    }

    public Table(String title) {
        this(1, title);
    }

    public Table(int nrOfColumns) {
        this(nrOfColumns, null);
    }

    public Table(int nrOfColumns, String title) {
        this.mainPanel = title == null ? new Panel(Panel.Orientation.HORISONTAL) : new Panel(title, Panel.Orientation.HORISONTAL);
        this.shortcutHelper = new ShortcutHelper();
        this.rows = new ArrayList<Component[]>();
        this.columns = new Panel[0];
        this.alterTableStructure(nrOfColumns);
    }

    public void setColumnPaddingSize(int size) {
        ((LinearLayout)this.mainPanel.getLayoutManager()).setPadding(size);
    }

    public void addRow(Component ... components) {
        int i;
        Component[] newRow = new Component[this.columns.length];
        for (i = 0; i < this.columns.length; ++i) {
            newRow[i] = i >= components.length ? new EmptySpace(1, 1) : components[i];
        }
        this.rows.add(newRow);
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i].addComponent(newRow[i], new LayoutParameter[0]);
        }
        this.invalidate();
    }

    public int getNrOfRows() {
        return this.rows.size();
    }

    public Component[] getRow(int index) {
        return (Component[])Arrays.copyOf((Object[])this.rows.get(index), this.columns.length);
    }

    public void removeRow(int index) {
        Component[] row = this.getRow(index);
        this.rows.remove(index);
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].removeComponent(row[i]);
        }
        this.invalidate();
    }

    public final void alterTableStructure(int nrOfColumns) {
        this.removeAllRows();
        this.mainPanel.removeAllComponents();
        this.columns = new Panel[nrOfColumns];
        for (int i = 0; i < nrOfColumns; ++i) {
            this.columns[i] = new Panel(Panel.Orientation.VERTICAL);
            this.mainPanel.addComponent(this.columns[i], new LayoutParameter[0]);
        }
    }

    public void removeAllRows() {
        this.rows.clear();
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].removeAllComponents();
        }
        this.invalidate();
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        return this.mainPanel.getPreferredSize();
    }

    @Override
    public void repaint(TextGraphics graphics) {
        this.mainPanel.repaint(graphics);
    }

    @Override
    protected void setParent(Container container) {
        super.setParent(container);
        this.mainPanel.setParent(this.getParent());
    }

    @Override
    public boolean hasInteractable(Interactable interactable) {
        return this.mainPanel.hasInteractable(interactable);
    }

    @Override
    public Interactable nextFocus(Interactable fromThis) {
        return this.mainPanel.nextFocus(fromThis);
    }

    @Override
    public Interactable previousFocus(Interactable fromThis) {
        return this.mainPanel.previousFocus(fromThis);
    }

    @Override
    public void addShortcut(Key.Kind key, Action action) {
        this.shortcutHelper.addShortcut(key, action);
    }

    @Override
    public void addShortcut(char character, boolean withCtrl, boolean withAlt, Action action) {
        this.shortcutHelper.addShortcut(character, withCtrl, withAlt, action);
    }

    @Override
    public boolean triggerShortcut(Key key) {
        return this.shortcutHelper.triggerShortcut(key);
    }

    public String getTitle() {
        return this.mainPanel.getTitle();
    }

    public void setTitle(String title) {
        this.mainPanel.setTitle(title);
    }
}

