/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractListBox;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalSize;

public class RadioCheckBoxList
extends AbstractListBox {
    private int checkedIndex = -1;

    public RadioCheckBoxList() {
        this(null);
    }

    public RadioCheckBoxList(TerminalSize preferredSize) {
        super(preferredSize);
    }

    @Override
    public void clearItems() {
        this.checkedIndex = -1;
        super.clearItems();
    }

    @Override
    public void addItem(Object item) {
        super.addItem(item);
    }

    public Boolean isChecked(Object object) {
        if (object == null) {
            return null;
        }
        if (this.indexOf(object) == -1) {
            return null;
        }
        return this.checkedIndex == this.indexOf(object);
    }

    public Boolean isChecked(int index) {
        if (index < 0 || index >= this.getNrOfItems()) {
            return null;
        }
        return this.checkedIndex == index;
    }

    public void setCheckedItemIndex(int index) {
        if (index < -1 || index >= this.getNrOfItems()) {
            return;
        }
        this.checkedIndex = index;
        this.invalidate();
    }

    public int getCheckedItemIndex() {
        return this.checkedIndex;
    }

    public Object getCheckedItem() {
        if (this.checkedIndex == -1 || this.checkedIndex >= this.getNrOfItems()) {
            return null;
        }
        return this.getItemAt(this.checkedIndex);
    }

    @Override
    protected Interactable.Result unhandledKeyboardEvent(Key key) {
        if (this.getSelectedIndex() == -1) {
            return Interactable.Result.EVENT_NOT_HANDLED;
        }
        if (key.getKind() == Key.Kind.Enter || key.getCharacter() == ' ') {
            this.checkedIndex = this.getSelectedIndex();
            return Interactable.Result.EVENT_HANDLED;
        }
        return Interactable.Result.EVENT_NOT_HANDLED;
    }

    @Override
    protected int getHotSpotPositionOnLine(int selectedIndex) {
        return 1;
    }

    @Override
    protected String createItemString(int index) {
        String check = " ";
        if (this.checkedIndex == index) {
            check = "o";
        }
        String text = this.getItemAt(index).toString();
        return "<" + check + "> " + text;
    }

    @Override
    protected Theme.Definition getListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
    }

    @Override
    protected Theme.Definition getSelectedListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
    }
}

