/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger.proxyrender;

import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.ConsoleLogRenderer;
import org.eclipse.jem.util.logger.proxyrender.DefaultPluginTraceRenderer;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.osgi.framework.Bundle;

public class EclipseLogger
extends Logger {
    public static final String DEBUG_TRACE_OPTION = "/debug/logtrace";
    public static final String DEBUG_TRACE_FILE_OPTION = "/debug/logtracefile";
    public static final String DEBUG_LOG_LEVEL_OPTION = "/debug/loglevel";
    public static final String DEFAULT_OPTION = "default";

    public static Logger getEclipseLogger(Plugin plugin) {
        return EclipseLogger.getEclipseLogger(plugin.getBundle());
    }

    public static Logger getEclipseLogger(Bundle bundle) {
        String id = bundle.getSymbolicName();
        Logger logger = EclipseLogger.getLoggerIfExists(id);
        if (logger != null) {
            return logger;
        }
        logger = EclipseLogger.getLogger(id);
        String pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_TRACE_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(JEMUtilPlugin.getDefault().getBundle().getSymbolicName()) + DEBUG_TRACE_OPTION));
        }
        boolean logTrace = "true".equalsIgnoreCase(pluginOption);
        pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_TRACE_FILE_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(JEMUtilPlugin.getDefault().getBundle().getSymbolicName()) + DEBUG_TRACE_FILE_OPTION));
        }
        boolean logTraceFile = "true".equalsIgnoreCase(pluginOption);
        pluginOption = Platform.getDebugOption((String)(String.valueOf(id) + DEBUG_LOG_LEVEL_OPTION));
        if (pluginOption == null || DEFAULT_OPTION.equalsIgnoreCase(pluginOption)) {
            pluginOption = Platform.getDebugOption((String)(String.valueOf(JEMUtilPlugin.getDefault().getBundle().getSymbolicName()) + DEBUG_LOG_LEVEL_OPTION));
        }
        Level logLevel = Level.WARNING;
        if (pluginOption != null) {
            try {
                logLevel = Level.parse(pluginOption);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (logTrace) {
            logger.setTraceMode(true);
        }
        logger.setLevel(logLevel);
        if (!logTraceFile) {
            logger.setRenderer(new ConsoleLogRenderer(logger));
        } else {
            logger.setRenderer(new DefaultPluginTraceRenderer(logger));
        }
        return logger;
    }
}

