/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ToolMockModeSection
extends ValidatingWorkflowNodePropertySection {
    public static final String PROPERTY_NODE_ATTRIBUTES = "de.rcenvironment.props.n";
    private Button checkBox;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionProperties = factory.createSection(parent, 320);
        sectionProperties.setText("Tool run imitation mode");
        Composite sectionInstallationClient = factory.createFlatFormComposite((Composite)sectionProperties);
        sectionInstallationClient.setLayout((Layout)new GridLayout(1, false));
        this.checkBox = factory.createButton(sectionInstallationClient, "Use the integrated tool in tool run imitation mode", 32);
        this.checkBox.setData("property.control", (Object)"isImitationMode");
        factory.createLabel(sectionInstallationClient, "\nNote: The tool provider decides whether this component can be used in tool run imitation mode.\n\nIf a component is used in tool run imitation mode, usually the tool behind is not executed, but dummy output values are sent instead.\nThe actual behavior in tool run imitation mode is defined by the tool provider when integrating the tool.");
        sectionProperties.setClient((Control)sectionInstallationClient);
    }

    protected void setProperty(String key, String value) {
        super.setProperty(key, value);
        this.node.firePropertyChange(PROPERTY_NODE_ATTRIBUTES);
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        this.node = workflowNode;
        boolean isDeactivationSupported = Boolean.valueOf(workflowNode.getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration().getValue("imitationModeSupported"));
        if (!isDeactivationSupported) {
            this.setProperty("isImitationMode", String.valueOf(false));
            this.checkBox.setSelection(false);
        }
        this.checkBox.setEnabled(isDeactivationSupported);
    }
}

