/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.DataModelPausibleOperationImpl;

public final class DataModelImpl
implements IDataModel,
IDataModelListener {
    private static final String PROPERTY_NOT_LOCATED_ = WTPResourceHandler.getString("20");
    private static final String NESTED_MODEL_NOT_LOCATED = WTPResourceHandler.getString("21");
    private static final DataModelPropertyDescriptor[] NO_DESCRIPTORS = new DataModelPropertyDescriptor[0];
    private Collection basePropertyNames;
    private Collection allPropertyNames;
    private Collection nestedPropertyNames;
    private Map propertyValues = new Hashtable();
    private Map nestedModels;
    private Set nestingModels;
    private List listeners;
    private IDataModelProvider provider;

    public DataModelImpl(IDataModelProvider dataModelProvider) {
        this.init(dataModelProvider);
    }

    private void init(IDataModelProvider dataModelProvider) {
        this.provider = dataModelProvider;
        dataModelProvider.setDataModel(this);
        Set<String> propertyNames = dataModelProvider.getPropertyNames();
        HashSet<String> properties = new HashSet<String>();
        properties.addAll(propertyNames);
        properties.add("IDataModelProperties.ALLOW_EXTENSIONS");
        properties.add("IDataModelProperties.RESTRICT_EXTENSIONS");
        this.basePropertyNames = Collections.unmodifiableCollection(properties);
        this.allPropertyNames = new HashSet();
        this.allPropertyNames.addAll(this.basePropertyNames);
        dataModelProvider.init();
    }

    public boolean isBaseProperty(String propertyName) {
        return this.basePropertyNames.contains(propertyName);
    }

    public Collection getBaseProperties() {
        return Collections.unmodifiableCollection(this.basePropertyNames);
    }

    public boolean isProperty(String propertyName) {
        return this.allPropertyNames.contains(propertyName);
    }

    public Collection getAllProperties() {
        return Collections.unmodifiableCollection(this.allPropertyNames);
    }

    public boolean isNestedProperty(String propertyName) {
        return this.nestedPropertyNames != null && this.nestedPropertyNames.contains(propertyName);
    }

    public Collection getNestedProperties() {
        return Collections.unmodifiableCollection(this.nestedPropertyNames);
    }

    private void checkValidPropertyName(String propertyName) {
        if (!this.isProperty(propertyName)) {
            throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
        }
    }

    private DataModelImpl getOwningDataModel(String propertyName) {
        this.checkValidPropertyName(propertyName);
        return this.searchNestedModels(propertyName);
    }

    private DataModelImpl searchNestedModels(String propertyName) {
        if (this.isBaseProperty(propertyName)) {
            return this;
        }
        if (this.nestedModels != null) {
            DataModelImpl dataModel = null;
            Object[] keys = this.nestedModels.keySet().toArray();
            int i = 0;
            while (i < keys.length) {
                dataModel = (DataModelImpl)this.nestedModels.get(keys[i]);
                if (dataModel.isProperty(propertyName)) {
                    return dataModel.searchNestedModels(propertyName);
                }
                ++i;
            }
        }
        throw new RuntimeException(String.valueOf(PROPERTY_NOT_LOCATED_) + propertyName);
    }

    public Object getProperty(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        if (dataModel.propertyValues.containsKey(propertyName)) {
            return dataModel.propertyValues.get(propertyName);
        }
        return dataModel.provider.getDefaultProperty(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        return dataModel.provider.getDefaultProperty(propertyName);
    }

    public int getIntProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return -1;
        }
        return (Integer)prop;
    }

    public boolean getBooleanProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return false;
        }
        return (Boolean)prop;
    }

    public String getStringProperty(String propertyName) {
        Object prop = this.getProperty(propertyName);
        if (prop == null) {
            return "";
        }
        return (String)prop;
    }

    public boolean isPropertySet(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        return dataModel.propertyValues.containsKey(propertyName);
    }

    public boolean isPropertyEnabled(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        return dataModel.provider.isPropertyEnabled(propertyName);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        dataModel.internalSetProperty(propertyName, propertyValue);
    }

    private void internalSetProperty(String propertyName, Object propertyValue) {
        Object oldValue = this.propertyValues.get(propertyName);
        if (this.valueChanged(propertyValue, oldValue)) {
            if (propertyValue != null) {
                this.propertyValues.put(propertyName, propertyValue);
            } else if (this.propertyValues.containsKey(propertyName)) {
                this.propertyValues.remove(propertyName);
            }
            if (this.provider.propertySet(propertyName, propertyValue)) {
                this.notifyPropertyChange(propertyName, 1);
            }
        }
    }

    private boolean valueChanged(Object o1, Object o2) {
        return o1 != o2 && (o1 != null && !o1.equals(o2) || !o2.equals(o1));
    }

    public void setIntProperty(String propertyName, int value) {
        this.setProperty(propertyName, new Integer(value));
    }

    public void setBooleanProperty(String propertyName, boolean value) {
        this.setProperty(propertyName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStringProperty(String propertyName, String value) {
        this.setProperty(propertyName, value);
    }

    public boolean addNestedModel(String modelName, IDataModel dataModel) {
        if (this == dataModel) {
            return false;
        }
        if (this.nestedModels == null) {
            this.nestedModels = new Hashtable();
            this.nestedPropertyNames = new HashSet();
        }
        DataModelImpl nestedDataModel = (DataModelImpl)dataModel;
        if (nestedDataModel.nestingModels == null) {
            nestedDataModel.nestingModels = new HashSet();
        }
        if (nestedDataModel.nestingModels.contains(this)) {
            return false;
        }
        nestedDataModel.nestingModels.add(this);
        this.nestedModels.put(modelName, nestedDataModel);
        this.addNestedProperties(nestedDataModel.allPropertyNames);
        nestedDataModel.addListener(this);
        return true;
    }

    private void addNestedProperties(Collection nestedProperties) {
        boolean propertiesAdded = this.allPropertyNames.addAll(nestedProperties);
        boolean bl = propertiesAdded = this.nestedPropertyNames.addAll(nestedProperties) || propertiesAdded;
        if (propertiesAdded && this.nestingModels != null) {
            Iterator iterator = this.nestingModels.iterator();
            while (iterator.hasNext()) {
                ((DataModelImpl)iterator.next()).addNestedProperties(nestedProperties);
            }
        }
    }

    public Collection getNestedModels() {
        return this.nestedModels != null ? Collections.unmodifiableCollection(this.nestedModels.values()) : Collections.EMPTY_SET;
    }

    public Collection getNestedModelNames() {
        return this.nestedModels != null ? Collections.unmodifiableCollection(this.nestedModels.keySet()) : Collections.EMPTY_SET;
    }

    public Collection getNestingModels() {
        return this.nestingModels != null ? Collections.unmodifiableCollection(this.nestingModels) : Collections.EMPTY_SET;
    }

    public IDataModel removeNestedModel(String modelName) {
        if (!this.isNestedModel(modelName)) {
            return null;
        }
        DataModelImpl model = (DataModelImpl)this.nestedModels.remove(modelName);
        model.nestingModels.remove(this);
        this.removeNestedProperties(model.allPropertyNames);
        model.removeListener(this);
        if (this.nestedModels.isEmpty()) {
            this.nestedModels = null;
        }
        return model;
    }

    private void removeNestedProperties(Collection nestedProperties) {
        Iterator iterator = nestedProperties.iterator();
        String property = null;
        boolean keepProperty = false;
        HashSet<String> nestedPropertiesToRemove = null;
        while (iterator.hasNext()) {
            keepProperty = false;
            property = (String)iterator.next();
            if (this.basePropertyNames.contains(property)) {
                keepProperty = true;
            }
            if (!keepProperty && this.nestedModels != null) {
                Iterator nestedModelsIterator = this.nestedModels.values().iterator();
                while (!keepProperty && nestedModelsIterator.hasNext()) {
                    DataModelImpl nestedModel = (DataModelImpl)nestedModelsIterator.next();
                    if (!nestedModel.isProperty(property)) continue;
                    keepProperty = true;
                }
            }
            if (keepProperty) continue;
            if (nestedPropertiesToRemove == null) {
                nestedPropertiesToRemove = new HashSet<String>();
            }
            nestedPropertiesToRemove.add(property);
        }
        if (nestedPropertiesToRemove != null) {
            this.allPropertyNames.removeAll(nestedPropertiesToRemove);
            this.nestedPropertyNames.removeAll(nestedPropertiesToRemove);
            if (this.nestingModels != null) {
                Iterator nestingModelsIterator = this.nestingModels.iterator();
                while (nestingModelsIterator.hasNext()) {
                    ((DataModelImpl)nestingModelsIterator.next()).removeNestedProperties(nestedPropertiesToRemove);
                }
            }
        }
    }

    public boolean isNestedModel(String modelName) {
        return modelName != null && this.nestedModels != null && this.nestedModels.containsKey(modelName);
    }

    public IDataModel getNestedModel(String modelName) {
        IDataModel dataModel;
        IDataModel iDataModel = dataModel = this.nestedModels != null && modelName != null ? (IDataModel)this.nestedModels.get(modelName) : null;
        if (dataModel == null) {
            throw new RuntimeException(String.valueOf(NESTED_MODEL_NOT_LOCATED) + modelName);
        }
        return dataModel;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        DataModelPropertyDescriptor[] descriptors = dataModel.provider.getValidPropertyDescriptors(propertyName);
        return descriptors == null ? NO_DESCRIPTORS : descriptors;
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        DataModelPropertyDescriptor descriptor = dataModel.provider.getPropertyDescriptor(propertyName);
        return descriptor == null ? new DataModelPropertyDescriptor(this.getProperty(propertyName)) : descriptor;
    }

    public void notifyPropertyChange(String propertyName, int flag) {
        int innerFlag = flag;
        if (innerFlag == 2) {
            if (this.isPropertySet(propertyName)) {
                return;
            }
            innerFlag = 1;
        }
        this.notifyListeners(new DataModelEvent(this, propertyName, innerFlag));
    }

    private void notifyListeners(DataModelEvent event) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            int i = 0;
            while (i < this.listeners.size()) {
                IDataModelListener listener = (IDataModelListener)this.listeners.get(i);
                if (listener != event.getDataModel()) {
                    listener.propertyChanged(event);
                }
                ++i;
            }
        }
    }

    public void propertyChanged(DataModelEvent event) {
        this.notifyListeners(event);
    }

    public IStatus validate() {
        return this.validate(true);
    }

    public IStatus validate(boolean stopOnFirstFailure) {
        IStatus status = null;
        int i = 0;
        while (i < 2) {
            Iterator it;
            switch (i) {
                case 0: {
                    it = this.basePropertyNames.iterator();
                    break;
                }
                default: {
                    it = this.getNestedModelNames().iterator();
                    break;
                }
            }
            while (it.hasNext()) {
                String propName = (String)it.next();
                IStatus propStatus = this.provider.validate(propName);
                if (propStatus == null) continue;
                if (status == null || status.isOK()) {
                    status = propStatus;
                } else if (status.isMultiStatus()) {
                    ((MultiStatus)status).merge(propStatus);
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.wst.common.frameworks.internal", 0, "", null);
                    multi.merge(status);
                    multi.merge(propStatus);
                    status = multi;
                }
                if (!stopOnFirstFailure || status.isOK() || status.getSeverity() != 4) continue;
                return status;
            }
            ++i;
        }
        if (status == null) {
            return IDataModelProvider.OK_STATUS;
        }
        return status;
    }

    public void addListener(IDataModelListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
                this.listeners.add(listener);
            } else if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void removeListener(IDataModelListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean isValid() {
        return this.validate(true).getSeverity() != 4;
    }

    public boolean isPropertyValid(String propertyName) {
        return this.validateProperty(propertyName).getSeverity() != 4;
    }

    public IStatus validateProperty(String propertyName) {
        DataModelImpl dataModel = this.getOwningDataModel(propertyName);
        IStatus status = dataModel.provider.validate(propertyName);
        return status == null ? IDataModelProvider.OK_STATUS : status;
    }

    public List getExtendedContext() {
        List extendedContext = this.provider.getExtendedContext();
        return extendedContext == null ? Collections.EMPTY_LIST : extendedContext;
    }

    public void dispose() {
        this.provider.dispose();
    }

    public IDataModelOperation getRawOperation() {
        IDataModelOperation providerOp = this.provider.getDefaultOperation();
        if (providerOp == null) {
            providerOp = new AbstractDataModelOperation(this){

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return OK_STATUS;
                }
            };
        }
        return providerOp;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DataModelPausibleOperationImpl(this.getRawOperation());
    }

    public String toString() {
        return "IDataModel, provider=" + this.provider.toString();
    }

    public String getID() {
        String id = this.provider.getID();
        return id != null ? id : "";
    }
}

