/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.model;

import de.rcenvironment.core.communication.common.NetworkGraphNode;
import de.rcenvironment.core.communication.common.WorkflowHostUtils;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Map;

public class NetworkGraphNodeWithContext
implements Comparable<NetworkGraphNodeWithContext>,
ContributedNetworkViewNode {
    private static final int THIS_SMALLER_THAN_OTHER = -1;
    private static final int THIS_GREATER_THAN_OTHER = 1;
    private final NetworkGraphNode node;
    private final Context context;
    private Map<String, String> attachedNodeProperties;
    private ComponentInstallation componentInstallation;
    private String displayText;
    private final NetworkGraphNodeWithContext parent;
    private final NetworkViewContributor contributor;
    private DistributedComponentEntry distributedComponentEntry;

    public NetworkGraphNodeWithContext(NetworkGraphNodeWithContext parent, Context context, NetworkViewContributor contributor) {
        this.parent = parent;
        this.node = parent.node;
        this.attachedNodeProperties = parent.attachedNodeProperties;
        this.context = context;
        this.contributor = contributor;
    }

    public NetworkGraphNodeWithContext(NetworkGraphNode node, Context context, NetworkViewContributor contributor) {
        this.parent = null;
        this.node = node;
        this.context = context;
        this.contributor = contributor;
    }

    public NetworkGraphNodeWithContext getParent() {
        return this.parent;
    }

    public NetworkGraphNode getNode() {
        return this.node;
    }

    public Context getContext() {
        return this.context;
    }

    public Map<String, String> getAttachedNodeProperties() {
        return this.attachedNodeProperties;
    }

    public void setAttachedNodeProperties(Map<String, String> attachedNodeProperties) {
        this.attachedNodeProperties = attachedNodeProperties;
    }

    public ComponentInstallation getComponentInstallation() {
        return this.componentInstallation;
    }

    public void setComponentInstallation(ComponentInstallation componentInstallation) {
        this.componentInstallation = componentInstallation;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    @Override
    public NetworkViewContributor getContributor() {
        return this.contributor;
    }

    public void setDistributedComponentEntry(DistributedComponentEntry entry) {
        this.distributedComponentEntry = entry;
    }

    public DistributedComponentEntry getDistributedComponentEntry() {
        return this.distributedComponentEntry;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkGraphNodeWithContext)) {
            return false;
        }
        NetworkGraphNodeWithContext other = (NetworkGraphNodeWithContext)obj;
        if (!this.node.getNodeId().equals(other.node.getNodeId()) || !this.context.equals((Object)other.context)) {
            return false;
        }
        if (this.context == Context.COMPONENT_INSTALLATION) {
            if (this.componentInstallation == null && other.componentInstallation == null) {
                return this == other;
            }
            if (this.componentInstallation == null || other.componentInstallation == null) {
                return false;
            }
            if (this.componentInstallation.getInstallationId() == null) {
                throw new IllegalStateException("ComponentInstallation has a 'null' id: " + this.componentInstallation.toString());
            }
            if (other.componentInstallation.getInstallationId() == null) {
                throw new IllegalStateException("Other componentInstallation has a 'null' id: " + other.componentInstallation.toString());
            }
            return this.componentInstallation.getInstallationId().equals(other.componentInstallation.getInstallationId());
        }
        if (this.context == Context.RAW_NODE_PROPERTY) {
            return this.displayText.equals(other.displayText);
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.node.getNodeId().hashCode() ^ this.context.hashCode();
        if (this.displayText != null) {
            hashCode ^= this.displayText.hashCode();
        }
        if (this.componentInstallation != null) {
            hashCode ^= this.componentInstallation.getInstallationId().hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(NetworkGraphNodeWithContext other) {
        if (this.context != other.context) {
            throw new IllegalStateException("Unexpected comparison with different contexts");
        }
        switch (this.context) {
            case ROOT: {
                return this.getDisplayNameOfNode().compareTo(other.getDisplayNameOfNode());
            }
            case COMPONENT_INSTALLATION: {
                int otherHashCode;
                if (this.componentInstallation != null && other.componentInstallation != null) {
                    return this.componentInstallation.getComponentInterface().getDisplayName().compareTo(other.componentInstallation.getComponentInterface().getDisplayName());
                }
                if (this.componentInstallation == null && other.componentInstallation != null) {
                    return 1;
                }
                if (this.componentInstallation != null && other.componentInstallation == null) {
                    return -1;
                }
                int thisHashCode = this.getDistributedComponentEntry().hashCode();
                if (thisHashCode < (otherHashCode = other.getDistributedComponentEntry().hashCode())) {
                    return -1;
                }
                if (thisHashCode == otherHashCode) {
                    return 0;
                }
                return 1;
            }
            case RAW_NODE_PROPERTY: {
                return this.displayText.compareTo(other.displayText);
            }
        }
        throw new IllegalStateException("Unexpected comparison for context " + (Object)((Object)this.context));
    }

    public String getDisplayNameOfNode() {
        String propertyValue;
        String displayName = "<unknown>";
        if (this.attachedNodeProperties != null && (propertyValue = this.attachedNodeProperties.get("displayName")) != null) {
            displayName = propertyValue;
        }
        return displayName;
    }

    public boolean isLocalNode() {
        return this.node.isLocalNode();
    }

    public boolean isWorkflowHost() {
        if (this.attachedNodeProperties == null) {
            return false;
        }
        return WorkflowHostUtils.doNodePropertiesIndicateWorkflowHost(this.attachedNodeProperties);
    }

    public String toString() {
        return StringUtils.format((String)"%s [%s]", (Object[])new Object[]{this.getDisplayNameOfNode(), this.context});
    }

    public static enum Context {
        ROOT,
        RAW_NODE_PROPERTIES_FOLDER,
        RAW_NODE_PROPERTY,
        COMPONENT_INSTALLATION,
        RESOURCE_MONITORING_FOLDER;

    }
}

