/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.gui.communication.views.contributors.ConnectionSettings;
import de.rcenvironment.core.gui.communication.views.contributors.CustomPasteHandler;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.utils.incubator.PasteListeningText;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractNetworkConnectionDialog
extends TitleAreaDialog
implements ModifyListener,
VerifyListener,
PasteListeningText.PasteListener {
    protected static final String ERROR_MESSAGE = "One of the connection settings is missing.";
    protected static final String DEFAULT_TITLE = "Network Connection Dialog";
    protected static final String DEFAULT_MESSAGE = "Configure network connection";
    protected static final String CONNECT_ON_STARTUP = "connectOnStartup";
    protected static final String USE_DEFAULT_SETTINGS = "useDefaultSettings";
    protected static final String AUTO_RETRY = "autoRetry";
    protected static final String AUTO_RETRY_INITIAL_DELAY_STR = "autoRetryInitialDelay";
    protected static final String AUTO_RETRY_MAXI_DELAY_STR = "autoRetryMaximumDelay";
    protected static final String AUTO_RETRY_DELAY_MULTIPL = "autoRetryDelayMultiplier";
    protected static final String ACTIVEMQ_PREFIX = "activemq-tcp:";
    protected static final String COM = ",";
    protected static final String DECIMAL = "[^0-9]";
    private static final String INVALID_IP = "0.0.0.0";
    private static final int DIALOG_WINDOW_OFFSET_Y = 100;
    private static final int DIALOG_WINDOW_OFFSET_X = 150;
    private static final String COLON = ":";
    private static final String NAME_LABEL = "Name:";
    private static final String HOST_LABEL = "Host:";
    private static final String PORT_LABEL = "Port:";
    private static final String SETTINGS = "Settings for Auto Reconnect";
    private static final int CHECKBOX_LABEL_WIDTH = 300;
    protected String title;
    protected String connectionName = "";
    protected String networkContactPointID = "";
    protected String hint = "";
    protected String host = "";
    protected String port = "";
    protected String errorMessage;
    protected ConnectionSettings connectionSettings = new ConnectionSettings();
    private NetworkContactPoint parsedNetworkContactPoint;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Text portTextField;
    private PasteListeningText hostTextField;
    private Button useDefaultNameButton;
    private Button useDefaultSettings;
    private Text nameText;
    private Text initialDelayTextField;
    private Text maximumDelayTextField;
    private Text delayMultiplierTextField;
    private boolean isDefaultName = true;
    private Composite container;

    protected AbstractNetworkConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected AbstractNetworkConnectionDialog(Shell parentShell, String connectionName, String connectionString) {
        super(parentShell);
        this.connectionName = connectionName;
        this.networkContactPointID = connectionString;
        this.host = this.networkContactPointID.substring(0, this.networkContactPointID.indexOf(COLON));
        this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (shell.getHorizontalBar() != null) {
            shell.getHorizontalBar().dispose();
        }
        shell.setLocation(shell.getParent().getLocation().x + shell.getParent().getSize().x / 2 - 150, shell.getParent().getLocation().y + shell.getParent().getSize().y / 2 - 100);
        shell.setText("Connection");
    }

    public void create() {
        super.create();
        this.updateAutoRetrySettings();
        this.setTitle(DEFAULT_TITLE);
        if (this.errorMessage != null) {
            this.setMessage(this.errorMessage, 3);
        } else {
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData containerGridData = new GridData(4, 4, true, false);
        this.container.setLayoutData((Object)containerGridData);
        this.container.setLayout((Layout)layout);
        GridData checkboxGridData = new GridData();
        checkboxGridData.widthHint = 300;
        checkboxGridData.horizontalSpan = 2;
        Label cpLabel = new Label(this.container, 0);
        cpLabel.setText(HOST_LABEL);
        this.hostTextField = new PasteListeningText(this.container, 2052);
        this.hostTextField.setLayoutData((Object)new GridData(256));
        if (!this.host.isEmpty()) {
            this.hostTextField.setText(this.host);
        }
        this.hostTextField.addPasteListener((PasteListeningText.PasteListener)this);
        this.hostTextField.addModifyListener((ModifyListener)this);
        Label cpLabelPort = new Label(this.container, 0);
        cpLabelPort.setText(PORT_LABEL);
        this.portTextField = new Text(this.container, 2052);
        this.portTextField.setLayoutData((Object)new GridData(256));
        if (!this.port.isEmpty()) {
            this.portTextField.setText(this.port);
        }
        this.portTextField.addVerifyListener((VerifyListener)this);
        this.portTextField.addModifyListener((ModifyListener)this);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalSpan = 2;
        Label nameLabel = new Label(this.container, 0);
        nameLabel.setText(NAME_LABEL);
        this.nameText = new Text(this.container, 2052);
        this.nameText.setLayoutData((Object)new GridData(256));
        this.nameText.setText(this.connectionName);
        this.nameText.setEnabled(!this.isDefaultName);
        Label placeholderLabel = new Label(this.container, 0);
        placeholderLabel.setText("");
        GridData useDefaultCheckboxGridData = new GridData();
        useDefaultCheckboxGridData.widthHint = 300;
        useDefaultCheckboxGridData.horizontalSpan = 1;
        this.useDefaultNameButton = new Button(this.container, 32);
        this.useDefaultNameButton.setText("Use default name (host:port)");
        this.useDefaultNameButton.setLayoutData((Object)useDefaultCheckboxGridData);
        this.useDefaultNameButton.setSelection(this.isDefaultName);
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNetworkConnectionDialog.this.nameText.setEnabled(!AbstractNetworkConnectionDialog.this.useDefaultNameButton.getSelection());
                AbstractNetworkConnectionDialog.this.nameText.setText("");
                if (AbstractNetworkConnectionDialog.this.useDefaultNameButton.getSelection() && !AbstractNetworkConnectionDialog.this.hostTextField.getText().isEmpty() && !AbstractNetworkConnectionDialog.this.portTextField.getText().isEmpty()) {
                    AbstractNetworkConnectionDialog.this.nameText.setText(String.valueOf(AbstractNetworkConnectionDialog.this.hostTextField.getText()) + AbstractNetworkConnectionDialog.COLON + AbstractNetworkConnectionDialog.this.portTextField.getText());
                }
                AbstractNetworkConnectionDialog.this.updateOkButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Label separator1 = new Label(this.container, 258);
        separator1.setLayoutData((Object)separatorGridData);
        final Button autoRetryButton = new Button(this.container, 32);
        autoRetryButton.setSelection(this.connectionSettings.isAutoRetry());
        autoRetryButton.setText("Try reconnect after error");
        autoRetryButton.setLayoutData((Object)checkboxGridData);
        autoRetryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractNetworkConnectionDialog.this.connectionSettings.setAutoRetry(autoRetryButton.getSelection());
                AbstractNetworkConnectionDialog.this.setTextFieldActivation();
                AbstractNetworkConnectionDialog.this.useDefaultSettings.setEnabled(AbstractNetworkConnectionDialog.this.connectionSettings.isAutoRetry());
                AbstractNetworkConnectionDialog.this.updateOkButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.buildSettingsField();
        Label separator2 = new Label(this.container, 258);
        separator2.setLayoutData((Object)separatorGridData);
        final Button immediateConnectButton = new Button(this.container, 32);
        immediateConnectButton.setSelection(this.connectionSettings.isConnectOnStartup());
        immediateConnectButton.setText("Connect immediately");
        immediateConnectButton.setLayoutData((Object)checkboxGridData);
        Label persistHint = new Label(this.container, 0);
        GridData hintGridData = new GridData();
        hintGridData.horizontalSpan = 2;
        persistHint.setText(this.hint);
        persistHint.setLayoutData((Object)hintGridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNetworkConnectionDialog.this.connectionName = AbstractNetworkConnectionDialog.this.nameText.getText();
            }
        });
        immediateConnectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractNetworkConnectionDialog.this.connectionSettings.setConnectOnStartup(immediateConnectButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        return this.container;
    }

    public void modifyText(ModifyEvent e) {
        this.host = this.hostTextField.getText();
        this.port = this.portTextField.getText();
        if (this.useDefaultNameButton.getSelection()) {
            if (!this.hostTextField.getText().isEmpty() && !this.portTextField.getText().isEmpty()) {
                this.nameText.setText(String.valueOf(this.hostTextField.getText()) + COLON + this.portTextField.getText());
            } else {
                this.nameText.setText("");
            }
        }
        this.updateOkButtonActivation();
    }

    public void paste(String text) {
        CustomPasteHandler.paste(text, (Text)this.hostTextField, this.portTextField);
    }

    public void verifyText(VerifyEvent e) {
        String currentText = ((Text)e.widget).getText();
        String portID = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
        e.doit = CustomPasteHandler.isValidPort(portID);
    }

    private void buildSettingsField() {
        Group settingsGroup = new Group(this.container, 0);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData settingsData = new GridData(1808);
        settingsData.horizontalSpan = 2;
        settingsGroup.setLayoutData((Object)settingsData);
        settingsGroup.setText(SETTINGS);
        this.useDefaultSettings = new Button((Composite)settingsGroup, 32);
        this.useDefaultSettings.setSelection(this.connectionSettings.isUseDefaultSettings());
        this.useDefaultSettings.setText("Use default settings");
        this.useDefaultSettings.setLayoutData((Object)settingsData);
        this.useDefaultSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNetworkConnectionDialog.this.connectionSettings.setUseDefaultSettings(AbstractNetworkConnectionDialog.this.useDefaultSettings.getSelection());
                AbstractNetworkConnectionDialog.this.setTextFieldActivation();
                if (AbstractNetworkConnectionDialog.this.useDefaultSettings.getSelection()) {
                    AbstractNetworkConnectionDialog.this.connectionSettings.setDefaultValues();
                    AbstractNetworkConnectionDialog.this.updateAutoRetrySettings();
                }
            }
        });
        Label initialDelay = new Label((Composite)settingsGroup, 0);
        initialDelay.setText("Initial Delay (sec):");
        this.initialDelayTextField = new Text((Composite)settingsGroup, 2052);
        this.initialDelayTextField.setLayoutData((Object)new GridData(768));
        this.initialDelayTextField.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(18));
        this.initialDelayTextField.addModifyListener(evt -> this.updateOkButtonActivation());
        Label maximumDelay = new Label((Composite)settingsGroup, 0);
        maximumDelay.setText("Maximum Delay (sec):");
        this.maximumDelayTextField = new Text((Composite)settingsGroup, 2052);
        this.maximumDelayTextField.setLayoutData((Object)new GridData(768));
        this.maximumDelayTextField.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(18));
        this.maximumDelayTextField.addModifyListener(evt -> this.updateOkButtonActivation());
        Label delayMultiplier = new Label((Composite)settingsGroup, 0);
        delayMultiplier.setText("Delay Multiplier (>=1.0):");
        this.delayMultiplierTextField = new Text((Composite)settingsGroup, 2052);
        this.delayMultiplierTextField.setLayoutData((Object)new GridData(768));
        this.delayMultiplierTextField.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(41));
        this.delayMultiplierTextField.addModifyListener(evt -> this.updateOkButtonActivation());
        this.updateUseDefaultCheckboxActivation();
        this.setTextFieldActivation();
    }

    protected void updateAutoRetrySettings() {
        this.initialDelayTextField.setText(String.valueOf(this.connectionSettings.getAutoRetryInitialDelay()));
        this.maximumDelayTextField.setText(String.valueOf(this.connectionSettings.getAutoRetryMaximumDelay()));
        this.delayMultiplierTextField.setText(String.valueOf(this.connectionSettings.getAutoRetryDelayMultiplier()));
    }

    private void setTextFieldActivation() {
        this.initialDelayTextField.setEnabled(!this.connectionSettings.isUseDefaultSettings() && this.connectionSettings.isAutoRetry());
        this.maximumDelayTextField.setEnabled(!this.connectionSettings.isUseDefaultSettings() && this.connectionSettings.isAutoRetry());
        this.delayMultiplierTextField.setEnabled(!this.connectionSettings.isUseDefaultSettings() && this.connectionSettings.isAutoRetry());
    }

    private void updateUseDefaultCheckboxActivation() {
        boolean useDefault = this.connectionSettings.getAutoRetryInitialDelay() == 5L && this.connectionSettings.getAutoRetryMaximumDelay() == 300L && this.connectionSettings.getAutoRetryDelayMultiplier() == 1.5;
        this.useDefaultSettings.setSelection(useDefault);
        this.connectionSettings.setUseDefaultSettings(useDefault);
        this.useDefaultSettings.setEnabled(this.connectionSettings.isAutoRetry());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(!this.networkContactPointID.isEmpty());
    }

    protected void okPressed() {
        boolean canParse = true;
        if (this.getNetworkContactPointID().contains(INVALID_IP)) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid host address", (String)"The IP address 0.0.0.0 configured for the network connection is invalid. For a local connection please use 127.0.0.1 or 'localhost' instead.");
            return;
        }
        this.catchSettingsFields();
        try {
            String hostAndPortString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{this.host, this.port});
            String temp = String.valueOf(hostAndPortString) + "(" + this.connectionSettings.getSettingsString() + COM + CONNECT_ON_STARTUP + " = " + this.connectionSettings.isConnectOnStartup() + COM + USE_DEFAULT_SETTINGS + " = " + this.connectionSettings.isUseDefaultSettings() + COM + AUTO_RETRY + " = " + this.connectionSettings.isAutoRetry() + ")";
            String contactPoint = this.removeEmptySpaces(temp);
            if (!contactPoint.startsWith(ACTIVEMQ_PREFIX)) {
                contactPoint = ACTIVEMQ_PREFIX + contactPoint;
            }
            this.parsedNetworkContactPoint = NetworkContactPointUtils.parseStringRepresentation((String)contactPoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            canParse = false;
        }
        if (canParse) {
            super.okPressed();
        } else {
            String error = StringUtils.format((String)"'%s' is invalid for the host. It must be of format e.g. 192.168.0.15", (Object[])new Object[]{this.host});
            this.log.debug((Object)error);
            MessageDialog.openError((Shell)this.getParentShell(), (String)"Invalid format", (String)error);
        }
    }

    private void catchSettingsFields() {
        try {
            this.connectionSettings.setAutoRetryInitialDelay(Long.parseLong(this.initialDelayTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.connectionSettings.setAutoRetryMaximumDelay(Long.parseLong(this.maximumDelayTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            this.connectionSettings.setAutoRetryDelayMultiplier(Double.parseDouble(this.delayMultiplierTextField.getText()));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private String removeEmptySpaces(String string) {
        return string.replaceAll("\\s", "");
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        parent.getShell().pack();
        return buttonBar;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(67936);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public NetworkContactPoint getParsedNetworkContactPoint() {
        return this.parsedNetworkContactPoint;
    }

    public String getNetworkContactPointID() {
        return this.networkContactPointID;
    }

    public boolean getConnectImmediately() {
        return this.connectionSettings.isConnectOnStartup();
    }

    protected void activateDefaultName() {
        this.isDefaultName = true;
    }

    protected void deactivateDefaultName() {
        this.isDefaultName = false;
    }

    private void updateOkButtonActivation() {
        boolean enabled;
        boolean bl = enabled = !this.host.isEmpty() && !this.port.isEmpty();
        if (enabled && this.connectionSettings.isAutoRetry() && !this.connectionSettings.isUseDefaultSettings()) {
            enabled = !this.initialDelayTextField.getText().isEmpty() && !this.maximumDelayTextField.getText().isEmpty() && !this.delayMultiplierTextField.getText().isEmpty();
        }
        this.getButton(0).setEnabled(enabled);
        if (enabled) {
            this.setMessage(DEFAULT_MESSAGE);
        } else {
            this.setMessage(ERROR_MESSAGE, 3);
        }
    }
}

