/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.wrapper.sandboxed;

import de.rcenvironment.core.component.datamanagement.stateful.StatefulComponentDataManagementService;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.wrapper.MonitoringEventListener;
import de.rcenvironment.core.component.wrapper.WrapperBase;
import de.rcenvironment.core.component.wrapper.sandboxed.ExecutionEnvironment;
import de.rcenvironment.core.component.wrapper.sandboxed.SandboxBehaviour;
import de.rcenvironment.core.component.wrapper.sandboxed.WrapperConfigurationFactory;
import de.rcenvironment.core.utils.common.validation.ValidationFailureException;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import java.io.IOException;

public abstract class SandboxedWrapperBase<C, R>
extends WrapperBase<C, R> {
    private ExecutionEnvironment executionEnvironment;
    private SandboxBehaviour sandboxStrategy;
    private String workDirPath;
    private WrapperConfigurationFactory configurationFactory;

    public SandboxedWrapperBase(WrapperConfigurationFactory configurationFactory, StatefulComponentDataManagementService fileReferenceHandler, MonitoringEventListener listener, ComponentContext compContext) {
        super(fileReferenceHandler, listener, compContext);
        this.configurationFactory = configurationFactory;
    }

    @Override
    public void setupStaticEnvironment() throws IOException, ValidationFailureException {
        this.executionEnvironment = this.configurationFactory.createExecutionEnvironment();
        this.sandboxStrategy = this.configurationFactory.createSandboxBehaviour(this.executionEnvironment);
        this.executionEnvironment.setupStaticEnvironment();
    }

    @Override
    public final R execute(C runConfiguration) throws IOException, ValidationFailureException {
        CommandLineExecutor executor = this.setupRunEnvironment(runConfiguration);
        try {
            R r = this.executeInRunEnvironment(runConfiguration, executor);
            return r;
        }
        finally {
            this.tearDownRunEnvironment(runConfiguration, executor);
        }
    }

    @Override
    public void tearDownStaticEnvironment() throws IOException {
        this.sandboxStrategy.beforeTearDownStaticEnvironment();
        this.executionEnvironment.tearDownStaticEnvironment();
    }

    protected CommandLineExecutor setupRunEnvironment(C runConfiguration) throws IOException, ValidationFailureException {
        CommandLineExecutor executor = this.sandboxStrategy.setupSingleRun();
        this.workDirPath = executor.getWorkDirPath();
        return executor;
    }

    protected abstract R executeInRunEnvironment(C var1, CommandLineExecutor var2);

    protected void tearDownRunEnvironment(C runConfiguration, CommandLineExecutor executor) throws IOException, ValidationFailureException {
        this.sandboxStrategy.afterSingleRun(executor);
    }

    protected String getWorkDirPath() {
        return this.workDirPath;
    }
}

