/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.ConsoleRowLogService;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleRowFormatter;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsoleRowLogServiceImpl
implements ConsoleRowLogService {
    private static final int BUFFERED_CHARACTER_COUNT_WARNING_THRESHOLD = 0x200000;
    private static final String SYSTEM_PROPERTY_FOR_ACTIVATION = "rce.internal.writeCombinedConsoleLogs";
    private LinkedBlockingQueue<ConsoleRow> outputQueue;
    private Writer fileWriter;
    private AtomicInteger bufferedCharacterCount = new AtomicInteger();
    private volatile BackgroundLogWriterTask backgroundWriterTask;
    private volatile Future<?> backgroundTaskFuture;
    private ConfigurationService configurationService;
    private File logFile;
    private boolean enabled = false;
    private final Log log = LogFactory.getLog(this.getClass());

    public ConsoleRowLogServiceImpl() throws IOException {
        this.outputQueue = new LinkedBlockingQueue();
    }

    public void activate() {
        boolean bl = this.enabled = System.getProperty(SYSTEM_PROPERTY_FOR_ACTIVATION) != null;
        if (!this.enabled) {
            this.log.debug((Object)"Combined workflow console log is disabled");
            return;
        }
        String logFileName = StringUtils.format((String)"console.combined.%d.log", (Object[])new Object[]{System.currentTimeMillis()});
        File outputDir = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
        this.logFile = new File(outputDir, logFileName);
        try {
            this.fileWriter = new BufferedWriter(new FileWriter(this.logFile));
            this.backgroundWriterTask = new BackgroundLogWriterTask(this.fileWriter, 1);
            this.backgroundTaskFuture = ConcurrencyUtils.getAsyncTaskService().submit((Runnable)this.backgroundWriterTask, "Common ConsoleRow log " + this.logFile.getAbsolutePath());
            this.log.debug((Object)("Logging combined workflow console output to " + logFileName + " (NOTE: may not capture all output yet)"));
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to set up background console logging to " + logFileName), (Throwable)e);
        }
    }

    public void deactivate() {
        if (!this.enabled) {
            return;
        }
        if (this.backgroundTaskFuture != null) {
            this.backgroundTaskFuture.cancel(true);
        }
    }

    public void append(ConsoleRow row) {
        this.modifyCharacterCount(row.getPayload().length());
        this.outputQueue.add(row);
    }

    private void modifyCharacterCount(int delta) {
        int newTotal = this.bufferedCharacterCount.addAndGet(delta);
        if (delta > 0) {
            if (newTotal >= 0x200000) {
                this.log.warn((Object)StringUtils.format((String)"Background log buffer has grown to %d characters", (Object[])new Object[]{newTotal}));
            }
        } else if (newTotal < 0) {
            this.log.error((Object)"Integrity violation: buffer count decremented below zero");
        }
    }

    @Override
    public void processConsoleRows(List<ConsoleRow> rows) {
        if (!this.enabled) {
            return;
        }
        int charCount = 0;
        for (ConsoleRow row : rows) {
            charCount += row.getPayload().length();
        }
        this.modifyCharacterCount(charCount);
        this.outputQueue.addAll(rows);
    }

    public void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    private final class BackgroundLogWriterTask
    implements Runnable {
        private final int threadPriority;
        private final Writer writer;
        private boolean anythingLogged;

        private BackgroundLogWriterTask(Writer writer, int threadPriority) {
            this.writer = writer;
            this.threadPriority = threadPriority;
        }

        @Override
        @TaskDescription(value="Background log writing")
        public void run() {
            Thread currentThread = Thread.currentThread();
            int originalPriority = currentThread.getPriority();
            currentThread.setPriority(this.threadPriority);
            try {
                this.runLogging();
            }
            finally {
                currentThread.setPriority(originalPriority);
            }
        }

        private void runLogging() {
            Thread currentThread = Thread.currentThread();
            ConsoleRowFormatter consoleRowFormatter = new ConsoleRowFormatter();
            this.anythingLogged = false;
            try {
                while (!currentThread.isInterrupted()) {
                    ConsoleRow row = ConsoleRowLogServiceImpl.this.outputQueue.take();
                    ConsoleRowLogServiceImpl.this.modifyCharacterCount(-row.getPayload().length());
                    try {
                        this.writer.append(consoleRowFormatter.toCombinedLogFileFormat(row));
                        this.anythingLogged = true;
                    }
                    catch (IOException e) {
                        ConsoleRowLogServiceImpl.this.log.error((Object)e);
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                ConsoleRowLogServiceImpl.this.log.debug((Object)"Background log writer interrupted");
            }
            try {
                this.writer.close();
                if (!this.anythingLogged) {
                    ConsoleRowLogServiceImpl.this.logFile.delete();
                }
            }
            catch (IOException e) {
                ConsoleRowLogServiceImpl.this.log.error((Object)e);
            }
        }
    }
}

