/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WorkflowExecutionUtils {
    public static final String DEFAULT_ERROR_MESSAGE_TEMPLATE_CANNOT_READ_PLACEHOLDER_FILE = "Placeholder file %s does not exist or it can not be read";
    public static final String DEFAULT_ERROR_MESSAGE_TEMPLATE_CANNOT_READ_WORKFLOW_FILE = "Workflow file %s does not exist or it can not be read";
    private static final int WORKFLOW_SUFFIX_NUMBER_MODULO = 100;
    private static final int PATTERN_DATETIME_LENGTH = 19;
    private static final String PATTERN_DATETIME_STRING = "\\d{4}\\-[01]{1}\\d{1}\\-[0123]{1}\\d{1}\\_[012]{1}\\d\\:[0123456]{1}\\d{1}\\:[0123456]{1}\\d{1}";
    private static final int PATTERN_NUMBER_LENGTH = 3;
    private static final String PATTERN_NUMBER_STRING = "^\\_\\d{2}";
    private static final AtomicInteger GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER = new AtomicInteger();

    private WorkflowExecutionUtils() {
    }

    public static String generateDefaultNameforExecutingWorkflow(String filename, WorkflowDescription workflowDescription) {
        String wfDescriptionName = workflowDescription.getName();
        if (wfDescriptionName == null) {
            return WorkflowExecutionUtils.generateWorkflowName(filename);
        }
        Pattern pattern = Pattern.compile(PATTERN_DATETIME_STRING);
        Matcher matcher = pattern.matcher(wfDescriptionName);
        if (!matcher.find()) {
            return wfDescriptionName;
        }
        int position = matcher.start();
        String dateAndTime = wfDescriptionName.substring(position, position + 19);
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
            dateFormat.setLenient(false);
            dateFormat.parse(dateAndTime);
        }
        catch (ParseException parseException) {
            return wfDescriptionName;
        }
        String newName = String.valueOf(wfDescriptionName.substring(0, position)) + WorkflowExecutionUtils.generateTimestampString();
        String rest = wfDescriptionName.substring(position + 19);
        pattern = Pattern.compile(PATTERN_NUMBER_STRING);
        matcher = pattern.matcher(rest);
        if (matcher.find()) {
            newName = StringUtils.format((String)"%s_%02d", (Object[])new Object[]{newName, WorkflowExecutionUtils.generateNewSuffixNumber()});
            newName = String.valueOf(newName) + rest.substring(3);
        } else {
            newName = String.valueOf(newName) + rest;
        }
        return newName;
    }

    private static String generateWorkflowName(String filename) {
        String storedWorkflowName = filename;
        if (storedWorkflowName.toLowerCase().endsWith(".wf")) {
            storedWorkflowName = storedWorkflowName.substring(0, storedWorkflowName.length() - 3);
        }
        return StringUtils.format((String)"%s_%s_%02d", (Object[])new Object[]{storedWorkflowName, WorkflowExecutionUtils.generateTimestampString(), WorkflowExecutionUtils.generateNewSuffixNumber()});
    }

    private static int generateNewSuffixNumber() {
        return GLOBAL_WORKFLOW_SUFFIX_SEQUENCE_COUNTER.incrementAndGet() % 100;
    }

    public static File resolveWorkflowOrPlaceholderFileLocation(String filename, String errorString) throws FileNotFoundException {
        File file = new File(filename).getAbsoluteFile();
        if (!file.isFile() || !file.canRead()) {
            throw new FileNotFoundException(StringUtils.format((String)errorString, (Object[])new Object[]{StringUtils.format((String)"\"%s\" (resolved to \"%s\")", (Object[])new Object[]{filename, file.getAbsolutePath()})}));
        }
        return file;
    }

    private static String generateTimestampString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        return dateFormat.format(new Date());
    }

    public static void replaceNullNodeIdentifiersWithActualNodeIdentifier(WorkflowDescription wfDescription, LogicalNodeId localNodeId, DistributedComponentKnowledge compKnowledge) throws WorkflowExecutionException {
        for (WorkflowNode node : wfDescription.getWorkflowNodes()) {
            if (node.getComponentDescription().getNode() != null) continue;
            Collection installations = compKnowledge.getAllLocalInstallations();
            String componentIdentifier = node.getComponentDescription().getIdentifier();
            ComponentInstallation installation = ComponentUtils.getExactMatchingComponentInstallationForNode((String)componentIdentifier, (Collection)installations, (LogicalNodeId)localNodeId);
            if (installation == null) {
                throw new WorkflowExecutionException(StringUtils.format((String)"Component '%s' (%s) not installed on node %s ", (Object[])new Object[]{node.getName(), componentIdentifier, node.getComponentDescription().getNode()}));
            }
            node.getComponentDescription().setComponentInstallationAndUpdateConfiguration(installation);
            node.getComponentDescription().setIsNodeIdTransient(true);
        }
        if (wfDescription.getControllerNode() == null) {
            wfDescription.setControllerNode(localNodeId);
            wfDescription.setIsControllerNodeIdTransient(true);
        }
    }

    public static void setNodeIdentifiersToTransientInCaseOfLocalOnes(WorkflowDescription wfDescription, LogicalNodeId localNodeId) {
        for (WorkflowNode node : wfDescription.getWorkflowNodes()) {
            node.getComponentDescription().setIsNodeIdTransient(node.getComponentDescription().getNode() == null || node.getComponentDescription().getNode().equals(localNodeId));
        }
        wfDescription.setIsControllerNodeIdTransient(wfDescription.getControllerNode() == null || wfDescription.getControllerNode().equals(localNodeId));
    }

    public static WorkflowDescription removeDisabledWorkflowNodesWithoutNotify(WorkflowDescription workflowDescription) {
        List<WorkflowNode> disabledWorkflowNodes = WorkflowExecutionUtils.getDisabledWorkflowNodes(workflowDescription);
        if (!disabledWorkflowNodes.isEmpty()) {
            workflowDescription.removeWorkflowNodesAndRelatedConnectionsWithoutNotify(disabledWorkflowNodes);
        }
        return workflowDescription;
    }

    public static List<WorkflowNode> getDisabledWorkflowNodes(WorkflowDescription workflowDescription) {
        ArrayList<WorkflowNode> nodes = new ArrayList<WorkflowNode>();
        for (WorkflowNode node : workflowDescription.getWorkflowNodes()) {
            if (node.isEnabled()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static boolean hasMissingWorkflowNode(List<WorkflowNode> wfNodes) {
        for (WorkflowNode wfNode : wfNodes) {
            if (!wfNode.getComponentDescription().getIdentifier().startsWith("20ca0171b5e24e10a284af7c1d6d94e9missing_")) continue;
            return true;
        }
        return false;
    }

    public static String substituteWorkflowNameAndExeId(WorkflowExecutionContext wfExeCtx) {
        return StringUtils.format((String)"workflow '%s' (%s)", (Object[])new Object[]{wfExeCtx.getInstanceName(), wfExeCtx.getExecutionIdentifier()});
    }
}

