/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.internal.OsgiServiceRegistryAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccessFactory;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class OsgiServiceRegistryAccessFactory
implements ServiceRegistryAccessFactory {
    private final BundleContext fallbackBundleContext;
    private final Log log = LogFactory.getLog(this.getClass());

    public OsgiServiceRegistryAccessFactory(BundleContext fallbackBundleContext) {
        this.fallbackBundleContext = fallbackBundleContext;
    }

    public ServiceRegistryAccess createAccessFor(Object caller) {
        return this.createPublisherAccessFor(caller);
    }

    public ServiceRegistryPublisherAccess createPublisherAccessFor(Object caller) {
        if (caller.getClass() == Class.class) {
            throw new IllegalArgumentException("This argument for this method should not be the *class* of the caller (e.g. \"this.getClass()\"), but an arbitrary class *instance* from the caller's bundle (e.g. \"this\")");
        }
        Bundle callerBundle = FrameworkUtil.getBundle(caller.getClass());
        if (callerBundle != null) {
            BundleContext bundleContext = callerBundle.getBundleContext();
            if (bundleContext != null) {
                return new OsgiServiceRegistryAccess(bundleContext);
            }
            this.log.warn((Object)("Unexpected state: Bundle " + callerBundle.getSymbolicName() + " returned a null BundleContext (using fallback); bundle state: " + callerBundle.getState()));
        } else {
            this.log.warn((Object)("Using fallback BundleContext as the containing bundle could not be identified for " + caller.getClass()));
        }
        return new OsgiServiceRegistryAccess(this.fallbackBundleContext);
    }
}

