/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import de.rcenvironment.core.configuration.ConfigurationSegment;

class GeneralSettings {
    private String instanceName;
    private boolean isWorkflowHost;
    private boolean isRelay;
    private double[] location;
    private String locationName;
    private String contact;
    private String additionalInformation;
    private String tempDirectoryOverride;

    GeneralSettings(ConfigurationSegment configurationSegment) {
        this.instanceName = configurationSegment.getString("instanceName", "Unnamed instance started by \"${systemUser}\" on ${hostName}");
        this.isWorkflowHost = configurationSegment.getBoolean("isWorkflowHost", false);
        this.isRelay = configurationSegment.getBoolean("isRelay", false);
        this.tempDirectoryOverride = configurationSegment.getString("tempDirectory");
        this.location = new double[]{configurationSegment.getSubSegment("coordinates").getDouble("lat", 0.0), configurationSegment.getSubSegment("coordinates").getDouble("long", 0.0)};
        this.locationName = configurationSegment.getString("locationName", "");
        this.contact = configurationSegment.getString("contact", "");
        this.additionalInformation = configurationSegment.getString("information", "");
    }

    public String getRawInstanceName() {
        return this.instanceName;
    }

    public boolean getIsWorkflowHost() {
        return this.isWorkflowHost;
    }

    public boolean getIsRelay() {
        return this.isRelay;
    }

    public String getTempDirectoryOverride() {
        return this.tempDirectoryOverride;
    }

    public double[] getLocation() {
        return this.location;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public String getContact() {
        return this.contact;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }
}

