/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view;

import de.rcenvironment.core.gui.integration.common.ShowDeactivateIntegrationHandler;
import de.rcenvironment.core.gui.integration.toolintegration.ShowIntegrationWizardHandler;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.PaletteToolbarFilterWidget;
import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.dialogs.AddCustomGroupDialog;
import de.rcenvironment.core.gui.palette.view.dialogs.ComponentInformationDialog;
import de.rcenvironment.core.gui.palette.view.dialogs.EditCustomGroupDialog;
import de.rcenvironment.core.gui.palette.view.dialogs.ManageCustomGroupsAction;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.AccessibleComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.ComponentNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.documentation.ToolIntegrationDocumentationGUIHelper;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PaletteViewActions {
    private final PaletteView paletteView;
    private final PaletteViewContentProvider contentProvider;
    private final Log log = LogFactory.getLog(this.getClass());
    private MenuManager subMenuManager;
    private Action organizeGroups;
    private Action sortAscending;
    private Action sortDescending;
    private Action collapseAll;
    private Action expandAll;
    private Action resetGroup;
    private Action integrateTool;
    private Action editToolIntegration;
    private Action editWorkflowIntegration;
    private Action deactivateIntegration;
    private Action deleteEmptyGroup;
    private MenuManager paletteViewMenuManager;
    private Action showEmptyGroups;
    private Action openComponentDocumentation;
    private Action exportComponentDocumentation;
    private Action editGroup;
    private Action addSubGroup;
    private Action addGroup;
    private Action showComponentInformation;

    public PaletteViewActions(PaletteView paletteView) {
        this.paletteView = paletteView;
        this.contentProvider = paletteView.getContentProvider();
        this.subMenuManager = new MenuManager("Move to Group...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_MOVE), "de.rcenvironment.palette.submenu");
    }

    protected void updateContextMenu(TreeItem[] treeItems) {
        PaletteTreeNode[] nodes = this.getPaletteTreeNodesFromTreeItems(treeItems);
        this.updateContextMenuActivation(nodes);
        this.updateContextMenuItems(nodes);
    }

    private void updateContextMenuItems(PaletteTreeNode[] nodes) {
        this.paletteViewMenuManager.removeAll();
        this.subMenuManager.removeAll();
        if (Arrays.stream(nodes).allMatch(PaletteTreeNode::isAccessibleComponent)) {
            this.updateSubMenuItems(nodes);
        }
        this.addActions((IMenuManager)this.paletteViewMenuManager);
    }

    private void updateSubMenuItems(PaletteTreeNode[] nodes) {
        AccessibleComponentNode[] toolNodes = (AccessibleComponentNode[])Arrays.stream(nodes).filter(AccessibleComponentNode.class::isInstance).map(AccessibleComponentNode.class::cast).toArray(AccessibleComponentNode[]::new);
        PaletteTreeNode[] groups = this.contentProvider.getSuitableGroups(toolNodes, true);
        Arrays.stream(groups).filter(GroupNode.class::isInstance).map(GroupNode.class::cast).forEach(group -> this.subMenuManager.add((IAction)new MoveToGroupAction(toolNodes, (GroupNode)group)));
    }

    private void updateContextMenuActivation(PaletteTreeNode[] nodes) {
        boolean singleSelection = nodes.length == 1;
        this.resetGroup.setEnabled(false);
        this.editToolIntegration.setEnabled(singleSelection && nodes[0].canHandleEditEvent() && this.isIntegratedTool(nodes[0]));
        this.openComponentDocumentation.setEnabled(singleSelection && (this.isIntegratedTool(nodes[0]) || this.isIntegratedWorkflow(nodes[0])));
        this.exportComponentDocumentation.setEnabled(singleSelection && (this.isIntegratedTool(nodes[0]) || this.isIntegratedWorkflow(nodes[0])));
        this.editWorkflowIntegration.setEnabled(singleSelection && nodes[0].canHandleEditEvent() && this.isIntegratedWorkflow(nodes[0]));
        this.deleteEmptyGroup.setEnabled(singleSelection && this.isCustomGroup(nodes[0]) && !this.contentProvider.containsAnyToolNodes(nodes[0], true));
        if (this.deleteEmptyGroup.isEnabled()) {
            if (nodes[0].getAllSubGroups().isEmpty()) {
                this.deleteEmptyGroup.setText("Delete Group");
            } else {
                this.deleteEmptyGroup.setText("Delete Group and Subgroups");
            }
        }
        this.editGroup.setEnabled(singleSelection && this.isCustomGroup(nodes[0]));
        this.addSubGroup.setEnabled(singleSelection && nodes[0].isGroup() && !this.isStandardComponentsTopLevelGroup(nodes[0]));
        this.showComponentInformation.setEnabled(singleSelection && nodes[0].isAccessibleComponent());
        if (Arrays.stream(nodes).allMatch(PaletteTreeNode::isAccessibleComponent)) {
            this.updateActivationForCustomizedTools(nodes);
        }
    }

    private boolean isCustomGroup(PaletteTreeNode node) {
        return node.isGroup() && node.getGroupNode().isCustomGroup();
    }

    private boolean isStandardComponentsTopLevelGroup(PaletteTreeNode node) {
        if (node.getPaletteParent().isRoot()) {
            return node.getNodeName().equals(ToolType.STANDARD_COMPONENT.getTopLevelGroupName());
        }
        return this.isStandardComponentsTopLevelGroup(node.getPaletteParent());
    }

    private boolean isIntegratedTool(PaletteTreeNode paletteTreeNode) {
        if (paletteTreeNode.isAccessibleComponent()) {
            return paletteTreeNode.getAccessibleComponentNode().getType().equals((Object)ToolType.INTEGRATED_TOOL);
        }
        return false;
    }

    private boolean isIntegratedWorkflow(PaletteTreeNode paletteTreeNode) {
        if (paletteTreeNode.isAccessibleComponent()) {
            return paletteTreeNode.getAccessibleComponentNode().getType().equals((Object)ToolType.INTEGRATED_WORKFLOW);
        }
        return false;
    }

    private void updateActivationForCustomizedTools(PaletteTreeNode[] nodes) {
        Set nodeNames = Arrays.stream(nodes).map(PaletteTreeNode::getNodeName).collect(Collectors.toSet());
        Set<ToolIdentification> customizedGroups = this.contentProvider.getAssignment().getCustomizedAssignments().keySet();
        if (customizedGroups.stream().anyMatch(item -> nodeNames.contains(item.getToolName()))) {
            this.resetGroup.setEnabled(true);
        }
    }

    protected void hookContextMenu() {
        this.paletteViewMenuManager = new MenuManager();
        TreeViewer paletteTreeViewer = this.paletteView.getPaletteTreeViewer();
        Menu paletteTreeMenu = this.paletteViewMenuManager.createContextMenu(paletteTreeViewer.getControl());
        paletteTreeViewer.getControl().setMenu(paletteTreeMenu);
        this.paletteView.getSite().registerContextMenu(this.paletteViewMenuManager, (ISelectionProvider)paletteTreeViewer);
    }

    private void addActions(IMenuManager menuManager) {
        if (Arrays.stream(this.subMenuManager.getItems()).anyMatch(IContributionItem::isEnabled)) {
            menuManager.add((IContributionItem)this.subMenuManager);
        }
        if (this.resetGroup.isEnabled()) {
            menuManager.add((IAction)this.resetGroup);
        }
        if (this.addSubGroup.isEnabled()) {
            menuManager.add((IAction)this.addSubGroup);
        }
        if (this.editGroup.isEnabled()) {
            menuManager.add((IAction)this.editGroup);
        }
        if (this.deleteEmptyGroup.isEnabled()) {
            menuManager.add((IAction)this.deleteEmptyGroup);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.addGroup);
        menuManager.add((IAction)this.organizeGroups);
        menuManager.add((IAction)this.showEmptyGroups);
        if (this.openComponentDocumentation.isEnabled()) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.openComponentDocumentation);
            menuManager.add((IAction)this.exportComponentDocumentation);
        }
        if (this.editToolIntegration.isEnabled()) {
            menuManager.add((IAction)this.editToolIntegration);
        }
        if (this.editWorkflowIntegration.isEnabled()) {
            menuManager.add((IAction)this.editWorkflowIntegration);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.integrateTool);
        menuManager.add((IAction)this.deactivateIntegration);
        if (this.showComponentInformation.isEnabled()) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.showComponentInformation);
        }
    }

    protected void addToolbarItems(IToolBarManager toolBarManager) {
        PaletteToolbarFilterWidget toolbarFilter = new PaletteToolbarFilterWidget(this.paletteView);
        toolBarManager.add((IContributionItem)toolbarFilter);
        toolBarManager.add((IContributionItem)new Separator("Palette sorting"));
        toolBarManager.add((IAction)this.sortAscending);
        toolBarManager.add((IAction)this.sortDescending);
        toolBarManager.add((IContributionItem)new Separator("Palette collapse/expand"));
        toolBarManager.add((IAction)this.expandAll);
        toolBarManager.add((IAction)this.collapseAll);
    }

    private PaletteTreeNode[] getPaletteTreeNodesFromTreeItems(TreeItem[] selectedItems) {
        return (PaletteTreeNode[])Arrays.stream(selectedItems).map(Widget::getData).filter(PaletteTreeNode.class::isInstance).toArray(PaletteTreeNode[]::new);
    }

    protected void createActions() {
        this.organizeGroups = new ManageCustomGroupsAction(this.paletteView);
        this.sortAscending = new TreeSortAction("Sort groups alphabetically ascending", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SORT_ALPHA_ASC), 1);
        this.sortAscending.setChecked(true);
        this.sortDescending = new TreeSortAction("Sort groups alphabetically descending", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.SORT_ALPHA_DESC), -1);
        this.sortDescending.setChecked(false);
        this.collapseAll = this.createCollapseAllAction();
        this.expandAll = this.createExpandAllAction();
        this.resetGroup = this.createResetGroupAction();
        this.addGroup = this.createAddGroupAction();
        this.addSubGroup = this.createAddSubGroupAction();
        this.editGroup = this.createEditGroupAction();
        this.integrateTool = this.createIntegrateToolAction();
        this.editToolIntegration = this.createEditToolIntegrationAction();
        this.editWorkflowIntegration = this.createEditWorkflowIntegrationAction();
        this.deactivateIntegration = this.createDeactivateIntegrationAction();
        this.openComponentDocumentation = this.createOpenComponentDocumentationAction();
        this.exportComponentDocumentation = this.createExportComponentDocumentationAction();
        this.deleteEmptyGroup = this.createDeleteEmptyGroupAction();
        this.showEmptyGroups = this.createShowEmptyGroupsAction();
        this.showEmptyGroups.setChecked(this.paletteView.isShowEmptyGroups());
        this.showComponentInformation = this.createShowComponentInformationAction();
    }

    private Action createShowComponentInformationAction() {
        return new Action("Show Component Information...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.INFORMATION_16)){

            public void run() {
                Object node = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                if (node instanceof AccessibleComponentNode) {
                    ComponentInformationDialog dialog = new ComponentInformationDialog(Display.getDefault().getActiveShell(), (AccessibleComponentNode)node);
                    dialog.open();
                }
            }
        };
    }

    private Action createShowEmptyGroupsAction() {
        return new Action("Show Empty Custom Groups", 2){

            public void run() {
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                Object[] expandedElements = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getExpandedElements();
                PaletteViewActions.this.paletteView.setShowEmptyGroups(PaletteViewActions.this.showEmptyGroups.isChecked());
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            }
        };
    }

    private Action createDeleteEmptyGroupAction() {
        return new Action("Delete Group", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_DELETE)){

            public void run() {
                PaletteTreeNode node = (PaletteTreeNode)PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                if (!PaletteViewActions.this.contentProvider.containsAnyToolNodes(node, false)) {
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                    String logNodeName = StringUtils.format((String)"'%s'", (Object[])new Object[]{node.getQualifiedGroupName()});
                    if (node.hasChildren()) {
                        logNodeName = StringUtils.format((String)"%s and subgroup(s) (%s)", (Object[])new Object[]{logNodeName, String.join((CharSequence)", ", (CharSequence[])node.getAllSubGroups().stream().sorted().map(PaletteTreeNode::getQualifiedGroupName).toArray(String[]::new))});
                    }
                    PaletteViewActions.this.contentProvider.deleteGroup(node);
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
                    PaletteViewActions.this.paletteView.selectSelectionToolNode();
                    PaletteViewActions.this.log.debug((Object)StringUtils.format((String)"Deleted group %s.", (Object[])new Object[]{logNodeName}));
                } else if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Selected group contains offline components", (String)"The selected group or one of its subgroups contains at least one component that is currently not available on the network and thus does not appear in the palette.\nWould you like to open the 'Manage Custom Groups' dialog to reset the group assignment?")) {
                    PaletteViewActions.this.organizeGroups.run();
                }
            }
        };
    }

    private Action createOpenComponentDocumentationAction() {
        return new Action("Open Component Documentation"){

            public void run() {
                Object data = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                if (data instanceof AccessibleComponentNode) {
                    AccessibleComponentNode node = (AccessibleComponentNode)data;
                    ToolIntegrationDocumentationGUIHelper.getInstance().showComponentDocumentation(node.getComponentEntry().getComponentInterface().getIdentifierAndVersion(), false);
                    PaletteViewActions.this.paletteView.selectSelectionToolNode();
                }
            }
        };
    }

    private Action createExportComponentDocumentationAction() {
        return new Action("Export Component Documentation"){

            public void run() {
                Object data = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                if (data instanceof AccessibleComponentNode) {
                    AccessibleComponentNode node = (AccessibleComponentNode)data;
                    ToolIntegrationDocumentationGUIHelper.getInstance().showComponentDocumentation(node.getComponentEntry().getComponentInterface().getIdentifierAndVersion(), true);
                    PaletteViewActions.this.paletteView.selectSelectionToolNode();
                }
            }
        };
    }

    private Action createDeactivateIntegrationAction() {
        return new Action("Deactivate an Integration...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.INTEGRATION_REMOVE)){

            public void run() {
                ShowDeactivateIntegrationHandler handler = new ShowDeactivateIntegrationHandler();
                try {
                    handler.execute(new ExecutionEvent());
                    PaletteViewActions.this.paletteView.selectSelectionToolNode();
                }
                catch (ExecutionException e) {
                    PaletteViewActions.this.log.error((Object)"Opening tool deactivation wizard failed", (Throwable)e);
                }
            }
        };
    }

    private Action createEditToolIntegrationAction() {
        return new Action("Edit selected Tool Integration...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.INTEGRATION_EDIT)){

            public void run() {
                PaletteTreeNode node = (PaletteTreeNode)PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                node.handleEditEvent();
                PaletteViewActions.this.paletteView.selectSelectionToolNode();
            }
        };
    }

    private Action createEditWorkflowIntegrationAction() {
        return new Action("Edit selected Workflow Integration...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.WORKFLOW_INTEGRATION_EDIT)){

            public void run() {
                PaletteTreeNode node = (PaletteTreeNode)PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection()[0].getData();
                node.handleEditEvent();
                PaletteViewActions.this.paletteView.selectSelectionToolNode();
            }
        };
    }

    private Action createIntegrateToolAction() {
        return new Action("Integrate a Tool...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.INTEGRATION_NEW)){

            public void run() {
                ShowIntegrationWizardHandler handler = new ShowIntegrationWizardHandler();
                try {
                    handler.execute(new ExecutionEvent());
                    PaletteViewActions.this.paletteView.selectSelectionToolNode();
                }
                catch (ExecutionException e) {
                    PaletteViewActions.this.log.error((Object)"Opening Tool Integration wizard failed", (Throwable)e);
                }
            }
        };
    }

    private Action createEditGroupAction() {
        return new Action("Edit Group..", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_EDIT)){

            public void run() {
                TreeItem[] selectedItems = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection();
                PaletteTreeNode[] nodes = PaletteViewActions.this.getPaletteTreeNodesFromTreeItems(selectedItems);
                if (nodes.length > 1) {
                    return;
                }
                EditCustomGroupDialog editDialog = new EditCustomGroupDialog(Display.getDefault().getActiveShell(), nodes[0], PaletteViewActions.this.contentProvider);
                editDialog.open();
                if (editDialog.isGroupUpdated()) {
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                    Object[] expandedElements = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getExpandedElements();
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
                }
            }
        };
    }

    private Action createAddSubGroupAction() {
        return new Action("Add Subgroup...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_ADD_SUBGROUP)){

            public void run() {
                TreeItem[] selectedItems = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection();
                PaletteTreeNode[] nodes = PaletteViewActions.this.getPaletteTreeNodesFromTreeItems(selectedItems);
                if (nodes.length > 1) {
                    return;
                }
                AddCustomGroupDialog addDialog = new AddCustomGroupDialog(Display.getDefault().getActiveShell(), PaletteViewActions.this.contentProvider, nodes[0], true);
                addDialog.open();
                if (addDialog.isGroupAdded()) {
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                    PaletteViewActions.this.paletteView.expandToNode(nodes[0]);
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
                }
            }
        };
    }

    private Action createAddGroupAction() {
        return new Action("Add Custom Group...", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_ADD)){

            public void run() {
                TreeItem[] selectedItems = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection();
                PaletteTreeNode[] nodes = PaletteViewActions.this.getPaletteTreeNodesFromTreeItems(selectedItems);
                if (nodes.length > 1) {
                    return;
                }
                AddCustomGroupDialog addDialog = new AddCustomGroupDialog(Display.getDefault().getActiveShell(), PaletteViewActions.this.contentProvider, PaletteViewActions.this.contentProvider.getRootNode(), false);
                addDialog.open();
                if (addDialog.isGroupAdded()) {
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                }
            }
        };
    }

    private Action createExpandAllAction() {
        return new Action("Expand all", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.EXPAND_ALL)){

            public void run() {
                PaletteViewActions.this.paletteView.expandAll();
            }
        };
    }

    private Action createCollapseAllAction() {
        return new Action("Collapse all", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.COLLAPSE_ALL)){

            public void run() {
                PaletteViewActions.this.paletteView.collapseAll();
            }
        };
    }

    private Action createResetGroupAction() {
        return new Action("Reset to Default Group", ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.PALETTE_GROUPS_RESTORE)){

            public void run() {
                TreeItem[] selectedItems = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().getSelection();
                PaletteTreeNode[] nodes = PaletteViewActions.this.getPaletteTreeNodesFromTreeItems(selectedItems);
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
                Arrays.stream(nodes).filter(ComponentNode.class::isInstance).map(ComponentNode.class::cast).forEach(node -> {
                    Object[] expandedElements = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getExpandedElements();
                    PaletteTreeNode oldParent = node.getPaletteParent();
                    PaletteViewActions.this.contentProvider.resetGroup((ComponentNode)node);
                    PaletteViewActions.this.contentProvider.removeEmptyToolIntegrationGroups(oldParent);
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
                    PaletteViewActions.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
                    PaletteViewActions.this.paletteView.expandToNode((PaletteTreeNode)node);
                });
                PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
                PaletteViewActions.this.paletteView.selectSelectionToolNode();
                PaletteViewActions.this.paletteView.setFocus();
                Object[] objectArray = new Object[1];
                objectArray[0] = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(nodes).filter(AccessibleComponentNode.class::isInstance).map(AccessibleComponentNode.class::cast).sorted().map(node -> StringUtils.format((String)"%s (%s)", (Object[])new Object[]{node.getDisplayName(), node.getToolIdentification().getToolID()})).toArray(String[]::new));
                PaletteViewActions.this.log.debug((Object)StringUtils.format((String)"Group assignment of component(s) '%s' reset to default group(s).", (Object[])objectArray));
            }
        };
    }

    protected void setSortActionsChecked() {
        this.sortAscending.setChecked(this.paletteView.getPaletteTreeViewerComparator().getDirection() == 1);
        this.sortDescending.setChecked(this.paletteView.getPaletteTreeViewerComparator().getDirection() == -1);
    }

    private final class MoveToGroupAction
    extends Action {
        private final AccessibleComponentNode[] toolNodes;
        private final PaletteTreeNode group;

        private MoveToGroupAction(AccessibleComponentNode[] toolNodes, GroupNode group) {
            super(group.getQualifiedGroupName(), ImageDescriptor.createFromImage((Image)group.getMenuIcon()));
            this.toolNodes = toolNodes;
            this.group = group;
        }

        public void run() {
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
            Object[] expandedElements = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getExpandedElements();
            Arrays.stream(this.toolNodes).forEach(toolNode -> {
                PaletteTreeNode oldParent = toolNode.getPaletteParent();
                if (this.group.getQualifiedGroupName().equals(String.valueOf(toolNode.getGroupPathPrefix()) + toolNode.getPredefinedGroup())) {
                    PaletteViewActions.this.contentProvider.resetGroup((ComponentNode)toolNode);
                } else {
                    PaletteViewActions.this.contentProvider.updateGroup((AccessibleComponentNode)toolNode, this.group);
                }
                PaletteViewActions.this.contentProvider.removeEmptyToolIntegrationGroups(oldParent);
            });
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
            PaletteViewActions.this.paletteView.expandToNode(this.group);
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            PaletteViewActions.this.paletteView.selectSelectionToolNode();
            PaletteViewActions.this.paletteView.setFocus();
            PaletteViewActions.this.log.debug((Object)StringUtils.format((String)"Moved component(s) '%s' to group '%s'.", (Object[])new Object[]{String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.toolNodes).sorted().map(node -> StringUtils.format((String)"%s (%s)", (Object[])new Object[]{node.getDisplayName(), node.getToolIdentification().getToolID()})).toArray(String[]::new)), this.group.getQualifiedGroupName()}));
        }
    }

    private final class TreeSortAction
    extends Action {
        private int direction;

        protected TreeSortAction(String text, ImageDescriptor imageDescriptor, int direction) {
            this.setText(text);
            this.setImageDescriptor(imageDescriptor);
            this.direction = direction;
        }

        public void run() {
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(false);
            Object[] expandedElements = PaletteViewActions.this.paletteView.getPaletteTreeViewer().getExpandedElements();
            PaletteViewActions.this.paletteView.getPaletteTreeViewerComparator().setDirection(this.direction);
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().setExpandedElements(expandedElements);
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().refresh();
            PaletteViewActions.this.paletteView.getPaletteTreeViewer().getTree().setVisible(true);
            PaletteViewActions.this.setSortActionsChecked();
        }
    }
}

