/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import de.rcenvironment.core.mail.SMTPServerConfiguration;
import de.rcenvironment.core.mail.SMTPServerConfigurationService;
import de.rcenvironment.core.mail.internal.PasswordObfuscationHelper;
import java.io.IOException;

public class SMTPServerConfigurationServiceImpl
implements SMTPServerConfigurationService {
    private ConfigurationService configurationService;

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    @Override
    public SMTPServerConfiguration getSMTPServerConfiguration() {
        ConfigurationSegment mailConfigurationSegment = this.configurationService.getConfigurationSegment("smtpServer");
        if (mailConfigurationSegment != null && mailConfigurationSegment.isPresentInCurrentConfiguration()) {
            return new SMTPServerConfiguration(mailConfigurationSegment, SMTPServerConfiguration.getMailFilterInformation(this.configurationService));
        }
        return null;
    }

    @Override
    public void configureSMTPServer(String host, int port, String encryption, String username, String password, String sender) throws ConfigurationException {
        WritableConfigurationSegment mailConfig = this.configurationService.getOrCreateWritableConfigurationSegment("smtpServer");
        mailConfig.setString("host", host);
        mailConfig.setInteger("port", Integer.valueOf(port));
        mailConfig.setString("encryption", encryption);
        mailConfig.setString("username", username);
        mailConfig.setString("password", PasswordObfuscationHelper.obfuscate(password));
        mailConfig.setString("sender", sender);
        if (new SMTPServerConfiguration((ConfigurationSegment)mailConfig, SMTPServerConfiguration.getMailFilterInformation(this.configurationService)).isValid()) {
            try {
                this.configurationService.writeConfigurationChanges();
            }
            catch (IOException e) {
                throw new ConfigurationException("There was an error writing the configuration changes to the profile folder: " + e.getMessage());
            }
        } else {
            throw new ConfigurationException("TODO enter a useful error message here");
        }
    }
}

