/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.mail;

import de.rcenvironment.core.mail.InvalidMailException;
import de.rcenvironment.core.utils.common.StringUtils;
import jodd.mail.Email;
import jodd.mail.EmailAddress;
import jodd.mail.MailAddress;

public final class Mail {
    private Email email;

    private Mail() {
    }

    public static Mail createMail(String[] recipients, String subject, String text, String htmlText) throws InvalidMailException {
        if (recipients == null || recipients.length < 1) {
            throw new InvalidMailException("You need to configure at least one valid recipient.");
        }
        Email tmpEmail = new Email();
        String[] stringArray = recipients;
        int n = recipients.length;
        int n2 = 0;
        while (n2 < n) {
            String recipient = stringArray[n2];
            EmailAddress recipientEmailAddress = new EmailAddress(recipient);
            if (!recipientEmailAddress.isValid()) {
                throw new InvalidMailException(StringUtils.format((String)"The email address %s is not valid.", (Object[])new Object[]{recipient}));
            }
            tmpEmail.addTo(new MailAddress(recipientEmailAddress));
            ++n2;
        }
        if (subject == null) {
            throw new InvalidMailException("You need to specify a subject.");
        }
        tmpEmail.subject(subject);
        if (text == null && htmlText == null) {
            throw new InvalidMailException("You need to specify either a text or a HTML text.");
        }
        if (text != null) {
            tmpEmail.addText(text);
        }
        if (htmlText != null) {
            tmpEmail.addHtml(htmlText);
        }
        Mail mail = new Mail();
        mail.email = tmpEmail;
        return mail;
    }

    public Email getMail() {
        return this.email;
    }
}

