/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.util.BasicMapEntry;
import edu.uci.ics.jung.algorithms.util.MapBinaryHeap;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DijkstraDistance<V, E>
implements Distance<V> {
    protected Hypergraph<V, E> g;
    protected Function<? super E, ? extends Number> nev;
    protected Map<V, SourceData> sourceMap;
    protected boolean cached;
    protected double max_distance;
    protected int max_targets;

    public DijkstraDistance(Hypergraph<V, E> g, Function<? super E, ? extends Number> nev, boolean cached) {
        this.g = g;
        this.nev = nev;
        this.sourceMap = new HashMap<V, SourceData>();
        this.cached = cached;
        this.max_distance = Double.POSITIVE_INFINITY;
        this.max_targets = Integer.MAX_VALUE;
    }

    public DijkstraDistance(Hypergraph<V, E> g, Function<? super E, ? extends Number> nev) {
        this(g, nev, true);
    }

    public DijkstraDistance(Graph<V, E> g) {
        this(g, Functions.constant(1), true);
    }

    public DijkstraDistance(Graph<V, E> g, boolean cached) {
        this(g, Functions.constant(1), cached);
    }

    protected LinkedHashMap<V, Number> singleSourceShortestPath(V source, Collection<V> targets, int numDests) {
        SourceData sd = this.getSourceData(source);
        HashSet<V> to_get = new HashSet<V>();
        if (targets != null) {
            to_get.addAll(targets);
            Set existing_dists = sd.distances.keySet();
            for (V o : targets) {
                if (!existing_dists.contains(o)) continue;
                to_get.remove(o);
            }
        }
        if (sd.reached_max || targets != null && to_get.isEmpty() || sd.distances.size() >= numDests) {
            return sd.distances;
        }
        while (!(sd.unknownVertices.isEmpty() || sd.distances.size() >= numDests && to_get.isEmpty())) {
            Map.Entry p = sd.getNextVertex();
            Object v = p.getKey();
            double v_dist = p.getValue().doubleValue();
            to_get.remove(v);
            if (v_dist > this.max_distance) {
                sd.restoreVertex(v, v_dist);
                sd.reached_max = true;
                break;
            }
            sd.dist_reached = v_dist;
            if (sd.distances.size() >= this.max_targets) {
                sd.reached_max = true;
                break;
            }
            for (E e : this.getEdgesToCheck(v)) {
                for (V w : this.g.getIncidentVertices(e)) {
                    if (sd.distances.containsKey(w)) continue;
                    double edge_weight = this.nev.apply(e).doubleValue();
                    if (edge_weight < 0.0) {
                        throw new IllegalArgumentException("Edges weights must be non-negative");
                    }
                    double new_dist = v_dist + edge_weight;
                    if (!sd.estimatedDistances.containsKey(w)) {
                        sd.createRecord(w, e, new_dist);
                        continue;
                    }
                    double w_dist = (Double)sd.estimatedDistances.get(w);
                    if (!(new_dist < w_dist)) continue;
                    sd.update(w, e, new_dist);
                }
            }
        }
        return sd.distances;
    }

    protected SourceData getSourceData(V source) {
        SourceData sd = this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourceData(source);
        }
        return sd;
    }

    protected Collection<E> getEdgesToCheck(V v) {
        if (this.g instanceof Graph) {
            return ((Graph)this.g).getOutEdges(v);
        }
        return this.g.getIncidentEdges(v);
    }

    @Override
    public Number getDistance(V source, V target) {
        if (!this.g.containsVertex(target)) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.g);
        }
        if (!this.g.containsVertex(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        HashSet<V> targets = new HashSet<V>();
        targets.add(target);
        Map<V, Number> distanceMap = this.getDistanceMap(source, targets);
        return distanceMap.get(target);
    }

    public Map<V, Number> getDistanceMap(V source, Collection<V> targets) {
        if (!this.g.containsVertex(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (targets.size() > this.max_targets) {
            throw new IllegalArgumentException("size of target set exceeds maximum number of targets allowed: " + this.max_targets);
        }
        LinkedHashMap<V, Number> distanceMap = this.singleSourceShortestPath(source, targets, Math.min(this.g.getVertexCount(), this.max_targets));
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    @Override
    public Map<V, Number> getDistanceMap(V source) {
        return this.getDistanceMap(source, Math.min(this.g.getVertexCount(), this.max_targets));
    }

    public LinkedHashMap<V, Number> getDistanceMap(V source, int numDests) {
        if (!this.g.getVertices().contains(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (numDests < 1 || numDests > this.g.getVertexCount()) {
            throw new IllegalArgumentException("numDests must be >= 1 and <= g.numVertices()");
        }
        if (numDests > this.max_targets) {
            throw new IllegalArgumentException("numDests must be <= the maximum number of targets allowed: " + this.max_targets);
        }
        LinkedHashMap<V, Number> distanceMap = this.singleSourceShortestPath(source, null, numDests);
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    public void setMaxDistance(double max_dist) {
        this.max_distance = max_dist;
        for (V v : this.sourceMap.keySet()) {
            SourceData sd = this.sourceMap.get(v);
            sd.reached_max = this.max_distance <= sd.dist_reached || sd.distances.size() >= this.max_targets;
        }
    }

    public void setMaxTargets(int max_targets) {
        this.max_targets = max_targets;
        for (V v : this.sourceMap.keySet()) {
            SourceData sd = this.sourceMap.get(v);
            sd.reached_max = this.max_distance <= sd.dist_reached || sd.distances.size() >= max_targets;
        }
    }

    public void reset() {
        this.sourceMap = new HashMap<V, SourceData>();
    }

    public void enableCaching(boolean enable) {
        this.cached = enable;
    }

    public void reset(V source) {
        this.sourceMap.put(source, null);
    }

    protected class SourceData {
        protected LinkedHashMap<V, Number> distances = new LinkedHashMap();
        protected Map<V, Number> estimatedDistances = new HashMap();
        protected MapBinaryHeap<V> unknownVertices = new MapBinaryHeap(new VertexComparator(this.estimatedDistances));
        protected boolean reached_max = false;
        protected double dist_reached = 0.0;

        protected SourceData(V source) {
            DijkstraDistance.this.sourceMap.put((SourceData)source, this);
            this.estimatedDistances.put((Number)source, new Double(0.0));
            this.unknownVertices.add(source);
            this.reached_max = false;
            this.dist_reached = 0.0;
        }

        protected Map.Entry<V, Number> getNextVertex() {
            Object v = this.unknownVertices.remove();
            Double dist = (Double)this.estimatedDistances.remove(v);
            this.distances.put((Number)v, dist);
            return new BasicMapEntry(v, dist);
        }

        protected void update(V dest, E tentative_edge, double new_dist) {
            this.estimatedDistances.put((Number)dest, new_dist);
            this.unknownVertices.update(dest);
        }

        protected void createRecord(V w, E e, double new_dist) {
            this.estimatedDistances.put((Number)w, new_dist);
            this.unknownVertices.add(w);
        }

        protected void restoreVertex(V v, double dist) {
            this.estimatedDistances.put((Number)v, dist);
            this.unknownVertices.add(v);
            this.distances.remove(v);
        }
    }

    protected static class VertexComparator<V>
    implements Comparator<V> {
        private Map<V, Number> distances;

        protected VertexComparator(Map<V, Number> distances) {
            this.distances = distances;
        }

        @Override
        public int compare(V o1, V o2) {
            return ((Double)this.distances.get(o1)).compareTo((Double)this.distances.get(o2));
        }
    }
}

