/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.regex.Pattern;

public final class LogArchiver {
    private static final Pattern CURRENT_LOG_FILE_PATTERN = Pattern.compile("^(debug|warnings)\\.(log(\\.\\d+)?)$");
    private static final Pattern ARCHIVED_LOG_FILE_PATTERN = Pattern.compile("^(\\w+)\\.(previous\\.log(\\.\\d+)?)$");
    private static final String CURRENT_TO_ARCHIVED_LOG_FILE_REPLACEMENT = "$1.previous.$2";

    private LogArchiver() {
    }

    public static void run(File directory) {
        LogArchiver.deleteOldArchiveFiles(directory);
        LogArchiver.archiveLastRunsLogs(directory);
    }

    private static void deleteOldArchiveFiles(File directory) {
        File[] oldArchiveFiles;
        PrintStream sysErr = System.err;
        File[] fileArray = oldArchiveFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && ARCHIVED_LOG_FILE_PATTERN.matcher(file.getName()).matches();
            }
        });
        int n = oldArchiveFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File oldFile = fileArray[n2];
            try {
                Files.delete(oldFile.toPath());
                if (oldFile.exists()) {
                    sysErr.println("ERROR: Failed to delete archived log file " + oldFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                sysErr.println("ERROR: Failed to delete archived log file " + oldFile.getAbsolutePath() + ": " + e.toString());
            }
            ++n2;
        }
    }

    private static void archiveLastRunsLogs(File directory) {
        File[] lastRunsLogs;
        PrintStream sysErr = System.err;
        File[] fileArray = lastRunsLogs = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && CURRENT_LOG_FILE_PATTERN.matcher(file.getName()).matches();
            }
        });
        int n = lastRunsLogs.length;
        int n2 = 0;
        while (n2 < n) {
            File logFile = fileArray[n2];
            String oldName = logFile.getName();
            String newName = CURRENT_LOG_FILE_PATTERN.matcher(oldName).replaceFirst(CURRENT_TO_ARCHIVED_LOG_FILE_REPLACEMENT);
            File archiveFile = new File(logFile.getParentFile(), newName);
            try {
                Files.move(logFile.toPath(), archiveFile.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                sysErr.println("ERROR: Failed to archive the previous run's log file " + logFile.getAbsolutePath() + " as " + archiveFile.getAbsolutePath());
            }
            ++n2;
        }
    }
}

