/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;

public final class AdapterManager
implements IAdapterManager {
    private static final AdapterManager INSTANCE = new AdapterManager();
    private static final Map<Class<?>, List<IAdapterFactory>> MAPPINGS = new HashMap();

    private AdapterManager() {
    }

    public static AdapterManager getInstance() {
        return INSTANCE;
    }

    public String[] computeAdapterTypes(Class adaptableClass) {
        return Platform.getAdapterManager().computeAdapterTypes(adaptableClass);
    }

    public Class[] computeClassOrder(Class clazz) {
        return Platform.getAdapterManager().computeClassOrder(clazz);
    }

    public Object getAdapter(Object adaptable, Class adapterType) {
        Object result = null;
        if (adaptable == null || adapterType == null) {
            throw new IllegalArgumentException();
        }
        Class<?> adaptableType = adaptable.getClass();
        if (adapterType.isAssignableFrom(adaptableType)) {
            result = adaptable;
        } else {
            for (Map.Entry<Class<?>, List<IAdapterFactory>> entry : MAPPINGS.entrySet()) {
                Class<?> entryType = entry.getKey();
                if (!entryType.isAssignableFrom(adaptableType)) continue;
                List<IAdapterFactory> factories = entry.getValue();
                for (IAdapterFactory factory : factories) {
                    Class[] classArray = factory.getAdapterList();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object adapter;
                        Class supportedAdapterType = classArray[n2];
                        if (adapterType.isAssignableFrom(supportedAdapterType) && (adapter = factory.getAdapter(adaptable, supportedAdapterType)) != null) {
                            result = adapter;
                        }
                        ++n2;
                    }
                }
            }
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(adaptableType, adapterType);
        }
        return result;
    }

    public Object getAdapter(Object adaptable, String adapterTypeName) {
        try {
            Class<?> adapterType = Class.forName(adapterTypeName);
            return this.getAdapter(adaptable, adapterType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getAdapter(adaptable, adapterTypeName) != null;
    }

    public int queryAdapter(Object adaptable, String adapterTypeName) {
        if (this.getAdapter(adaptable, adapterTypeName) != null) {
            return 2;
        }
        return 0;
    }

    public Object loadAdapter(Object adaptable, String adapterTypeName) {
        return null;
    }

    public void registerAdapters(IAdapterFactory factory, Class adaptable) {
        List<IAdapterFactory> mapping;
        if (MAPPINGS.get(adaptable) == null) {
            MAPPINGS.put(adaptable, new LinkedList());
        }
        if (!(mapping = MAPPINGS.get(adaptable)).contains(factory)) {
            mapping.add(factory);
        }
    }

    public void unregisterAdapters(IAdapterFactory factory) {
        for (Map.Entry<Class<?>, List<IAdapterFactory>> entry : MAPPINGS.entrySet()) {
            entry.getValue().remove(factory);
        }
    }

    public void unregisterAdapters(IAdapterFactory factory, Class adaptable) {
        if (MAPPINGS.get(adaptable) == null || !MAPPINGS.get(adaptable).contains(factory)) {
            return;
        }
        MAPPINGS.get(adaptable).remove(factory);
    }
}

