/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.authorization;

import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.gui.authorization.ExportGroupKeyDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;

public final class ExportGroupKeyAction
extends SelectionProviderAction {
    private AuthorizationService authorizationService;

    public ExportGroupKeyAction(ISelectionProvider selectionProvider, AuthorizationService authorizationService) {
        super(selectionProvider, "Export Group Key...");
        this.authorizationService = authorizationService;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof AuthorizationAccessGroup)) {
            return;
        }
        Display display = Display.getDefault();
        Shell shell = display.getActiveShell();
        ExportGroupKeyDialog exportGroupKeyDialog = new ExportGroupKeyDialog(shell, this.authorizationService.exportToString((AuthorizationAccessGroup)selection.getFirstElement()));
        exportGroupKeyDialog.open();
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object selectedGroup = selection.getFirstElement();
        if (selection.size() == 1 && selectedGroup instanceof AuthorizationAccessGroup && !this.authorizationService.isPublicAccessGroup((AuthorizationAccessGroup)selectedGroup)) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }
}

